/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.machines.CoalGeneratorEntity;
import com.st0x0ef.stellaris.common.data_components.RadioactiveComponent;
import com.st0x0ef.stellaris.common.menus.RadioactiveGeneratorMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class RadioactiveGeneratorEntity
extends CoalGeneratorEntity {
    public RadioactiveGeneratorEntity(BlockPos blockPos, BlockState blockState) {
        super(BlockEntityRegistry.RADIOACTIVE_GENERATOR.get(), blockPos, blockState, 500, 1000000);
    }

    @Override
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new RadioactiveGeneratorMenu(containerId, inventory, (Container)this, this, this.dataAccess);
    }

    @Override
    protected int getBurnDuration(ItemStack fuelStack) {
        if (fuelStack.isEmpty()) {
            return 0;
        }
        if (fuelStack.has((DataComponentType)DataComponentsRegistry.RADIOACTIVE.get())) {
            RadioactiveComponent radiationItem = (RadioactiveComponent)fuelStack.get((DataComponentType)DataComponentsRegistry.RADIOACTIVE.get());
            if (radiationItem.isBlock()) {
                return switch (radiationItem.level()) {
                    case 0 -> 1800;
                    case 1 -> 4500;
                    case 2 -> 9000;
                    default -> 0;
                };
            }
            return switch (radiationItem.level()) {
                case 0 -> 200;
                case 1 -> 500;
                case 2 -> 1000;
                default -> 0;
            };
        }
        return 0;
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.radioactive_generator");
    }
}

