/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.oil.OilUtils;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class StellarisCommands {
    public StellarisCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"stellaris").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"oil").requires(c -> c.hasPermission(2))).then(Commands.literal((String)"set").then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            Level patt0$temp;
            if (((CommandSourceStack)context.getSource()).getPlayer() != null && (patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer().level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                OilUtils.setOilLevel(serverLevel, ((CommandSourceStack)context.getSource()).getPlayer().chunkPosition(), (Integer)context.getArgument("level", Integer.class));
            }
            return 0;
        })))).then(Commands.literal((String)"get").executes(context -> {
            Level patt0$temp;
            if (((CommandSourceStack)context.getSource()).getPlayer() != null && (patt0$temp = ((CommandSourceStack)context.getSource()).getPlayer().level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                OilUtils.getOilLevel(serverLevel, ((CommandSourceStack)context.getSource()).getPlayer().chunkPosition());
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"screen").requires(c -> c.hasPermission(2))).then(Commands.literal((String)"galaxyScreen").executes(context -> {
            PlanetUtil.openMilkyWayMenu((Player)((CommandSourceStack)context.getSource()).getPlayer());
            return 0;
        }))).then(Commands.literal((String)"tablet").executes(context -> {
            PlanetUtil.openTabletMenu((Player)((CommandSourceStack)context.getSource()).getPlayer(), ResourceLocation.parse((String)"null:null"));
            return 0;
        }))).then(Commands.literal((String)"waitScreen").executes(context -> {
            PlanetUtil.openWaitMenu((Player)((CommandSourceStack)context.getSource()).getPlayer(), ((CommandSourceStack)context.getSource()).getPlayer().getDisplayName().getString());
            return 0;
        }))).then(Commands.literal((String)"planetScreen").executes(context -> {
            PlanetUtil.openPlanetSelectionMenu((Player)((CommandSourceStack)context.getSource()).getPlayer(), true);
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"dev").requires(c -> c.hasPermission(2))).then(Commands.literal((String)"dumpPlanetInfos").executes(context -> {
            for (Planet planet : StellarisData.getPlanets()) {
                Stellaris.LOG.info(planet.name());
                Stellaris.LOG.info("[br] [br] Temperature : [color=red]{}\u00b0c [br] Gravity : [color=red]{} [br] Oxygen : [color=red]{} [br] Distance From Earth : {}km", new Object[]{Float.valueOf(planet.temperature()), Float.valueOf(planet.gravity()), planet.oxygen(), planet.distanceFromEarth()});
            }
            return 0;
        }))));
    }
}

