/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.config.ConfigEntry;
import dev.architectury.platform.Platform;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class CustomConfig {
    public static Map<String, ConfigEntry<?>> CONFIG = new HashMap();

    public static void init() {
        CustomConfig.loadConfigFile();
        CustomConfig.addEntries();
        CustomConfig.writeConfigFile("stellaris.json");
    }

    public static void addEntries() {
        CustomConfig.addEntry("planetScreenGravityColor", new ConfigEntry<String>("White", ""));
    }

    public static void addEntry(String name, ConfigEntry<?> entry) {
        CONFIG.merge(name, entry, (a, b) -> new ConfigEntry(a.value(), b.description()));
    }

    public static void writeConfigFile(String path) {
        try {
            FileWriter file = new FileWriter(String.valueOf(Platform.getConfigFolder()) + "/" + path);
            file.write(Stellaris.GSON.toJson(CONFIG));
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadConfigFile() {
        String path = String.valueOf(Platform.getConfigFolder()) + "/stellaris.json";
        try {
            String jsonString = CustomConfig.readFileAsString(path);
            JsonObject jsonObject = (JsonObject)Stellaris.GSON.fromJson(jsonString, JsonObject.class);
            jsonObject.getAsJsonObject().entrySet().forEach(entry -> {
                ConfigEntry obj2 = (ConfigEntry)Stellaris.GSON.fromJson((JsonElement)entry.getValue(), ConfigEntry.class);
                CONFIG.put((String)entry.getKey(), obj2);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readFileAsString(String file) throws Exception {
        return new String(Files.readAllBytes(Paths.get(file, new String[0])));
    }

    public static Object getValue(String key) {
        return CONFIG.get(key).value();
    }
}

