/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.blocks.entities.machines.RocketStationEntity;
import com.st0x0ef.stellaris.common.data.recipes.input.RocketStationInput;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record RocketStationRecipe(List<Ingredient> recipeItems, ItemStack output) implements Recipe<RocketStationInput>
{
    public static RecipeType<RocketStationRecipe> Type = (RecipeType)RecipesRegistry.ROCKET_STATION_TYPE.get();

    public boolean matches(RocketStationInput container, Level level) {
        for (int i = 0; i < ((RocketStationEntity)container.entity()).getContainerSize() - 1; ++i) {
            if (this.recipeItems.get(i).test(container.getItem(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(RocketStationInput container, HolderLookup.Provider provider) {
        return this.output;
    }

    public RecipeSerializer<? extends Recipe<RocketStationInput>> getSerializer() {
        return (RecipeSerializer)RecipesRegistry.ROCKET_STATION.get();
    }

    public RecipeType<? extends Recipe<RocketStationInput>> getType() {
        return Type;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create(this.recipeItems());
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public static class Serializer
    implements RecipeSerializer<RocketStationRecipe> {
        public static final MapCodec<RocketStationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf(1, 14).fieldOf("ingredients").forGetter(r -> r.recipeItems), (App)ItemStack.CODEC.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)instance, RocketStationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, List<Ingredient>> INGREDIENT_LIST_STREAM_CODEC = ByteBufCodecs.collection(ArrayList::new, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, (int)14);
        public static final StreamCodec<RegistryFriendlyByteBuf, RocketStationRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            INGREDIENT_LIST_STREAM_CODEC.encode(buf, recipe.recipeItems);
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output);
        }, buf -> new RocketStationRecipe((List)INGREDIENT_LIST_STREAM_CODEC.decode(buf), (ItemStack)ItemStack.STREAM_CODEC.decode(buf)));

        public MapCodec<RocketStationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RocketStationRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

