/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data_components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import com.st0x0ef.stellaris.common.vehicle_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.SpeedUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.TankUpgrade;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public record RoverComponent(String fuelType, int fuel, ResourceLocation fuelTexture, int tankCapacity, float speedModifier) implements Serializable
{
    public static final Codec<RoverComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("fuel_type").forGetter(RoverComponent::fuelType), (App)Codec.INT.fieldOf("fuel").forGetter(RoverComponent::fuel), (App)ResourceLocation.CODEC.fieldOf("fuel_texture").forGetter(RoverComponent::fuelTexture), (App)Codec.INT.fieldOf("fuel_capacity").forGetter(RoverComponent::tankCapacity), (App)Codec.FLOAT.fieldOf("speed_modifier").forGetter(RoverComponent::speedModifier)).apply((Applicative)instance, RoverComponent::new));
    public static final StreamCodec<ByteBuf, RoverComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, RoverComponent::fuelType, (StreamCodec)ByteBufCodecs.INT, RoverComponent::fuel, (StreamCodec)ResourceLocation.STREAM_CODEC, RoverComponent::fuelTexture, (StreamCodec)ByteBufCodecs.INT, RoverComponent::tankCapacity, (StreamCodec)ByteBufCodecs.FLOAT, RoverComponent::speedModifier, RoverComponent::new);

    public int getFuel() {
        return this.fuel;
    }

    @Deprecated
    public ResourceLocation getFuelTexture() {
        return this.getFuelType().getFuelTexture();
    }

    public MotorUpgrade getMotorUpgrade() {
        return new MotorUpgrade(this.getFuelType().getMotorType());
    }

    public FuelType.Type getFuelType() {
        FuelType.Type type = FuelType.Type.fromString(this.fuelType);
        if (type != null) {
            return type;
        }
        Item item = FuelType.getItemBasedOnLoacation(ResourceLocation.parse((String)this.fuelType));
        type = FuelType.Type.getTypeBasedOnItem(item);
        if (type != null) {
            return type;
        }
        return FuelType.Type.FUEL;
    }

    public TankUpgrade getTankUpgrade() {
        return new TankUpgrade(this.tankCapacity);
    }

    public static RoverComponent fromNetwork(RegistryFriendlyByteBuf buffer) {
        return new RoverComponent(buffer.readUtf(), buffer.readInt(), buffer.readResourceLocation(), buffer.readInt(), buffer.readFloat());
    }

    public RegistryFriendlyByteBuf toNetwork(RegistryFriendlyByteBuf buffer) {
        buffer.writeUtf(this.fuelType);
        buffer.writeInt(this.fuel);
        buffer.writeResourceLocation(this.fuelTexture);
        buffer.writeInt(this.tankCapacity);
        buffer.writeFloat(this.speedModifier);
        return buffer;
    }

    public int getTankCapacity() {
        return this.tankCapacity;
    }

    public SpeedUpgrade getSpeedUpgrade() {
        return new SpeedUpgrade(this.speedModifier);
    }
}

