/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.mobs.cheese_boss;

import com.mojang.serialization.Dynamic;
import com.st0x0ef.stellaris.client.renderers.entities.cheeseboss.CheeseBossRenderState;
import com.st0x0ef.stellaris.common.entities.mobs.cheese_boss.CheeseBossAi;
import com.st0x0ef.stellaris.common.entities.mobs.cheese_boss.attack_entities.CheeseSpit;
import com.st0x0ef.stellaris.common.entities.mobs.cheese_boss.goals.CheeseMeleeAttackGoal;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import dev.architectury.networking.NetworkManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CheeseBoss
extends Monster
implements Enemy,
RangedAttackMob {
    private boolean spitting = false;
    private static final Component CHEESE_BOSS_NAME_COMPONENT = Component.translatable((String)"event.stellaris.cheeseboss");
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(CHEESE_BOSS_NAME_COMPONENT, BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    private CheeseBossRenderState renderStateInstance;

    public CheeseBoss(EntityType<? extends CheeseBoss> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.MAX_HEALTH, 500.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8).add(Attributes.ATTACK_KNOCKBACK, 1.2).add(Attributes.ATTACK_DAMAGE, 6.0);
    }

    private void setupAnimationStates(CheeseBossRenderState state) {
        if (state.idleAnimationTimeout <= 0) {
            state.idleAnimationTimeout = 20;
            state.idleAnimationState.start(this.tickCount);
        } else {
            --state.idleAnimationTimeout;
        }
        if (state.punchingAnimationTimeout <= 0 && this.isPunching()) {
            state.punchingAnimationTimeout = 20;
            this.setPunching(false);
            state.punchAnimationState.start(this.tickCount);
        } else {
            --state.punchingAnimationTimeout;
        }
        if (state.spittingAnimationTimeout <= 0 && this.isSpitting()) {
            state.spittingAnimationTimeout = 30;
            this.setSpitting(false);
            state.spitAnimationState.start(this.tickCount);
        } else {
            --state.spittingAnimationTimeout;
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates(this.getRenderStateInstance());
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 35.0f));
        this.goalSelector.addGoal(2, (Goal)new CheeseMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 100, 30.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(6, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.bossEvent.addPlayer(serverPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.bossEvent.removePlayer(serverPlayer);
    }

    public void setPunching(boolean punching) {
        this.getRenderStateInstance().punching = punching;
    }

    public boolean isPunching() {
        return this.getRenderStateInstance().punching;
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
    }

    public void setSpitting(boolean spitting) {
        this.spitting = spitting;
    }

    public boolean isSpitting() {
        return this.spitting;
    }

    private void spit(LivingEntity target) {
        CheeseSpit cheeseSpit = CheeseSpit.fromLevelAndEntity(this.level(), this);
        double d = target.getX() - this.getX();
        double e = target.getY(0.3333333333333333) - cheeseSpit.getY();
        double f = target.getZ() - this.getZ();
        double g = Math.sqrt(d * d + f * f) * (double)0.2f;
        cheeseSpit.shoot(d, e + g, f, 1.5f, 10.0f);
        if (!this.isSilent()) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.LLAMA_SPIT, this.getSoundSource(), 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        }
        this.level().addFreshEntity((Entity)cheeseSpit);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return NetworkManager.createAddEntityPacket((Entity)this, (ServerEntity)entity);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return CheeseBossAi.makeBrain(this, dynamic);
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (this.level() != entity.level()) {
            return false;
        }
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity)) {
            return false;
        }
        if (this.isAlliedTo(entity)) {
            return false;
        }
        if (livingEntity.getType() == EntityType.ARMOR_STAND) {
            return false;
        }
        if (livingEntity.getType() == EntityRegistry.CHEESE_BOSS.get()) {
            return false;
        }
        if (livingEntity.isInvulnerable()) {
            return false;
        }
        if (livingEntity.isDeadOrDying()) {
            return false;
        }
        return this.level().getWorldBorder().isWithinBounds(livingEntity.getBoundingBox());
    }

    public CheeseBossRenderState getRenderStateInstance() {
        if (!this.level().isClientSide()) {
            return null;
        }
        if (this.renderStateInstance == null) {
            this.renderStateInstance = new CheeseBossRenderState();
        }
        return this.renderStateInstance;
    }
}

