/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles;

import com.st0x0ef.stellaris.common.entities.vehicles.IVehicleEntity;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.menus.LanderMenu;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LanderEntity
extends IVehicleEntity
implements HasCustomInventoryScreen {
    protected SimpleContainer inventory = new SimpleContainer(15);
    private boolean landed = false;

    public LanderEntity(Level level) {
        this((EntityType<? extends LanderEntity>)((EntityType)EntityRegistry.LANDER.get()), level);
    }

    public LanderEntity(EntityType<? extends LanderEntity> type, Level level) {
        super((EntityType)EntityRegistry.LANDER.get(), level);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void push(Entity entity) {
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.getDimensions(this.getPose()), 1.0f)).add(0.0, 2.0, 0.0);
    }

    public void kill(ServerLevel level) {
        this.dropEquipment();
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float f) {
        if (damageSource.getEntity() != null && damageSource.getEntity().isCrouching() && !this.isVehicle()) {
            this.dropEquipment();
            if (!this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    public boolean causeFallDamage(double d, float f, DamageSource damageSource) {
        if (d > 5.0 && !this.level().isClientSide) {
            this.level().explode(null, this.getX(), this.getY(), this.getZ(), 10.0f, true, Level.ExplosionInteraction.TNT);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return super.causeFallDamage(d, f, damageSource);
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getItems().size(); ++i) {
            Level level;
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || !((level = this.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnAtLocation(serverLevel, itemstack);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.put("InventoryCustom", (Tag)this.inventory.createTag((HolderLookup.Provider)this.registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.getList("InventoryCustom").isPresent()) {
            ListTag inventoryCustom = (ListTag)compound.getList("InventoryCustom").get();
            this.inventory.fromTag(inventoryCustom, (HolderLookup.Provider)this.registryAccess());
        }
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        super.interact(player, hand);
        InteractionResult.Success result = InteractionResult.SUCCESS;
        if (!this.level().isClientSide) {
            if (player.isCrouching()) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.CONSUME;
            }
            player.startRiding((Entity)this);
            return InteractionResult.CONSUME;
        }
        return result;
    }

    @Override
    public void tick() {
        super.tick();
        if (KeyVariables.isHoldingJump(this.getFirstPlayerPassenger())) {
            this.slowDownLander();
        }
        if (this.onGround() && !this.landed) {
            this.landed = true;
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
    }

    public Player getFirstPlayerPassenger() {
        Object e;
        if (!this.getPassengers().isEmpty() && (e = this.getPassengers().getFirst()) instanceof Player) {
            Player player = (Player)e;
            return player;
        }
        return null;
    }

    public void slowDownLander() {
        Vec3 vec = this.getDeltaMovement();
        if (!this.onGround()) {
            if (vec.y() < -0.05) {
                this.setDeltaMovement(vec.x(), vec.y() * 0.75, vec.z());
            }
            this.fallDistance = (float)(vec.y() * -1.0 * 4.5);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                for (ServerPlayer player : level2.getServer().getPlayerList().getPlayers()) {
                    level2.sendParticles(player, (ParticleOptions)ParticleTypes.SPIT, true, true, this.getX(), this.getY() - 0.3, this.getZ(), 3, 0.1, 0.1, 0.1, 0.001);
                }
            }
        }
    }

    public void openCustomInventoryScreen(Player player) {
        MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buf) {
            }

            public Component getDisplayName() {
                return Component.translatable((String)"container.entity.stellaris.lander");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
                return new LanderMenu(id, playerInv, (Container)LanderEntity.this.inventory);
            }
        });
    }

    public Container getInventory() {
        return this.inventory;
    }

    public boolean isLanded() {
        return this.landed;
    }
}

