/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles;

import com.google.common.collect.Sets;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.RocketModel;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data_components.RocketComponent;
import com.st0x0ef.stellaris.common.entities.vehicles.IVehicleEntity;
import com.st0x0ef.stellaris.common.items.VehicleUpgradeItem;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.menus.RocketMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncRocketComponentPacket;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.SoundRegistry;
import com.st0x0ef.stellaris.common.registry.StatsRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import com.st0x0ef.stellaris.common.vehicle_upgrade.ModelUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.SkinUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.TankUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.VehicleUpgrade;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RocketEntity
extends IVehicleEntity
implements HasCustomInventoryScreen {
    public int START_TIMER;
    public boolean needsModelChange = false;
    public SkinUpgrade SKIN_UPGRADE;
    public ModelUpgrade MODEL_UPGRADE;
    public MotorUpgrade MOTOR_UPGRADE;
    public TankUpgrade TANK_UPGRADE;
    protected SimpleContainer inventory;
    private RocketComponent rocketComponent;
    private Player lastPlayer;
    private static final EntityDataAccessor<String> DATA_SKIN = SynchedEntityData.defineId(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> ROCKET_START;
    private static final EntityDataAccessor<String> DATA_MODEL;

    public RocketEntity(EntityType<? extends RocketEntity> entityType, Level level) {
        this(entityType, level, SkinUpgrade.getBasic());
    }

    protected RocketEntity(EntityType<? extends RocketEntity> entityType, Level level, SkinUpgrade skinUpgrade) {
        super(entityType, level);
        this.SKIN_UPGRADE = skinUpgrade;
        this.MODEL_UPGRADE = ModelUpgrade.getBasic();
        this.MOTOR_UPGRADE = MotorUpgrade.getBasic();
        this.TANK_UPGRADE = TankUpgrade.getBasic();
        this.START_TIMER = 0;
        this.FUEL = 0;
        this.FUEL_TYPE = FuelType.Type.FUEL;
        this.rocketComponent = new RocketComponent(this.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(this.MODEL_UPGRADE.getModel().toString()), this.FUEL_TYPE.getSerializedName(), this.FUEL, this.FUEL_TYPE.getFuelTexture(), this.TANK_UPGRADE.getTankCapacity());
        this.inventory = new SimpleContainer(14);
    }

    public void setRocketComponent(RocketComponent rocketComponent) {
        this.rocketComponent = rocketComponent;
        this.MODEL_UPGRADE = rocketComponent.getModelUpgrade();
        this.SKIN_UPGRADE = rocketComponent.getSkinUpgrade();
        this.MOTOR_UPGRADE = rocketComponent.getMotorUpgrade();
        this.TANK_UPGRADE = rocketComponent.getTankUpgrade();
        this.FUEL = rocketComponent.getFuel();
        this.FUEL_TYPE = rocketComponent.getFuelType();
    }

    @Override
    public boolean setPassengersRiding() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getY() > 600.0) {
            this.openPlanetMenu(this.getFirstPlayerPassenger());
            this.getPassengers().forEach(entity -> {
                Player passenger;
                if (entity instanceof Player && !(passenger = (Player)entity).is((Entity)this.getFirstPlayerPassenger())) {
                    this.openWaitMenu(passenger);
                }
            });
        }
        this.rocketExplosion();
        this.burnEntities();
        this.checkContainer();
        if (KeyVariables.isHoldingJump(this.getFirstPlayerPassenger())) {
            this.startRocket();
        }
        if (((Boolean)this.entityData.get(ROCKET_START)).booleanValue()) {
            this.spawnParticle();
            this.startTimerAndFlyMovement();
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.put("InventoryCustom", (Tag)this.inventory.createTag((HolderLookup.Provider)this.registryAccess()));
        compound.putInt("fuel", this.FUEL);
        if (this.FUEL != 0) {
            compound.putString("currentFuelItemType", this.FUEL_TYPE.getSerializedName());
        }
        ListTag listTag = new ListTag();
        for (int i = 1; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemStack = this.inventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)(i - 1));
            listTag.add((Object)itemStack.save((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag));
        }
        compound.put("Items", (Tag)listTag);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.getList("InventoryCustom").isPresent()) {
            ListTag inventoryCustom = (ListTag)compound.getList("InventoryCustom").get();
            this.inventory.fromTag(inventoryCustom, (HolderLookup.Provider)this.registryAccess());
        }
        if (compound.getInt("fuel").isPresent()) {
            this.FUEL = (Integer)compound.getInt("fuel").get();
        }
        if (this.FUEL != 0 && compound.getString("currentFuelItemType").isPresent()) {
            this.FUEL_TYPE = FuelType.Type.fromString((String)compound.getString("currentFuelItemType").get());
        }
        if (compound.getList("Items").isPresent()) {
            ListTag listTag = (ListTag)compound.getList("Items").get();
            for (int i = 0; i < listTag.size(); ++i) {
                int j;
                CompoundTag compoundTag;
                if (!listTag.getCompound(i).isPresent() || !(compoundTag = (CompoundTag)listTag.getCompound(i).get()).getByte("Slot").isPresent() || (j = (Byte)compoundTag.getByte("Slot").get() & 0xFF) >= this.inventory.getContainerSize() - 1) continue;
                this.inventory.setItem(j + 1, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag).orElse(ItemStack.EMPTY));
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SKIN, (Object)SkinUpgrade.getBasic().getRocketSkinLocation().toString());
        builder.define(DATA_MODEL, (Object)ModelUpgrade.getBasic().getModel().toString());
        builder.define(ROCKET_START, (Object)false);
    }

    public SkinUpgrade getSkinData() {
        return new SkinUpgrade(ResourceLocation.parse((String)((String)this.entityData.get(DATA_SKIN))));
    }

    public void setSkinData() {
        this.entityData.set(DATA_SKIN, (Object)this.SKIN_UPGRADE.getRocketSkinLocation().toString());
    }

    public ModelUpgrade getModelData() {
        return new ModelUpgrade(RocketModel.fromString((String)this.entityData.get(DATA_MODEL)));
    }

    public void setModelData() {
        this.entityData.set(DATA_MODEL, (Object)this.MODEL_UPGRADE.getModel().toString());
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        super.interact(player, hand);
        InteractionResult.Success result = InteractionResult.SUCCESS;
        if (!this.level().isClientSide) {
            if (player.isCrouching()) {
                if (!this.tryFillUpRocket(player.getMainHandItem().getItem())) {
                    this.openCustomInventoryScreen(player);
                } else {
                    player.getItemInHand(hand).shrink(1);
                    player.getInventory().add(new ItemStack((ItemLike)Items.BUCKET));
                }
                return InteractionResult.CONSUME;
            }
            if (this.canPlayerRide()) {
                this.doPlayerRide((Entity)player);
            }
            return InteractionResult.CONSUME;
        }
        return result;
    }

    public boolean canPlayerRide() {
        int maxPlayer = this.MODEL_UPGRADE.getModel().getMaxPlayerNumber();
        return this.getPassengers().size() < maxPlayer;
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.getDimensions(this.getPose()), 1.0f)).subtract(0.0, 3.15, 0.0);
    }

    public void openCustomInventoryScreen(Player player) {
        this.lastPlayer = player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(FriendlyByteBuf packetByteBuf) {
                    packetByteBuf.writeVarInt(RocketEntity.this.getId());
                }

                public Component getDisplayName() {
                    return Component.literal((String)"Rocket");
                }

                public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeInt(RocketEntity.this.FUEL);
                    packetBuffer.writeVarInt(RocketEntity.this.getId());
                    return new RocketMenu(syncId, inv, (Container)RocketEntity.this.inventory, RocketEntity.this.getId());
                }
            });
        }
    }

    public void kill(ServerLevel level) {
        this.dropEquipment();
        this.spawnRocketItem();
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        Entity sourceEntity = source.getEntity();
        if (sourceEntity != null && sourceEntity.isCrouching() && !this.isVehicle()) {
            this.spawnRocketItem();
            this.dropEquipment();
            if (!this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity livingEntity) {
        Vec3[] avector3d = new Vec3[]{RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)livingEntity.getYRot()), RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(livingEntity.getYRot() - 22.5f)), RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(livingEntity.getYRot() + 22.5f)), RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(livingEntity.getYRot() - 45.0f)), RocketEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)livingEntity.getBbWidth(), (float)(livingEntity.getYRot() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.getBoundingBox().maxY;
        double d1 = this.getBoundingBox().minY - 0.5;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Vec3 vector3d : avector3d) {
            blockpos$mutable.set(this.getX() + vector3d.x, d0, this.getZ() + vector3d.z);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.immutable());
                blockpos$mutable.move(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.level().getFluidState(blockpos).is(FluidTags.LAVA) || !DismountHelper.isBlockFloorValid((double)(d3 = this.level().getBlockFloorHeight(blockpos)))) continue;
            Vec3 vector3d1 = Vec3.upFromBottomCenterOf((Vec3i)blockpos, (double)d3);
            for (Pose pose : livingEntity.getDismountPoses()) {
                if (!DismountHelper.isBlockFloorValid((double)this.level().getBlockFloorHeight(blockpos))) continue;
                livingEntity.setPose(pose);
                return vector3d1;
            }
        }
        return new Vec3(this.getX(), this.getBoundingBox().maxY, this.getZ());
    }

    @Nullable
    public ItemStack getPickResult() {
        return null;
    }

    public void spawnParticle() {
        block4: {
            Level level = this.level();
            if (!(level instanceof ServerLevel)) break block4;
            ServerLevel level2 = (ServerLevel)level;
            Vec3 vec = this.getDeltaMovement();
            if (this.START_TIMER == 200) {
                for (ServerPlayer player : level2.getServer().getPlayerList().getPlayers()) {
                    level2.sendParticles(player, (ParticleOptions)ParticleTypes.FLAME, true, true, this.getX() - vec.x, this.getY() - vec.y - 2.2, this.getZ() - vec.z, 20, 0.1, 0.1, 0.1, 0.001);
                    level2.sendParticles(player, (ParticleOptions)ParticleTypes.FLAME, true, true, this.getX() - vec.x, this.getY() - vec.y - 3.2, this.getZ() - vec.z, 10, 0.1, 0.1, 0.1, 0.04);
                }
            } else {
                for (ServerPlayer player : level2.getServer().getPlayerList().getPlayers()) {
                    level2.sendParticles(player, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, true, this.getX() - vec.x, this.getY() - vec.y - 0.1, this.getZ() - vec.z, 6, 0.1, 0.1, 0.1, 0.023);
                }
            }
        }
    }

    public void startRocket() {
        Player player = this.getFirstPlayerPassenger();
        if (player != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.syncRocketData(serverPlayer);
            }
            if (this.FUEL > 0 || player.isCreative()) {
                if (!((Boolean)this.entityData.get(ROCKET_START)).booleanValue()) {
                    this.entityData.set(ROCKET_START, (Object)true);
                    player.awardStat((ResourceLocation)StatsRegistry.ROCKET_LAUNCHED.get());
                    this.level().playSound((Entity)player, (Entity)this, (SoundEvent)SoundRegistry.ROCKET_SOUND.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.stellaris.rocket.fuel", (Object[])new Object[]{this.MOTOR_UPGRADE.getFuelType().getSerializedName()}), true);
            }
        }
    }

    public void startTimerAndFlyMovement() {
        if (this.START_TIMER < 200) {
            ++this.START_TIMER;
        } else if (this.START_TIMER == 200) {
            if (this.getDeltaMovement().y < this.getMaxRocketSpeed() - (double)0.1f) {
                this.addDeltaMovement(new Vec3(0.0, (double)0.1f, 0.0));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().x, this.getMaxRocketSpeed(), this.getDeltaMovement().z);
            }
        }
    }

    private void destroyRocket(boolean explode) {
        if (!this.level().isClientSide) {
            if (explode) {
                this.level().explode((Entity)this, this.getX(), this.getBoundingBox().maxY, this.getZ(), 10.0f, true, Level.ExplosionInteraction.TNT);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void rocketExplosion() {
        if (this.START_TIMER == 200 && this.getDeltaMovement().y < -0.07) {
            this.destroyRocket(true);
        }
    }

    public Player getFirstPlayerPassenger() {
        if (!this.getPassengers().isEmpty()) {
            for (int i = 0; i < this.getPassengers().size(); ++i) {
                Object e = this.getPassengers().get(i);
                if (!(e instanceof Player)) continue;
                Player player = (Player)e;
                return player;
            }
        }
        return null;
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getItems().size(); ++i) {
            Level level;
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || !((level = this.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnAtLocation(serverLevel, itemstack);
        }
    }

    public ItemStack getRocketItem() {
        ItemStack rocket = new ItemStack((ItemLike)ItemsRegistry.ROCKET.get(), 1);
        rocket.set((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get(), (Object)this.rocketComponent);
        return rocket;
    }

    protected void doPlayerRide(Entity player) {
        if (!this.level().isClientSide) {
            Vec3 entityPos = player.getPosition(0.0f);
            player.setPosRaw(entityPos.x, entityPos.y + 40.0, entityPos.z);
            player.startRiding((Entity)this, true);
        }
    }

    private void checkContainer() {
        VehicleUpgrade upgrade;
        VehicleUpgrade vehicleUpgrade;
        VehicleUpgradeItem item;
        if (this.level().isClientSide) {
            return;
        }
        Item item2 = this.getInventory().getItem(2).getItem();
        if (item2 instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)item2;
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof MotorUpgrade) {
                upgrade = (MotorUpgrade)vehicleUpgrade;
                this.MOTOR_UPGRADE = upgrade;
            }
        } else if (this.getInventory().getItem(2).isEmpty()) {
            this.MOTOR_UPGRADE = MotorUpgrade.getBasic();
        }
        upgrade = this.getInventory().getItem(3).getItem();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof TankUpgrade) {
                upgrade = (TankUpgrade)vehicleUpgrade;
                this.TANK_UPGRADE = upgrade;
            }
        } else if (this.getInventory().getItem(3).isEmpty()) {
            this.TANK_UPGRADE = TankUpgrade.getBasic();
        }
        upgrade = this.getInventory().getItem(4).getItem();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof SkinUpgrade) {
                upgrade = (SkinUpgrade)vehicleUpgrade;
                this.SKIN_UPGRADE = upgrade;
                this.setSkinData();
            }
        } else if (this.getInventory().getItem(4).isEmpty()) {
            this.SKIN_UPGRADE = SkinUpgrade.getBasic();
            this.setSkinData();
        }
        upgrade = this.getInventory().getItem(5).getItem();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof ModelUpgrade) {
                upgrade = (ModelUpgrade)vehicleUpgrade;
                if (this.MODEL_UPGRADE.getModel() != ((ModelUpgrade)upgrade).getModel()) {
                    this.MODEL_UPGRADE = upgrade;
                    this.setModelData();
                    this.needsModelChange = true;
                    this.changeRocketModel();
                }
            }
        } else if (this.getInventory().getItem(5).isEmpty()) {
            this.MODEL_UPGRADE = ModelUpgrade.getBasic();
            this.setModelData();
            if (this.needsModelChange) {
                this.needsModelChange = false;
                this.changeRocketModel();
            }
        }
        this.tryFillUpRocket(this.getInventory().getItem(0).getItem());
    }

    public boolean tryFillUpRocket(Item item) {
        if (this.level().isClientSide) {
            return false;
        }
        if (this.FUEL >= this.TANK_UPGRADE.getTankCapacity() || item == null) {
            return false;
        }
        FuelType.Type itemType = FuelType.Type.getTypeBasedOnItem(item);
        if (itemType == null) {
            return false;
        }
        FuelType.Type motorType = this.MOTOR_UPGRADE.getFuelType();
        if (motorType == itemType.getMotorType()) {
            if (this.FUEL == 0) {
                this.FUEL_TYPE = itemType;
            }
            if (itemType == this.FUEL_TYPE) {
                ItemStack fuelItem;
                this.FUEL += 1000;
                if (this.FUEL > this.TANK_UPGRADE.getTankCapacity()) {
                    this.FUEL = this.TANK_UPGRADE.getTankCapacity();
                }
                if ((fuelItem = this.inventory.removeItem(0, 1)).is((Item)ItemsRegistry.FUEL_BUCKET.get()) || fuelItem.is((Item)ItemsRegistry.HYDROGEN_BUCKET.get())) {
                    this.inventory.setItem(1, new ItemStack((ItemLike)Items.BUCKET, this.inventory.getItem(1).getCount() + 1));
                }
                return true;
            }
        }
        return false;
    }

    private void openPlanetMenu(Player player) {
        if (player == null) {
            return;
        }
        if (!player.stellaris$isPlanetMenuOpen()) {
            player.setNoGravity(true);
            player.getVehicle().setNoGravity(true);
            PlanetUtil.openPlanetSelectionMenu(player, player.isCreative());
            player.stellaris$setPlanetMenuOpen(true, player, true);
        }
    }

    private void openWaitMenu(Player player) {
        if (player == null) {
            return;
        }
        if (!player.stellaris$isPlanetMenuOpen()) {
            player.setNoGravity(true);
            player.getVehicle().setNoGravity(true);
            PlanetUtil.openWaitMenu(player, this.getFirstPlayerPassenger().getDisplayName().getString());
            player.stellaris$setPlanetMenuOpen(true, player, true);
        }
    }

    public void burnEntities() {
        if (this.START_TIMER == 200) {
            AABB aabb = AABB.ofSize((Vec3)new Vec3(this.getX(), this.getY() - 2.0, this.getZ()), (double)2.0, (double)2.0, (double)2.0);
            List entities = this.getCommandSenderWorld().getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity entity : entities) {
                entity.setRemainingFireTicks(40);
            }
        }
    }

    protected void spawnRocketItem() {
        ItemEntity entityToSpawn = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getRocketItem());
        entityToSpawn.setPickUpDelay(10);
        entityToSpawn.getItem().set((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get(), (Object)this.rocketComponent);
        this.level().addFreshEntity((Entity)entityToSpawn);
    }

    public int getTankCapacity() {
        return this.TANK_UPGRADE.getTankCapacity();
    }

    public Container getInventory() {
        return this.inventory;
    }

    public double getMaxRocketSpeed() {
        return this.getGravity() + 0.8;
    }

    public ResourceLocation getFullSkinTexture() {
        String texture = this.getSkinData().getRocketSkinLocation().toString();
        if (this.MODEL_UPGRADE != null) {
            texture = texture.replace("normal", this.getModelData().getModel().toString());
        }
        return ResourceLocation.parse((String)texture);
    }

    public boolean canGoTo(Planet actual, Planet destination) {
        return (float)Mth.abs((int)(actual.distanceFromEarth() - destination.distanceFromEarth())) <= FuelType.getMegametersTraveled(this.FUEL, this.FUEL_TYPE);
    }

    public void syncRocketData(ServerPlayer player) {
        this.rocketComponent = new RocketComponent(this.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(this.MODEL_UPGRADE.getModel().toString()), this.FUEL_TYPE.getSerializedName(), this.FUEL, this.FUEL_TYPE.getFuelTexture(), this.TANK_UPGRADE.getTankCapacity());
        if (!this.level().isClientSide()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncRocketComponentPacket(this.rocketComponent));
        }
    }

    public void changeRocketModel() {
        if (this.lastPlayer != null) {
            this.lastPlayer.closeContainer();
        }
        NonNullList itemStacks = this.inventory.getItems();
        Vec3 pos = this.position();
        EntityType<? extends RocketEntity> newRocketType = this.getEntityType(this.MODEL_UPGRADE);
        RocketEntity newRocketEntity = new RocketEntity(newRocketType, this.level());
        newRocketEntity.setPos(pos);
        newRocketEntity.setYRot(this.getYRot());
        newRocketEntity.setModelData();
        newRocketEntity.setSkinData();
        newRocketEntity.setRocketComponent(this.rocketComponent);
        newRocketEntity.MODEL_UPGRADE = this.MODEL_UPGRADE;
        newRocketEntity.needsModelChange = this.needsModelChange;
        newRocketEntity.setModelData();
        newRocketEntity.setSkinData();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            newRocketEntity.inventory.setItem(i, (ItemStack)itemStacks.get(i));
        }
        List passengers = this.getPassengers();
        this.remove(Entity.RemovalReason.DISCARDED);
        newRocketEntity.level().addFreshEntity((Entity)newRocketEntity);
        for (Entity passenger : passengers) {
            passenger.startRiding((Entity)newRocketEntity);
        }
        newRocketEntity.openCustomInventoryScreen(this.lastPlayer);
    }

    public EntityType<? extends RocketEntity> getEntityType(ModelUpgrade upgrade) {
        return switch (upgrade.getModel()) {
            default -> throw new MatchException(null, null);
            case RocketModel.TINY -> (EntityType)EntityRegistry.TINY_ROCKET.get();
            case RocketModel.SMALL -> (EntityType)EntityRegistry.SMALL_ROCKET.get();
            case RocketModel.NORMAL -> (EntityType)EntityRegistry.NORMAL_ROCKET.get();
            case RocketModel.BIG -> (EntityType)EntityRegistry.BIG_ROCKET.get();
        };
    }

    public RocketComponent getRocketComponent() {
        return this.rocketComponent;
    }

    static {
        DATA_MODEL = SynchedEntityData.defineId(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
        ROCKET_START = SynchedEntityData.defineId(RocketEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }
}

