/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles;

import com.st0x0ef.stellaris.common.data_components.RoverComponent;
import com.st0x0ef.stellaris.common.entities.vehicles.base.AbstractRoverBase;
import com.st0x0ef.stellaris.common.items.VehicleUpgradeItem;
import com.st0x0ef.stellaris.common.menus.RoverMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncRoverComponentPacket;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import com.st0x0ef.stellaris.common.vehicle_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.SpeedUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.TankUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.VehicleUpgrade;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;

public class RoverEntity
extends AbstractRoverBase
implements HasCustomInventoryScreen,
ContainerListener {
    public MotorUpgrade motorUpgrade;
    public TankUpgrade tankUpgrade;
    public SpeedUpgrade speedUpgrade;
    public final SimpleContainer inventory = new SimpleContainer(13);
    public RoverComponent roverComponent;

    public RoverEntity(EntityType type, Level worldIn) {
        super(type, worldIn);
        this.motorUpgrade = MotorUpgrade.getBasic();
        this.tankUpgrade = TankUpgrade.getBasic();
        this.speedUpgrade = SpeedUpgrade.getBasic();
        this.FUEL = 0;
        this.FUEL_TYPE = FuelType.Type.FUEL;
        this.roverComponent = new RoverComponent(this.FUEL_TYPE.getSerializedName(), this.FUEL, this.FUEL_TYPE.getFuelTexture(), this.tankUpgrade.getTankCapacity(), this.speedUpgrade.getSpeedModifier());
    }

    public void setRoverComponent(RoverComponent roverComponent) {
        this.roverComponent = roverComponent;
        this.motorUpgrade = roverComponent.getMotorUpgrade();
        this.tankUpgrade = roverComponent.getTankUpgrade();
        this.speedUpgrade = roverComponent.getSpeedUpgrade();
        this.FUEL = roverComponent.getFuel();
        this.FUEL_TYPE = roverComponent.getFuelType();
    }

    @Override
    public float getMaxSpeed() {
        return 0.8f * this.speedUpgrade.getSpeedModifier();
    }

    @Override
    public float getMaxReverseSpeed() {
        return 0.6f * this.speedUpgrade.getSpeedModifier();
    }

    @Override
    public float getAcceleration() {
        return 1.8f * this.speedUpgrade.getSpeedModifier() * 0.5f / 2.0f;
    }

    @Override
    public float getMaxRotationSpeed() {
        return 6.8f;
    }

    @Override
    public float getMinRotationSpeed() {
        return 4.8f;
    }

    @Override
    public float getRollResistance() {
        return 1.5f;
    }

    @Override
    public float getRotationModifier() {
        return 2.9f;
    }

    @Override
    public float getPitch() {
        return 0.75f;
    }

    @Override
    public double getPlayerYOffset() {
        return 1.0;
    }

    @Override
    public int getPassengerSize() {
        return 2;
    }

    @Override
    public Vector3d[] getPlayerOffsets() {
        return new Vector3d[]{new Vector3d(0.45, 0.5, -0.35), new Vector3d(0.45, 0.5, 0.35)};
    }

    @Override
    public boolean doesEnterThirdPerson() {
        return true;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        super.interact(player, hand);
        InteractionResult.Success result = InteractionResult.SUCCESS;
        if (!this.level().isClientSide) {
            if (player.isCrouching()) {
                if (!this.tryFillUpRover(player.getMainHandItem().getItem())) {
                    this.openCustomInventoryScreen(player);
                } else {
                    player.getItemInHand(hand).grow(-1);
                    player.getInventory().add(new ItemStack((ItemLike)Items.BUCKET));
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.CONSUME;
        }
        return result;
    }

    @Override
    public void tick() {
        super.tick();
        this.checkContainer();
        Player player = this.getDriver();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.syncRocketData(serverPlayer);
        }
    }

    @Override
    protected boolean consumeFuel() {
        if (this.getFuel() <= 0) {
            return false;
        }
        --this.FUEL;
        return this.getFuel() >= 0;
    }

    private void checkContainer() {
        VehicleUpgrade upgrade;
        VehicleUpgrade vehicleUpgrade;
        VehicleUpgradeItem item;
        if (this.level().isClientSide) {
            return;
        }
        Item item2 = this.getInventory().getItem(2).getItem();
        if (item2 instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)item2;
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof MotorUpgrade) {
                this.motorUpgrade = upgrade = (MotorUpgrade)vehicleUpgrade;
            }
        } else if (this.getInventory().getItem(2).isEmpty()) {
            this.motorUpgrade = MotorUpgrade.getBasic();
        }
        upgrade = this.getInventory().getItem(3).getItem();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof SpeedUpgrade) {
                upgrade = (SpeedUpgrade)vehicleUpgrade;
                this.speedUpgrade = upgrade;
            }
        } else if (this.getInventory().getItem(3).isEmpty()) {
            this.speedUpgrade = SpeedUpgrade.getBasic();
        }
        upgrade = this.getInventory().getItem(4).getItem();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof TankUpgrade) {
                upgrade = (TankUpgrade)vehicleUpgrade;
                this.tankUpgrade = upgrade;
            }
        } else if (this.getInventory().getItem(4).isEmpty()) {
            this.tankUpgrade = TankUpgrade.getBasic();
        }
        this.tryFillUpRover(this.getInventory().getItem(0).getItem());
    }

    private SimpleContainer getInventory() {
        return this.inventory;
    }

    public boolean tryFillUpRover(Item item) {
        if (this.level().isClientSide) {
            return false;
        }
        if (this.FUEL >= this.tankUpgrade.getTankCapacity() || item == null) {
            return false;
        }
        FuelType.Type itemType = FuelType.Type.getTypeBasedOnItem(item);
        if (itemType == null) {
            return false;
        }
        FuelType.Type motorType = this.motorUpgrade.getFuelType();
        if (motorType == itemType.getMotorType()) {
            if (this.FUEL == 0) {
                this.FUEL_TYPE = itemType;
            }
            if (itemType == this.FUEL_TYPE) {
                ItemStack fuelItem;
                this.FUEL += 1000;
                if (this.FUEL > this.tankUpgrade.getTankCapacity()) {
                    this.FUEL = this.tankUpgrade.getTankCapacity();
                }
                if ((fuelItem = this.inventory.removeItem(0, 1)).is((Item)ItemsRegistry.FUEL_BUCKET.get()) || fuelItem.is((Item)ItemsRegistry.HYDROGEN_BUCKET.get())) {
                    this.inventory.setItem(1, new ItemStack((ItemLike)Items.BUCKET, this.inventory.getItem(1).getCount() + 1));
                }
                return true;
            }
        }
        return false;
    }

    public void kill(ServerLevel serverLevel) {
        this.dropEquipment();
        this.spawnRoverItem();
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource damageSource, float f) {
        Entity sourceEntity = damageSource.getEntity();
        if (sourceEntity != null && sourceEntity.isCrouching() && !this.isVehicle()) {
            this.dropEquipment();
            this.spawnRoverItem();
            if (!this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    public void syncRocketData(ServerPlayer player) {
        this.roverComponent = new RoverComponent(this.FUEL_TYPE.getSerializedName(), this.FUEL, this.FUEL_TYPE.getFuelTexture(), this.tankUpgrade.getTankCapacity(), this.speedUpgrade.getSpeedModifier());
        if (!this.level().isClientSide()) {
            NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncRoverComponentPacket(this.roverComponent));
        }
    }

    private void spawnRoverItem() {
        ItemEntity entityToSpawn = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getRoverItem());
        entityToSpawn.setPickUpDelay(10);
        entityToSpawn.getItem().set((DataComponentType)DataComponentsRegistry.ROVER_COMPONENT.get(), (Object)this.roverComponent);
        this.level().addFreshEntity((Entity)entityToSpawn);
    }

    private ItemStack getRoverItem() {
        return ((Item)ItemsRegistry.ROVER.get()).getDefaultInstance();
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getItems().size(); ++i) {
            Level level;
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || !((level = this.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnAtLocation(serverLevel, itemstack);
        }
    }

    public void containerChanged(Container container) {
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("InventoryCustom", (Tag)this.inventory.createTag((HolderLookup.Provider)this.registryAccess()));
        compound.putInt("fuel", this.FUEL);
        if (this.FUEL != 0) {
            compound.putString("currentFuelItemType", this.FUEL_TYPE.getSerializedName());
        }
        ListTag listTag = new ListTag();
        for (int i = 1; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemStack = this.inventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)(i - 1));
            listTag.add((Object)itemStack.save((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag));
        }
        compound.put("Items", (Tag)listTag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.getList("InventoryCustom").isPresent()) {
            ListTag inventoryCustom = (ListTag)compound.getList("InventoryCustom").get();
            this.inventory.fromTag(inventoryCustom, (HolderLookup.Provider)this.registryAccess());
        }
        if (compound.getInt("fuel").isPresent()) {
            this.FUEL = (Integer)compound.getInt("fuel").get();
        }
        if (this.FUEL != 0 && compound.getString("currentFuelItemType").isPresent()) {
            this.FUEL_TYPE = FuelType.Type.fromString((String)compound.getString("currentFuelItemType").get());
        }
        if (compound.getList("Items").isPresent()) {
            ListTag listTag = (ListTag)compound.getList("Items").get();
            for (int i = 0; i < listTag.size(); ++i) {
                int j;
                CompoundTag compoundTag;
                if (!listTag.getCompound(i).isPresent() || !(compoundTag = (CompoundTag)listTag.getCompound(i).get()).getByte("Slot").isPresent() || (j = (Byte)compoundTag.getByte("Slot").get() & 0xFF) >= this.inventory.getContainerSize() - 1) continue;
                this.inventory.setItem(j + 1, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag).orElse(ItemStack.EMPTY));
            }
        }
    }

    public void openCustomInventoryScreen(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(FriendlyByteBuf packetByteBuf) {
                    packetByteBuf.writeVarInt(RoverEntity.this.getId());
                }

                public Component getDisplayName() {
                    return Component.literal((String)"Rover");
                }

                public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeInt(RoverEntity.this.FUEL);
                    packetBuffer.writeVarInt(RoverEntity.this.getId());
                    return new RoverMenu(syncId, inv, (Container)RoverEntity.this.inventory, RoverEntity.this.getId());
                }
            });
        }
    }

    public RoverComponent getRoverComponent() {
        return this.roverComponent;
    }
}

