/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;

public class CoffeeItem
extends Item {
    private static final int DRINK_DURATION = 40;

    public CoffeeItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        Player player;
        super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (stack.isEmpty()) {
            return new ItemStack(ItemsRegistry.COFFEE_CUP);
        }
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).hasInfiniteMaterials()) {
            ItemStack itemStack = new ItemStack(ItemsRegistry.COFFEE_CUP);
            if (!player.getInventory().add(itemStack)) {
                player.drop(itemStack, false);
            }
        }
        return stack;
    }

    public int getUseDuration(ItemStack stack) {
        return 40;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return (SoundEvent)SoundEvents.GENERIC_DRINK.value();
    }

    public SoundEvent getEatingSound() {
        return (SoundEvent)SoundEvents.GENERIC_DRINK.value();
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
    }

    public int getDefaultMaxStackSize() {
        return 64;
    }
}

