/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.ItemFluidStorage;
import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public class OxygenTankItem
extends Item
implements FluidProvider.ITEM {
    private final int capacity;

    public OxygenTankItem(Item.Properties properties, int capacity) {
        super(properties.stacksTo(1));
        this.capacity = capacity;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        consumer.accept((Component)Component.translatable((String)"tooltip.item.stellaris.oxygen_tank", (Object[])new Object[]{this.getFluidTank(itemStack).getFluidInTank(0).getAmount(), this.getFluidTank(itemStack).getTankCapacity(0)}).withStyle(ChatFormatting.GRAY));
    }

    public InteractionResult use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            Stellaris.LOG.error("Client : {}", (Object)Objects.requireNonNull((FluidAmountMapDataComponent)player.getItemInHand(usedHand).get((DataComponentType)DataComponentsRegistry.FLUID_LIST.get())).getAmount(0));
        } else {
            Stellaris.LOG.error("Server : {}", (Object)Objects.requireNonNull((FluidAmountMapDataComponent)player.getItemInHand(usedHand).get((DataComponentType)DataComponentsRegistry.FLUID_LIST.get())).getAmount(0));
        }
        if (level.isClientSide) {
            return super.use(level, player, usedHand);
        }
        if (player.isShiftKeyDown()) {
            ItemStack stack = player.getItemBySlot(EquipmentSlot.CHEST);
            ItemFluidStorage storage = this.getFluidTank(stack);
            UniversalFluidItemStorage chestplateStorage = (UniversalFluidItemStorage)Capabilities.Fluid.ITEM.getCapability(stack);
            if (chestplateStorage == null) {
                return super.use(level, player, usedHand);
            }
            if (storage.getFluidInTank(0).isEmpty()) {
                return super.use(level, player, usedHand);
            }
            if (chestplateStorage.getTankCapacity(0) - chestplateStorage.getFluidInTank(0).getAmount() >= storage.getFluidInTank(0).getAmount()) {
                chestplateStorage.fill(storage.getFluidInTank(0).copy(), false);
                storage.drain(storage.getFluidInTank(0).copy(), false);
            } else {
                long amount = chestplateStorage.getTankCapacity(0) - chestplateStorage.getFluidInTank(0).getAmount();
                chestplateStorage.fill(storage.getFluidInTank(0).copyWithAmount(amount), false);
                storage.drain(storage.getFluidInTank(0).copyWithAmount(amount), false);
            }
        }
        return super.use(level, player, usedHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity block = context.getLevel().getBlockEntity(context.getClickedPos());
        if (block instanceof OxygenDistributorBlockEntity) {
            OxygenDistributorBlockEntity entity = (OxygenDistributorBlockEntity)block;
            ItemFluidStorage storage = this.getFluidTank(context.getItemInHand());
            long amount = entity.addOxygen(storage.getFluidInTank(0).getAmount());
            storage.drain(storage.getFluidInTank(0).copyWithAmount(amount), false);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        ItemFluidStorage storage = this.getFluidTank(stack);
        return (int)Mth.clamp((long)((storage.getFluidInTank(0).getAmount() + 1L) * 13L / storage.getTankCapacity(0)), (long)0L, (long)13L);
    }

    public int getBarColor(ItemStack stack) {
        return 11003629;
    }

    @NotNull
    public ItemFluidStorage getFluidTank(@NotNull ItemStack stack) {
        return new ItemFluidStorage(this, (DataComponentType)DataComponentsRegistry.FLUID_LIST.get(), stack, 1, this.capacity){

            public boolean isFluidValid(int tank, FluidStack stack) {
                return stack.getFluid().isSame((Fluid)FluidRegistry.OXYGEN_STILL.get());
            }
        };
    }
}

