/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.armors;

import com.fej1fun.potentials.fluid.ItemFluidStorage;
import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import dev.architectury.fluid.FluidStack;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSpaceArmor
extends Item {
    public AbstractSpaceArmor(Item.Properties properties) {
        super(properties);
    }

    public static class Chestplate
    extends AbstractSpaceChestplate {
        public Chestplate(Item.Properties properties) {
            super(properties);
        }

        @Override
        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
            consumer.accept((Component)Component.translatable((String)"jetsuit.stellaris.fuel", (Object[])new Object[]{this.getFluidTank(itemStack).getFluidInTank(1).getAmount()}));
        }

        @Override
        @NotNull
        public UniversalFluidItemStorage getFluidTank(@NotNull ItemStack stack) {
            return new ItemFluidStorage(this, (DataComponentType)DataComponentsRegistry.FLUID_LIST.get(), stack, 2, 3000L){

                public boolean isFluidValid(int tank, FluidStack stack) {
                    return switch (tank) {
                        case 0 -> stack.getFluid().isSame((Fluid)FluidRegistry.OXYGEN_STILL.get());
                        case 1 -> stack.getFluid().isSame((Fluid)FluidRegistry.FUEL_STILL.get());
                        default -> false;
                    };
                }
            };
        }
    }

    public static class AbstractSpaceChestplate
    extends AbstractSpaceArmor
    implements FluidProvider.ITEM {
        public AbstractSpaceChestplate(Item.Properties properties) {
            super(properties);
        }

        public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
            super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
            consumer.accept((Component)Component.translatable((String)"jetsuit.stellaris.oxygen", (Object[])new Object[]{this.getFluidTank(itemStack).getFluidInTank(0).getAmount()}));
        }

        @NotNull
        public UniversalFluidItemStorage getFluidTank(@NotNull ItemStack stack) {
            return new ItemFluidStorage(this, (DataComponentType)DataComponentsRegistry.FLUID_LIST.get(), stack, 1, 3000L){

                public boolean isFluidValid(int tank, FluidStack stack) {
                    return stack.getFluid().isSame((Fluid)FluidRegistry.OXYGEN_STILL.get());
                }
            };
        }
    }
}

