/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.armors;

import com.st0x0ef.stellaris.common.data_components.SpaceSuitModules;
import com.st0x0ef.stellaris.common.items.armors.AbstractSpaceArmor;
import com.st0x0ef.stellaris.common.items.module.SpaceSuitModule;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.Nullable;

public class SpaceSuit
extends AbstractSpaceArmor.AbstractSpaceChestplate {
    public SpaceSuit(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack itemStack, ServerLevel serverLevel, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        Player player;
        super.inventoryTick(itemStack, serverLevel, entity, equipmentSlot);
        if (entity instanceof Player && (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof SpaceSuit) {
            ItemStack spaceSuitItemStack = player.getItemBySlot(EquipmentSlot.CHEST);
            List<SpaceSuitModule> modules = this.getModules(itemStack);
            if (!modules.isEmpty()) {
                modules.forEach(spaceSuitModule -> spaceSuitModule.tick(spaceSuitItemStack, (Level)serverLevel, player));
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag);
        List<SpaceSuitModule> modules = this.getModules(itemStack);
        if (Platform.getEnv() != Dist.CLIENT) {
            return;
        }
        if (!modules.isEmpty()) {
            modules.forEach(spaceSuitModule -> spaceSuitModule.addToTooltips(itemStack, tooltipContext, tooltipDisplay, consumer, tooltipFlag));
        }
        if (Screen.hasShiftDown()) {
            if (!modules.isEmpty()) {
                consumer.accept((Component)Component.translatable((String)"spacesuit.stellaris.modules"));
                modules.forEach(spaceSuitModule -> consumer.accept((Component)spaceSuitModule.displayName().withStyle(ChatFormatting.GRAY)));
            }
        } else {
            consumer.accept((Component)Component.translatable((String)"spacesuit.stellaris.shift_for_modules"));
        }
    }

    public NonNullList<ItemStack> scrapArmorModules(ItemStack stack) {
        Iterable<ItemStack> items = ((SpaceSuitModules)stack.getOrDefault((DataComponentType)DataComponentsRegistry.SPACE_SUIT_MODULES.get(), (Object)new SpaceSuitModules(List.of()))).itemsCopy();
        NonNullList itemsToReturn = NonNullList.create();
        items.forEach(arg_0 -> itemsToReturn.add(arg_0));
        stack.set((DataComponentType)DataComponentsRegistry.SPACE_SUIT_MODULES.get(), (Object)SpaceSuitModules.empty());
        return itemsToReturn;
    }

    public List<SpaceSuitModule> getModules(ItemStack stack) {
        return ((SpaceSuitModules)stack.getOrDefault((DataComponentType)DataComponentsRegistry.SPACE_SUIT_MODULES.get(), (Object)SpaceSuitModules.empty())).getModules();
    }
}

