/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.module;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.common.items.module.SpaceSuitModule;
import java.util.function.Consumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;

public class FuelModule
extends Item
implements SpaceSuitModule {
    public FuelModule(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public MutableComponent displayName() {
        return Component.translatable((String)"spacesuit.stellaris.fuel_module");
    }

    @Override
    public void renderToGui(GuiGraphics graphics, DeltaTracker deltaTracker, Player player, ItemStack stack) {
        UniversalFluidStorage storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(stack);
        if (storage == null) {
            return;
        }
        graphics.blit(RenderType::guiTextured, GUISprites.SPACESUIT_FUEL_BAR, 5, 16, 0.0f, 0.0f, 37, 10, 37, 10);
        int i = Mth.ceil((float)(Mth.clamp((float)((float)storage.getFluidInTank(1).getAmount() / (float)storage.getTankCapacity(1)), (float)0.0f, (float)1.0f) * 23.0f));
        graphics.blitSprite(RenderType::guiTextured, GUISprites.SPACESUIT_FULL_BAR_SPRITE, 24, 4, 0, 0, 15, 19, i, 4);
    }

    @Override
    public void addToTooltips(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        UniversalFluidStorage storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(itemStack);
        if (storage == null) {
            return;
        }
        consumer.accept((Component)Component.translatable((String)"jetsuit.stellaris.fuel", (Object[])new Object[]{storage.getFluidInTank(1).getAmount()}).append(" \u00a7r/\u00a78 " + storage.getTankCapacity(1)));
    }
}

