/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items.module;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.st0x0ef.stellaris.common.data_components.JetSuitComponent;
import com.st0x0ef.stellaris.common.items.armors.JetSuit;
import com.st0x0ef.stellaris.common.items.module.SpaceSuitModule;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.fluid.FluidStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;

public class JetModule
extends Item
implements SpaceSuitModule {
    public float spacePressTime;

    public JetModule(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    @Override
    public MutableComponent displayName() {
        return Component.translatable((String)"spacesuit.stellaris.jet_module");
    }

    @Override
    public List<Item> requires() {
        return List.of((Item)ItemsRegistry.MODULE_FUEL.get());
    }

    @Override
    public int renderStackedGui(GuiGraphics graphics, DeltaTracker deltaTracker, Player player, ItemStack stack, int y) {
        Component modeText = this.getModeType(stack).getComponent();
        ChatFormatting chatFormatting = this.getModeType(stack).getChatFormatting();
        Font font = Minecraft.getInstance().font;
        MutableComponent text = Component.translatable((String)"general.stellaris.jet_suit_mode").append(": ").withStyle(chatFormatting).append((Component)modeText.copy().withStyle(ChatFormatting.GRAY));
        graphics.drawString(font, (Component)text, 5, y, 0xFFFFFF);
        Objects.requireNonNull(Minecraft.getInstance().font);
        return y += 9;
    }

    public int getMode(ItemStack itemStack) {
        return ((JetSuitComponent)itemStack.getOrDefault((DataComponentType)DataComponentsRegistry.JET_SUIT_COMPONENT.get(), (Object)new JetSuitComponent(JetSuit.ModeType.DISABLED))).type().getMode();
    }

    public JetSuit.ModeType getModeType(ItemStack itemStack) {
        return switch (this.getMode(itemStack)) {
            case 1 -> JetSuit.ModeType.NORMAL;
            case 2 -> JetSuit.ModeType.HOVER;
            case 3 -> JetSuit.ModeType.ELYTRA;
            default -> JetSuit.ModeType.DISABLED;
        };
    }

    @Override
    public void tick(ItemStack stack, Level level, Player player) {
        UniversalFluidStorage storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(stack);
        if (storage == null || storage.getFluidInTank(1).isEmpty()) {
            return;
        }
        if (player.isSprinting()) {
            this.boost(player, 1.3, true);
        }
        if (player.zza > 0.0f && !player.isSprinting()) {
            this.boost(player, 0.9, false);
        }
        switch (this.getMode(stack)) {
            case 1: {
                this.normalFlyModeMovement(player, stack);
                break;
            }
            case 2: {
                this.hoverModeMovement(player, stack);
                break;
            }
            case 3: {
                this.elytraModeMovement(player, stack);
            }
        }
        this.calculateSpacePressTime(player, stack);
    }

    private void normalFlyModeMovement(Player player, ItemStack stack) {
        if (KeyVariables.isHoldingJump(player)) {
            player.moveRelative(1.2f, new Vec3(0.0, 0.1, 0.0));
            player.resetFallDistance();
            Utils.disableFlyAntiCheat(player, true);
        }
        if (!player.onGround()) {
            if (KeyVariables.isHoldingUp(player)) {
                player.moveRelative(1.0f, new Vec3(0.0, 0.0, 0.03));
            } else if (KeyVariables.isHoldingDown(player)) {
                player.moveRelative(1.0f, new Vec3(0.0, 0.0, -0.03));
            }
        }
        if (!player.onGround()) {
            if (KeyVariables.isHoldingRight(player)) {
                player.moveRelative(1.0f, new Vec3(-0.03, 0.0, 0.0));
            } else if (KeyVariables.isHoldingLeft(player)) {
                player.moveRelative(1.0f, new Vec3(0.03, 0.0, 0.0));
            }
        }
    }

    private void hoverModeMovement(Player player, ItemStack stack) {
        Vec3 vec3 = player.getDeltaMovement();
        if (!player.onGround() && !player.isInWater()) {
            player.setDeltaMovement(vec3.x, vec3.y + 0.04, vec3.z);
            player.resetFallDistance();
            Utils.disableFlyAntiCheat(player, true);
            UniversalFluidStorage storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(stack);
            if (storage == null) {
                return;
            }
            storage.drain(FluidStack.create((Fluid)((Fluid)FluidRegistry.FUEL_STILL.get()), (long)2L), false);
        }
        if (KeyVariables.isHoldingJump(player)) {
            Utils.disableFlyAntiCheat(player, true);
        }
        if (player.isCrouching()) {
            player.moveRelative(0.05f, new Vec3(0.0, -0.08, 0.0));
        }
        if (!player.onGround()) {
            if (KeyVariables.isHoldingUp(player)) {
                player.moveRelative(0.1f, new Vec3(0.0, 0.0, 0.1));
            } else if (KeyVariables.isHoldingDown(player)) {
                player.moveRelative(0.1f, new Vec3(0.0, 0.0, -0.1));
            }
        }
        if (!player.onGround()) {
            if (KeyVariables.isHoldingRight(player)) {
                player.moveRelative(0.1f, new Vec3(-0.1, 0.0, 0.0));
            } else if (KeyVariables.isHoldingLeft(player)) {
                player.moveRelative(0.1f, new Vec3(0.1, 0.0, 0.0));
            }
        }
    }

    private void elytraModeMovement(Player player, ItemStack stack) {
        if (player.isSprinting() && !player.onGround()) {
            player.startFallFlying();
            Utils.disableFlyAntiCheat(player, true);
            UniversalFluidStorage storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(stack);
            if (storage == null) {
                return;
            }
            storage.drain(FluidStack.create((Fluid)((Fluid)FluidRegistry.FUEL_STILL.get()), (long)2L), false);
        } else if (player.isSprinting() && player.onGround() && KeyVariables.isHoldingJump(player)) {
            player.move(MoverType.PLAYER, new Vec3(player.getX(), player.getY() + 2.0, player.getZ()));
        }
    }

    public void switchJetSuitMode(ItemStack itemStack) {
        JetSuitComponent jetSuitComponent = this.getMode(itemStack) < 3 ? new JetSuitComponent(JetSuit.ModeType.fromInt(this.getMode(itemStack) + 1)) : new JetSuitComponent(JetSuit.ModeType.fromInt(0));
        itemStack.set((DataComponentType)DataComponentsRegistry.JET_SUIT_COMPONENT.get(), (Object)jetSuitComponent);
    }

    public void calculateSpacePressTime(Player player, ItemStack itemStack) {
        if (Utils.isLivingInJetSuit((LivingEntity)player)) {
            int mode = this.getMode(itemStack);
            if (mode == JetSuit.ModeType.NORMAL.getMode()) {
                if (KeyVariables.isHoldingJump(player)) {
                    if (this.spacePressTime < 2.2f) {
                        this.spacePressTime += 0.2f;
                    }
                } else if (this.spacePressTime > 0.0f) {
                    this.spacePressTime -= 0.2f;
                }
            } else if (mode == JetSuit.ModeType.HOVER.getMode()) {
                if (!player.onGround() && this.spacePressTime < 0.6f) {
                    this.spacePressTime += 0.2f;
                } else if (KeyVariables.isHoldingJump(player)) {
                    if (this.spacePressTime < 1.4f) {
                        this.spacePressTime += 0.2f;
                        this.hoverModeMovement(player, itemStack);
                    }
                } else if (this.spacePressTime >= 0.6f) {
                    this.spacePressTime -= 0.2f;
                }
            } else if (mode == JetSuit.ModeType.ELYTRA.getMode()) {
                if (KeyVariables.isHoldingUp(player) && player.isFallFlying()) {
                    if (player.isSprinting()) {
                        if (this.spacePressTime < 2.8f) {
                            this.spacePressTime += 0.2f;
                        }
                    } else if (this.spacePressTime < 2.2f) {
                        this.spacePressTime += 0.2f;
                    }
                } else if (this.spacePressTime > 0.0f) {
                    this.spacePressTime -= 0.2f;
                }
            }
        }
    }

    public void boost(Player player, double boost, boolean sonicBoom) {
        Vec3 vec31 = player.getLookAngle();
        if (Utils.isLivingInJetSuit((LivingEntity)player) && player.isFallFlying()) {
            Vec3 vec32 = player.getDeltaMovement();
            player.setDeltaMovement(vec32.add(vec31.x * 0.1 + (vec31.x * boost - vec32.x) * 0.5, vec31.y * 0.1 + (vec31.y * boost - vec32.y) * 0.5, vec31.z * 0.1 + (vec31.z * boost - vec32.z) * 0.5));
            if (sonicBoom) {
                Vec3 vec33 = player.getLookAngle().scale(6.5);
                if (player.level() instanceof ServerLevel) {
                    for (ServerPlayer p : ((ServerLevel)player.level()).getServer().getPlayerList().getPlayers()) {
                        ((ServerLevel)player.level()).sendParticles(p, (ParticleOptions)ParticleTypes.FLASH, true, true, player.getX() - vec33.x, player.getY() - vec33.y, player.getZ() - vec33.z, 1, 0.0, 0.0, 0.0, 0.001);
                    }
                }
            }
        }
    }
}

