/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseContainer
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 35;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 35;
    private final int TE_INVENTORY_SLOT_COUNT;

    protected BaseContainer(@Nullable MenuType<?> menuType, int containerId, int size, Inventory inventory, int inventoryXOffset, int inventoryYOffset) {
        super(menuType, containerId);
        this.TE_INVENTORY_SLOT_COUNT = size;
        this.addPlayerHotbar(inventory, inventoryXOffset, inventoryYOffset + 58);
        this.addPlayerInventory(inventory, inventoryXOffset, inventoryYOffset);
    }

    @NotNull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 35) {
            if (!this.moveItemStackTo(sourceStack, 35, 35 + this.TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 35 + this.TE_INVENTORY_SLOT_COUNT) {
            if (!this.moveItemStackTo(sourceStack, 0, 35, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void addPlayerHotbar(Inventory playerInventory, int xOffset, int yOffset) {
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, xOffset + j * 18, yOffset));
        }
    }

    public void addPlayerInventory(Inventory playerInventory, int xOffset, int yOffset) {
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, xOffset + k * 18, yOffset + j * 18));
            }
        }
    }
}

