/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.CoalGeneratorEntity;
import com.st0x0ef.stellaris.common.menus.slot.CoalGeneratorSlot;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CoalGeneratorMenu
extends AbstractContainerMenu {
    private final Container inventory;
    private final CoalGeneratorEntity entity;
    private final ContainerData data;

    public static CoalGeneratorMenu create(int syncId, Inventory inventory, FriendlyByteBuf data) {
        CoalGeneratorEntity entity = (CoalGeneratorEntity)inventory.player.level().getBlockEntity(data.readBlockPos());
        return new CoalGeneratorMenu(syncId, inventory, (Container)new SimpleContainer(1), entity, (ContainerData)new SimpleContainerData(2));
    }

    public CoalGeneratorMenu(int syncId, Inventory playerInventory, Container container, CoalGeneratorEntity entity, ContainerData containerData) {
        super((MenuType)MenuTypesRegistry.COAL_GENERATOR_MENU.get(), syncId);
        CoalGeneratorMenu.checkContainerSize((Container)container, (int)1);
        this.inventory = container;
        this.entity = entity;
        this.data = containerData;
        this.addSlot(new CoalGeneratorSlot(this.inventory, 0, 66, 54));
        this.addPlayerHotbar(playerInventory);
        this.addPlayerInventory(playerInventory);
        this.addDataSlots(containerData);
    }

    public CoalGeneratorEntity getBlockEntity() {
        return this.entity;
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 10 + l * 18, 48 + i * 18 + 58));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 10 + i * 18, 164));
        }
    }

    public float getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }
}

