/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.RadioactiveGeneratorEntity;
import com.st0x0ef.stellaris.common.menus.slot.RadioactiveGeneratorSlot;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class RadioactiveGeneratorMenu
extends AbstractContainerMenu {
    private final Container inventory;
    private final RadioactiveGeneratorEntity entity;
    private final ContainerData data;

    public static RadioactiveGeneratorMenu create(int syncId, Inventory inventory, FriendlyByteBuf data) {
        RadioactiveGeneratorEntity entity = (RadioactiveGeneratorEntity)inventory.player.level().getBlockEntity(data.readBlockPos());
        return new RadioactiveGeneratorMenu(syncId, inventory, (Container)new SimpleContainer(1), entity, (ContainerData)new SimpleContainerData(2));
    }

    public RadioactiveGeneratorMenu(int syncId, Inventory playerInventory, Container container, RadioactiveGeneratorEntity entity, ContainerData data) {
        super((MenuType)MenuTypesRegistry.RADIOACTIVE_GENERATOR_MENU.get(), syncId);
        RadioactiveGeneratorMenu.checkContainerSize((Container)container, (int)1);
        this.inventory = container;
        this.entity = entity;
        this.data = data;
        this.addSlot(new RadioactiveGeneratorSlot(this.inventory, 0, 66, 54));
        this.addPlayerHotbar(playerInventory);
        this.addPlayerInventory(playerInventory);
        this.addDataSlots(data);
    }

    public RadioactiveGeneratorEntity getBlockEntity() {
        return this.entity;
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 10 + l * 18, 48 + i * 18 + 58));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 10 + i * 18, 164));
        }
    }

    public float getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return Mth.clamp((float)((float)this.data.get(0) / (float)i), (float)0.0f, (float)1.0f);
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }
}

