/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oil;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.oil.OilUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public final class OilSavedData
extends SavedData {
    private final List<ChunkPos> chunkPos = new ArrayList<ChunkPos>();
    private final List<Integer> amounts = new ArrayList<Integer>();
    public static final SavedDataType<OilSavedData> TYPE = new SavedDataType("stellaris-oil", OilSavedData::new, ctx -> RecordCodecBuilder.create(instance -> instance.group((App)ChunkPos.CODEC.listOf().fieldOf("chunkPos").forGetter(OilSavedData::getChunkPos), (App)Codec.INT.listOf().fieldOf("amount").forGetter(OilSavedData::getAmounts)).apply((Applicative)instance, OilSavedData::new)), DataFixTypes.LEVEL);

    public OilSavedData(List<ChunkPos> chunkPos, List<Integer> amounts) {
        this.chunkPos.clear();
        this.amounts.clear();
        this.chunkPos.addAll(chunkPos);
        this.amounts.addAll(amounts);
        this.setDirty();
    }

    public static OilSavedData getData(ServerLevel level) {
        return (OilSavedData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    private OilSavedData(SavedData.Context ctx) {
    }

    public List<Integer> getAmounts() {
        return this.amounts;
    }

    public List<ChunkPos> getChunkPos() {
        return this.chunkPos;
    }

    public Integer getAmount(ChunkPos pos) {
        for (int i = 0; i < this.chunkPos.size(); ++i) {
            if (!this.chunkPos.get(i).equals((Object)pos)) continue;
            return this.amounts.get(i);
        }
        int oil = OilUtils.getRandomOilLevel();
        this.chunkPos.add(pos);
        this.amounts.add(oil);
        this.setDirty();
        return oil;
    }

    public void setAmount(ChunkPos pos, int amount) {
        for (int i = 0; i < this.chunkPos.size(); ++i) {
            if (!this.chunkPos.get(i).equals((Object)pos)) continue;
            this.amounts.set(i, amount);
            this.setDirty();
            return;
        }
        this.chunkPos.add(pos);
        this.amounts.add(amount);
        this.setDirty();
    }
}

