/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.st0x0ef.stellaris.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OxygenRoom {
    private final BlockPos distributorPos;
    public final Set<BlockPos> oxygenatedPositions;
    private final ServerLevel level;
    private boolean isClosed;
    private static final int HALF_ROOM_SIZE = 16;

    public OxygenRoom(ServerLevel level, BlockPos distributorPos) {
        this.distributorPos = distributorPos;
        this.oxygenatedPositions = new HashSet<BlockPos>();
        this.level = level;
        this.isClosed = false;
    }

    public OxygenRoom(ServerLevel level, BlockPos distributorPos, Set<BlockPos> oxygenatedPositions) {
        this.distributorPos = distributorPos;
        this.oxygenatedPositions = oxygenatedPositions;
        this.level = level;
        this.isClosed = false;
    }

    public BlockPos getDistributorPosition() {
        return this.distributorPos;
    }

    public OxygenDistributorBlockEntity getDistributorBlockEntity() {
        OxygenDistributorBlockEntity distributor;
        BlockEntity blockEntity = this.level.getBlockEntity(this.distributorPos);
        return blockEntity instanceof OxygenDistributorBlockEntity ? (distributor = (OxygenDistributorBlockEntity)blockEntity) : null;
    }

    public void tick() {
        OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
        if (distributor == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos rel = this.distributorPos.relative(direction);
            if (this.oxygenatedPositions.contains(rel) || !this.level.getBlockState(rel).isAir() || !distributor.useOxygenAndEnergy()) continue;
            this.oxygenatedPositions.add(rel);
            GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).removeRoomToCheckIfOpen(rel);
        }
        ArrayList<BlockPos> oxygenatedPositionsCopy = new ArrayList<BlockPos>(this.oxygenatedPositions);
        for (BlockPos pos : oxygenatedPositionsCopy) {
            for (Direction direction : Direction.values()) {
                BlockPos rel = pos.relative(direction);
                if (Math.abs(rel.getX() - this.distributorPos.getX()) > 16 || Math.abs(rel.getY() - this.distributorPos.getY()) > 16 || Math.abs(rel.getZ() - this.distributorPos.getZ()) > 16) {
                    GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).addRoomToCheckIfOpen(rel, this);
                    continue;
                }
                if (this.oxygenatedPositions.contains(rel) || !this.level.getBlockState(rel).isAir() || !distributor.useOxygenAndEnergy()) continue;
                this.oxygenatedPositions.add(rel);
                GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).removeRoomToCheckIfOpen(rel);
            }
        }
        this.isClosed = this.oxygenatedPositions.size() == oxygenatedPositionsCopy.size();
    }

    public void removeOxygenInRoom() {
        if (!this.isClosed) {
            this.oxygenatedPositions.clear();
        }
    }

    public boolean hasOxygenAt(BlockPos pos) {
        return this.oxygenatedPositions.contains(pos);
    }

    public boolean breathOxygenAt(BlockPos pos) {
        if (this.hasOxygenAt(pos) && this.isClosed) {
            OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
            if (this.getDistributorBlockEntity() == null || !distributor.useOxygenAndEnergy()) {
                this.oxygenatedPositions.remove(pos);
            }
            return true;
        }
        return false;
    }
}

