/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.oxygen.OxygenRoom;
import com.st0x0ef.stellaris.common.oxygen.OxygenRoomRecord;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public final class OxygenSavedData
extends SavedData {
    private final Set<OxygenRoom> rooms;
    public static final SavedDataType<OxygenSavedData> TYPE = new SavedDataType("stellaris-oxygen", OxygenSavedData::new, ctx -> RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)ctx.levelOrThrow()), (App)OxygenRoomRecord.CODEC.listOf().fieldOf("rooms").forGetter(OxygenSavedData::getRooms)).apply((Applicative)instance, OxygenSavedData::new)), DataFixTypes.LEVEL);

    public OxygenSavedData(ServerLevel level, List<OxygenRoomRecord> oxygenRoomRecords) {
        ArrayList rooms = new ArrayList();
        oxygenRoomRecords.forEach(room -> rooms.add(new OxygenRoom(level, room.distributorPos(), new HashSet<BlockPos>(room.oxygenatedPos()))));
        this.rooms = new HashSet<OxygenRoom>(rooms);
        this.setDirty();
    }

    public static OxygenSavedData getData(ServerLevel level) {
        return (OxygenSavedData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    private OxygenSavedData(SavedData.Context ctx) {
        this(ctx.levelOrThrow(), new ArrayList<OxygenRoomRecord>());
    }

    public List<OxygenRoomRecord> getRooms() {
        ArrayList<OxygenRoomRecord> list = new ArrayList<OxygenRoomRecord>();
        this.rooms.forEach(room -> list.add(new OxygenRoomRecord(room.getDistributorPosition(), new ArrayList<BlockPos>(room.oxygenatedPositions))));
        return list;
    }
}

