/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.registry;

import com.st0x0ef.stellaris.common.registry.TagRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public record ToolsRegister(TagKey<Block> incorrectBlocksForDrops, int durability, float speed, float attackDamageBonus, int enchantmentValue, TagKey<Item> repairItems) {
    public static final ToolMaterial TITANIUM = new ToolMaterial(TagRegistry.INCORRECT_FOR_TITANIUM_TOOL, 589, 7.0f, 2.6f, 20, ItemTags.IRON_TOOL_MATERIALS);

    private Item.Properties applyCommonProperties(Item.Properties properties) {
        return properties.durability(this.durability).repairable(this.repairItems).enchantable(this.enchantmentValue);
    }

    public Item.Properties applyToolProperties(Item.Properties properties, TagKey<Block> tagKey, float f, float g) {
        HolderGetter holderGetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(properties).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.deniesDrops((HolderSet)holderGetter.getOrThrow(this.incorrectBlocksForDrops)), Tool.Rule.minesAndDrops((HolderSet)holderGetter.getOrThrow(tagKey), (float)this.speed)), 1.0f, 1, true)).attributes(this.createToolAttributes(f, g));
    }

    private ItemAttributeModifiers createToolAttributes(float f, float g) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(f + this.attackDamageBonus), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)g, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public Item.Properties applySwordProperties(Item.Properties properties, float f, float g) {
        HolderGetter holderGetter = BuiltInRegistries.acquireBootstrapRegistrationLookup((Registry)BuiltInRegistries.BLOCK);
        return this.applyCommonProperties(properties).component(DataComponents.TOOL, (Object)new Tool(List.of(Tool.Rule.minesAndDrops((HolderSet)HolderSet.direct((Holder[])new Holder[]{Blocks.COBWEB.builtInRegistryHolder()}), (float)15.0f), Tool.Rule.overrideSpeed((HolderSet)holderGetter.getOrThrow(BlockTags.SWORD_EFFICIENT), (float)1.5f)), 1.0f, 2, true)).attributes(this.createSwordAttributes(f, g));
    }

    @NotNull
    private ItemAttributeModifiers createSwordAttributes(float f, float g) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(f + this.attackDamageBonus), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)g, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }
}

