/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.menus.MilkyWayMenu;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.menus.TabletMenu;
import com.st0x0ef.stellaris.common.menus.WaitMenu;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PlanetUtil {
    public static final ResourceLocation TEXTURE = Stellaris.texture("planet_bar/earth_planet_bar");

    public static Planet getPlanet(ResourceLocation level) {
        Planet[] result = new Planet[]{null};
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.dimension().equals((Object)level)) {
                result[0] = planet;
            }
        });
        return result[0];
    }

    public static boolean isPlanet(ResourceLocation level) {
        boolean[] isPlanet = new boolean[]{false};
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.dimension().equals((Object)level)) {
                isPlanet[0] = true;
            }
        });
        return isPlanet[0];
    }

    public static void ifPlanet(ResourceLocation level, Consumer<Planet> planetRunnable) {
        if (PlanetUtil.isPlanet(level)) {
            planetRunnable.accept(PlanetUtil.getPlanet(level));
        }
    }

    public static boolean hasOxygen(Level level) {
        return !PlanetUtil.isPlanet(level.dimension().location()) || PlanetUtil.getPlanet(level.dimension().location()).oxygen();
    }

    public static boolean hasOxygenAt(ServerLevel level, @NotNull BlockPos pos) {
        if (!PlanetUtil.hasOxygen((Level)level)) {
            return GlobalOxygenManager.getInstance().getOrCreateDimensionManager(level).hasOxygenAt(pos);
        }
        return true;
    }

    public static ResourceLocation getPlanetBar(ResourceLocation level) {
        if (PlanetUtil.isPlanet(level)) {
            return PlanetUtil.getPlanet(level).textures().planet_bar();
        }
        return TEXTURE;
    }

    public static int openPlanetSelectionMenu(Player player, final boolean forceCanGoTo) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buffer) {
                buffer.writeBoolean(forceCanGoTo);
            }

            public Component getDisplayName() {
                return Component.literal((String)"Planets");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                return PlanetSelectionMenu.create(syncId, inv, buffer.writeBoolean(forceCanGoTo));
            }
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openWaitMenu(Player player, final String playerChoosing) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buffer) {
                buffer.writeUtf(playerChoosing);
            }

            public Component getDisplayName() {
                return Component.literal((String)"Waiting");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                return WaitMenu.create(syncId, inv, buffer.writeUtf(playerChoosing));
            }
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openTabletMenu(Player player, final ResourceLocation entry) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buffer) {
                buffer.writeResourceLocation(entry);
            }

            public Component getDisplayName() {
                return Component.literal((String)"Tablet");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                buffer.writeResourceLocation(entry);
                return TabletMenu.create(syncId, inv, buffer);
            }
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openMilkyWayMenu(Player player) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buf) {
            }

            public Component getDisplayName() {
                return Component.literal((String)"MilkyWay");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                return MilkyWayMenu.create(syncId, inv, buffer);
            }
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }
}

