/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils.capabilities.energy;

import com.fej1fun.potentials.energy.BaseEnergyStorage;
import net.minecraft.nbt.CompoundTag;

public abstract class EnergyStorage
extends BaseEnergyStorage {
    public EnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    public EnergyStorage(int capacity) {
        super(capacity);
    }

    public int insert(int amount, boolean simulate) {
        int inserted = super.insert(amount, simulate);
        if (!simulate) {
            this.onChange();
        }
        return inserted;
    }

    public int extract(int amount, boolean simulate) {
        int extracted = super.extract(amount, simulate);
        if (!simulate) {
            this.onChange();
        }
        return extracted;
    }

    public void save(CompoundTag tag, String name) {
        tag.putInt("energy-" + name, this.energy);
    }

    public void load(CompoundTag tag, String name) {
        if (tag.getInt("energy-" + name).isPresent()) {
            this.energy = (Integer)tag.getInt("energy-" + name).get();
        }
    }

    protected abstract void onChange();
}

