/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin;

import com.st0x0ef.stellaris.common.oxygen.DimensionOxygenManager;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.registry.DamageSourceRegistry;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    LivingEntity stellaris$livingEntity = (LivingEntity)this;
    @Unique
    private long stellaris$tickSinceLastOxygenCheck;
    @Unique
    private DimensionOxygenManager stellaris$oxygenManager;

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void tick(CallbackInfo ci) {
        Utils.handleGravityChange(this.stellaris$livingEntity);
        if (!this.stellaris$livingEntity.level().isClientSide()) {
            if (this.stellaris$tickSinceLastOxygenCheck > 20L) {
                if (this.stellaris$oxygenManager == null) {
                    this.stellaris$oxygenManager = GlobalOxygenManager.getInstance().getOrCreateDimensionManager((ServerLevel)this.stellaris$livingEntity.level());
                }
                if (!this.stellaris$oxygenManager.getLevel().dimension().equals(this.stellaris$livingEntity.level().dimension())) {
                    this.stellaris$oxygenManager = GlobalOxygenManager.getInstance().getOrCreateDimensionManager((ServerLevel)this.stellaris$livingEntity.level());
                }
                if (!this.stellaris$oxygenManager.breath(this.stellaris$livingEntity)) {
                    this.stellaris$livingEntity.hurt(DamageSourceRegistry.of(this.stellaris$livingEntity.level(), DamageSourceRegistry.OXYGEN), 2.0f);
                }
                this.stellaris$tickSinceLastOxygenCheck = 0L;
            }
            ++this.stellaris$tickSinceLastOxygenCheck;
        }
    }
}

