/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.st0x0ef.stellaris.client.renderers.armors.JetSuitModel;
import com.st0x0ef.stellaris.client.renderers.armors.SpaceSuitModel;
import com.st0x0ef.stellaris.common.items.armors.SpaceSuit;
import com.st0x0ef.stellaris.common.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class ArmorRendererMixin {
    @Shadow
    @Final
    private EquipmentLayerRenderer equipmentRenderer;

    @Shadow
    protected abstract void renderArmorPiece(PoseStack var1, MultiBufferSource var2, ItemStack var3, EquipmentSlot var4, int var5, HumanoidModel<?> var6);

    @Inject(method={"render*"}, at={@At(value="HEAD")})
    private void renderArmor(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, HumanoidRenderState humanoidRenderState, float f, float g, CallbackInfo ci) {
        Item item;
        ModelPart jetSuitRootPart = Minecraft.getInstance().getEntityModels().bakeLayer(JetSuitModel.LAYER_LOCATION);
        if (Utils.isJetSuitPart(humanoidRenderState.feetEquipment)) {
            this.renderArmorPiece(poseStack, bufferSource, humanoidRenderState.feetEquipment, EquipmentSlot.FEET, packedLight, new JetSuitModel(jetSuitRootPart, EquipmentSlot.FEET, humanoidRenderState.feetEquipment, null));
        }
        if (Utils.isJetSuitPart(humanoidRenderState.legsEquipment)) {
            this.renderArmorPiece(poseStack, bufferSource, humanoidRenderState.legsEquipment, EquipmentSlot.LEGS, packedLight, new JetSuitModel(jetSuitRootPart, EquipmentSlot.LEGS, humanoidRenderState.legsEquipment, null));
        }
        if (Utils.isJetSuitPart(humanoidRenderState.chestEquipment)) {
            this.renderArmorPiece(poseStack, bufferSource, humanoidRenderState.chestEquipment, EquipmentSlot.CHEST, packedLight, new JetSuitModel(jetSuitRootPart, EquipmentSlot.CHEST, humanoidRenderState.chestEquipment, null));
        }
        if (Utils.isJetSuitPart(humanoidRenderState.headEquipment)) {
            this.renderArmorPiece(poseStack, bufferSource, humanoidRenderState.headEquipment, EquipmentSlot.HEAD, packedLight, new JetSuitModel(jetSuitRootPart, EquipmentSlot.HEAD, humanoidRenderState.headEquipment, null));
        }
        ModelPart spaceSuitRootPart = Minecraft.getInstance().getEntityModels().bakeLayer(SpaceSuitModel.LAYER_LOCATION);
        if (Utils.isSpaceSuitPart(humanoidRenderState.feetEquipment)) {
            this.renderArmorPiece(poseStack, bufferSource, humanoidRenderState.feetEquipment, EquipmentSlot.FEET, packedLight, new SpaceSuitModel(spaceSuitRootPart, EquipmentSlot.FEET, humanoidRenderState.feetEquipment, null));
        }
        if (Utils.isSpaceSuitPart(humanoidRenderState.legsEquipment)) {
            this.renderArmorPiece(poseStack, bufferSource, humanoidRenderState.legsEquipment, EquipmentSlot.LEGS, packedLight, new SpaceSuitModel(spaceSuitRootPart, EquipmentSlot.LEGS, humanoidRenderState.legsEquipment, null));
        }
        if (Utils.isSpaceSuitPart(humanoidRenderState.chestEquipment)) {
            this.renderArmorPiece(poseStack, bufferSource, humanoidRenderState.chestEquipment, EquipmentSlot.CHEST, packedLight, new SpaceSuitModel(spaceSuitRootPart, EquipmentSlot.CHEST, humanoidRenderState.chestEquipment, null));
        }
        if (Utils.isSpaceSuitPart(humanoidRenderState.headEquipment)) {
            this.renderArmorPiece(poseStack, bufferSource, humanoidRenderState.headEquipment, EquipmentSlot.HEAD, packedLight, new SpaceSuitModel(spaceSuitRootPart, EquipmentSlot.HEAD, humanoidRenderState.headEquipment, null));
        }
        if (Utils.isSpaceSuitPart(humanoidRenderState.chestEquipment) && (item = humanoidRenderState.chestEquipment.getItem()) instanceof SpaceSuit) {
            SpaceSuit spaceSuitItem = (SpaceSuit)item;
            spaceSuitItem.getModules(humanoidRenderState.chestEquipment).forEach(module -> module.renderModel(poseStack, bufferSource, humanoidRenderState, packedLight));
        }
    }
}

