/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.capabilities.types;

import com.fej1fun.potentials.capabilities.types.providers.BlockCapabilityProvider;
import com.fej1fun.potentials.capabilities.types.providers.CapabilityProvider;
import com.fej1fun.potentials.platform.HolderHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface BlockCapabilityHolder<X, Y> {
    public static <X, Y> BlockCapabilityHolder<X, Y> create(Class<X> apiClass, Class<Y> contextClass, ResourceLocation identifier) {
        return HolderHelper.createBlock(apiClass, contextClass, identifier);
    }

    public static <X> BlockCapabilityHolder<X, @Nullable Direction> createSided(Class<X> apiClass, ResourceLocation identifier) {
        return BlockCapabilityHolder.create(apiClass, Direction.class, identifier);
    }

    public static <X> BlockCapabilityHolder<X, Void> createVoid(Class<X> apiClass, ResourceLocation identifier) {
        return BlockCapabilityHolder.create(apiClass, Void.TYPE, identifier);
    }

    @Nullable
    public X getCapability(Level var1, BlockPos var2, Y var3);

    @Nullable
    public X getCapability(Level var1, BlockPos var2, BlockState var3, BlockEntity var4, Y var5);

    public void registerForBlock(BlockCapabilityProvider<X, Y> var1, Supplier<Block> var2);

    public void registerForBlockEntity(CapabilityProvider<BlockEntity, X, Y> var1, Supplier<BlockEntityType<?>> var2);

    public ResourceLocation getIdentifier();
}

