/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.fluid.FluidStack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidAmountMapDataComponent
implements Serializable {
    public static final Codec<FluidAmountMapDataComponent> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)BuiltInRegistries.FLUID.holderByNameCodec().listOf().fieldOf("fluids").forGetter(component -> component.fluids.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).wrapAsHolder(arg_0)).toList()), (App)Codec.LONG.listOf().fieldOf("amounts").forGetter(component -> component.amounts)).apply((Applicative)instance, FluidAmountMapDataComponent::create));
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidAmountMapDataComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.FLUID).apply(ByteBufCodecs.list()), component -> component.fluids.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).wrapAsHolder(arg_0)).toList(), (StreamCodec)ByteBufCodecs.VAR_LONG.apply(ByteBufCodecs.list()), component -> component.amounts, FluidAmountMapDataComponent::create);
    protected final List<Fluid> fluids;
    protected final List<Long> amounts;

    public FluidAmountMapDataComponent(Map<Fluid, Long> fluidAmounts) {
        if (fluidAmounts.isEmpty()) {
            throw new IllegalArgumentException("Map<Fluid, Long> Cannot be empty");
        }
        this.fluids = new ArrayList<Fluid>(fluidAmounts.keySet());
        this.amounts = new ArrayList<Long>(fluidAmounts.values());
    }

    public FluidAmountMapDataComponent(List<Fluid> fluids, List<Long> amounts) {
        if (fluids.isEmpty()) {
            throw new IllegalArgumentException("List<Fluid> Cannot be empty");
        }
        if (amounts.isEmpty()) {
            throw new IllegalArgumentException("List<Long> Cannot be empty");
        }
        if (fluids.size() != amounts.size()) {
            throw new IllegalArgumentException("List<Fluid> must be the same length as List<Long>");
        }
        this.fluids = Arrays.asList(fluids.toArray(new Fluid[0]));
        this.amounts = Arrays.asList(amounts.toArray(new Long[0]));
    }

    public static FluidAmountMapDataComponent create(List<Holder<Fluid>> holders, List<Long> amounts) {
        if (holders.isEmpty()) {
            throw new IllegalArgumentException("List<Holder<Fluid>> Cannot be empty");
        }
        if (amounts.isEmpty()) {
            throw new IllegalArgumentException("List<Long> Cannot be empty");
        }
        if (holders.size() != amounts.size()) {
            throw new IllegalArgumentException("List<Holder<Fluid>> must be the same length as List<Long>");
        }
        return new FluidAmountMapDataComponent(holders.stream().map(Holder::value).toList(), amounts);
    }

    public static FluidAmountMapDataComponent create(List<FluidStack> fluidStacks) {
        if (fluidStacks.isEmpty()) {
            throw new IllegalArgumentException("List<FluidStack> Cannot be empty");
        }
        return new FluidAmountMapDataComponent(fluidStacks.stream().collect(Collectors.toMap(FluidStack::getFluid, FluidStack::getAmount)));
    }

    public static FluidAmountMapDataComponent emptyWithSize(int size) {
        NonNullList fluids = NonNullList.withSize((int)size, (Object)Fluids.EMPTY);
        NonNullList amounts = NonNullList.withSize((int)size, (Object)0L);
        return new FluidAmountMapDataComponent((List<Fluid>)fluids, (List<Long>)amounts);
    }

    public List<FluidStack> asFluidStackList() {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>(this.fluids.size());
        for (int i = 0; i < this.fluids.size(); ++i) {
            stacks.add(this.getAsFluidStack(i));
        }
        stacks.trimToSize();
        return Collections.unmodifiableList(stacks);
    }

    public Fluid getFluid(int i) {
        return this.fluids.get(i);
    }

    public long getAmount(int i) {
        return this.amounts.get(i);
    }

    public FluidStack getAsFluidStack(int i) {
        return FluidStack.create((Fluid)this.getFluid(i), (long)this.getAmount(i));
    }

    public void setFluid(int i, Fluid fluid) {
        this.fluids.set(i, fluid);
    }

    public void setAmount(int i, Long amount) {
        this.amounts.set(i, amount);
    }

    public void setFluidStack(int i, FluidStack stack) {
        this.setFluid(i, stack.getFluid());
        this.setAmount(i, stack.getAmount());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FluidAmountMapDataComponent) {
            FluidAmountMapDataComponent component = (FluidAmountMapDataComponent)obj;
            return component.fluids.equals(this.fluids) && component.amounts.equals(this.amounts);
        }
        return super.equals(obj);
    }

    private static <T> List<T> getListFromStream(Stream<T> s) {
        ArrayList list = new ArrayList(0);
        s.forEach(list::add);
        list.trimToSize();
        return list;
    }

    public FluidAmountMapDataComponent copy() {
        return new FluidAmountMapDataComponent(new ArrayList<Fluid>(this.fluids), new ArrayList<Long>(this.amounts));
    }
}

