/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.fluid;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.UniversalFluidItemStorage;
import dev.architectury.fluid.FluidStack;
import java.util.Iterator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemFluidStorage
implements UniversalFluidItemStorage {
    protected final long maxAmount;
    protected final long maxFill;
    protected final long maxDrain;
    protected final ItemStack stack;
    protected final DataComponentType<FluidAmountMapDataComponent> component;
    private final int tanks;

    public ItemFluidStorage(DataComponentType<FluidAmountMapDataComponent> component, ItemStack stack, int tanks, long maxAmount, long maxFill, long maxDrain) {
        this.maxAmount = maxAmount;
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
        this.stack = stack;
        this.component = component;
        this.tanks = tanks;
        if (!this.stack.has(component)) {
            this.stack.set(component, (Object)this.getEmpty());
        }
    }

    public ItemFluidStorage(DataComponentType<FluidAmountMapDataComponent> component, ItemStack stack, int tanks, long maxAmount) {
        this(component, stack, tanks, maxAmount, maxAmount, maxAmount);
    }

    private FluidAmountMapDataComponent getEmpty() {
        return FluidAmountMapDataComponent.emptyWithSize(this.tanks);
    }

    private FluidAmountMapDataComponent getComponent() {
        return (FluidAmountMapDataComponent)this.stack.getOrDefault(this.component, (Object)this.getEmpty());
    }

    @Override
    public int getTanks() {
        return this.tanks;
    }

    @Override
    public FluidStack getFluidInTank(int tank) {
        return this.getComponent().getAsFluidStack(tank);
    }

    public void setFluidInTank(int tank, FluidStack fluidStack) {
        this.getComponent().setFluidStack(tank, fluidStack);
    }

    public long getFluidValueInTank(int tank) {
        return this.getComponent().getAmount(tank);
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.maxAmount;
    }

    @Override
    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    @Override
    public long fill(FluidStack stack, boolean simulate) {
        long filled = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!this.isFluidValid(i, stack) || this.getFluidInTank(i).getFluid() != stack.getFluid() && !this.getFluidInTank(i).isEmpty() || this.getFluidValueInTank(i) >= this.maxAmount) continue;
            filled = Math.clamp(Math.min(this.maxFill, stack.getAmount()), 0L, this.maxAmount - this.getFluidValueInTank(i));
            if (simulate) break;
            this.setFluidInTank(i, stack.copyWithAmount(this.getFluidValueInTank(i) + filled));
            this.setChanged();
            break;
        }
        return filled;
    }

    @Override
    public FluidStack drain(FluidStack stack, boolean simulate) {
        long drained = 0L;
        for (int i = 0; i < this.getTanks(); ++i) {
            if (!this.isFluidValid(i, stack) || this.getFluidInTank(i).isEmpty() || this.getFluidInTank(i).getFluid() != stack.getFluid()) continue;
            drained = Math.min(this.getFluidValueInTank(i), Math.min(this.maxDrain, stack.getAmount()));
            if (simulate) break;
            this.setFluidInTank(i, stack.copyWithAmount(this.getFluidValueInTank(i) - drained));
            this.setChanged();
            break;
        }
        return FluidStack.create((FluidStack)stack, (long)drained);
    }

    @Override
    @NotNull
    public Iterator<FluidStack> iterator() {
        return this.getComponent().asFluidStackList().iterator();
    }

    @Override
    public ItemStack getContainer() {
        return this.stack;
    }

    public void setChanged() {
        this.stack.set(this.component, (Object)this.getComponent().copy());
    }
}

