/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.InvisibleButton;
import com.st0x0ef.stellaris.client.screens.components.LaunchButton;
import com.st0x0ef.stellaris.client.screens.components.ModifiedButton;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.info.MoonInfo;
import com.st0x0ef.stellaris.client.screens.info.PlanetInfo;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.network.packets.TeleportEntityToPlanetPacket;
import com.st0x0ef.stellaris.common.registry.TranslatableRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.networking.NetworkManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8710;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWScrollCallback;

@Environment(value=EnvType.CLIENT)
public class PlanetSelectionScreen
extends class_465<PlanetSelectionMenu> {
    public static final class_2960 HIGHLIGHTER_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/planet_highlighter.png");
    public static final class_2960 BLACK_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/black.png");
    public static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/planet_selection.png");
    public static final class_2960 SCROLLER_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/scroller.png");
    public static final class_2960 SMALL_BUTTON_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/small_button.png");
    public static final class_2960 BUTTON_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/button.png");
    public static final class_2960 LARGE_BUTTON_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/large_button.png");
    public static final class_2960 LAUNCH_BUTTON_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button.png");
    public static final class_2960 SMALL_MENU_LIST = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/planet_menu.png");
    public static final class_2960 LARGE_MENU_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/large_planet_menu.png");
    public static final class_2960 LARGE_MENU_TEXTURE_RED = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/large_planet_menu_red.png");
    public static final List<CelestialBody> STARS = new ArrayList<CelestialBody>();
    public static final List<PlanetInfo> PLANETS = new ArrayList<PlanetInfo>();
    public static final List<MoonInfo> MOONS = new ArrayList<MoonInfo>();
    public static final class_2561 temperature = class_2561.method_43471((String)"text.stellaris.planetscreen.temperature");
    public static final class_2561 gravity = class_2561.method_43471((String)"text.stellaris.planetscreen.gravity");
    public static final class_2561 launch = class_2561.method_43471((String)"text.stellaris.planetscreen.launch");
    public static final class_2561 oxygen = class_2561.method_43471((String)"text.stellaris.planetscreen.oxygen");
    public static final class_2561 system = class_2561.method_43471((String)"text.stellaris.planetscreen.system");
    public static final class_2561 error_message = class_2561.method_43471((String)"text.stellaris.planetscreen.error_message");
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final long UPDATE_INTERVAL = 1L;
    public static final class_1657 p = class_310.method_1551().field_1724;
    private boolean isLaunching = false;
    private boolean showLargeMenu = false;
    private boolean showHelpMenu = true;
    LaunchButton launchButton;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double lastMouseX;
    private double lastMouseY;
    private boolean dragging = false;
    private boolean isPausePressed = false;
    private boolean isShiftPressed = false;
    private boolean isWheelButtonDown = false;
    public boolean isPlanetScreenOpened;
    private double zoomLevel = 1.0;
    private GLFWScrollCallback prevScrollCallback;
    private final List<InvisibleButton> planetButtons = new ArrayList<InvisibleButton>();
    private final List<InvisibleButton> moonButtons = new ArrayList<InvisibleButton>();
    public static CelestialBody focusedBody = null;
    public static CelestialBody hoveredBody = null;
    private int currentHighlighterFrame = 0;
    private final int totalHighlighterFrames = 30;
    double angle;

    public PlanetSelectionScreen(PlanetSelectionMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)abstractContainerMenu, inventory, component);
        this.field_2792 = 1200;
        this.field_2779 = 1600;
        this.field_25270 = this.field_2779 - 110;
    }

    protected void method_25426() {
        super.method_25426();
        this.getMenu().freeze_gui = false;
        this.centerSun();
        this.isPlanetScreenOpened = true;
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, this::onMouseScroll);
        this.initializeAllButtons();
    }

    public boolean canLaunch(Planet planet) {
        if (this.getMenu().getForceCanGoTo()) {
            return true;
        }
        class_1657 player = this.getPlayer();
        if (player == null) {
            return false;
        }
        class_1297 vehicle = player.method_5854();
        if (vehicle instanceof RocketEntity) {
            RocketEntity rocket = (RocketEntity)vehicle;
            if (PlanetUtil.isPlanet(player.method_37908().method_27983().method_29177())) {
                return rocket.canGoTo(PlanetUtil.getPlanet(player.method_37908().method_27983().method_29177()), planet);
            }
            return rocket.canGoTo(PlanetUtil.getPlanet(class_1937.field_25179.method_29177()), planet);
        }
        return false;
    }

    private void initializeAllButtons() {
        this.initializePlanetButtons();
        this.initializeMoonButtons();
        this.initializeLaunchButton();
    }

    private void initializePlanetButtons() {
        this.planetButtons.clear();
        for (PlanetInfo planet : PLANETS) {
            int planetWidth = (int)((double)planet.width * this.zoomLevel);
            int planetHeight = (int)((double)planet.height * this.zoomLevel);
            float planetX = (float)(((double)planet.orbitCenter.x + this.offsetX + planet.orbitRadius * Math.cos(planet.currentAngle) - (double)planetWidth / 2.0) * this.zoomLevel);
            float planetY = (float)(((double)planet.orbitCenter.y + this.offsetY + planet.orbitRadius * Math.sin(planet.currentAngle) - (double)planetHeight / 2.0) * this.zoomLevel);
            InvisibleButton button = new InvisibleButton((int)planetX, (int)planetY, planetWidth + 2, planetHeight + 2, (class_2561)class_2561.method_43470((String)planet.name), btn -> this.onPlanetButtonClick(planet), () -> {
                hoveredBody = planet;
            });
            this.planetButtons.add(button);
            this.method_37063((class_364)button);
        }
    }

    private void updatePlanetsButton(int offsetX, int offsetY) {
        for (InvisibleButton button : this.planetButtons) {
            button.method_46421(button.method_46426() - offsetX);
            button.method_46419(button.method_46426() - offsetY);
        }
    }

    private void initializeMoonButtons() {
        this.moonButtons.clear();
        for (MoonInfo moon : MOONS) {
            int moonWidth = (int)((double)moon.width * this.zoomLevel);
            int moonHeight = (int)((double)moon.height * this.zoomLevel);
            float moonX = (float)(((double)moon.orbitCenter.x + this.offsetX + moon.orbitRadius * Math.cos(moon.currentAngle) - (double)moonWidth / 2.0) * this.zoomLevel);
            float moonY = (float)(((double)moon.orbitCenter.y + this.offsetY + moon.orbitRadius * Math.sin(moon.currentAngle) - (double)moonHeight / 2.0) * this.zoomLevel);
            InvisibleButton button = new InvisibleButton((int)moonX, (int)moonY, moonWidth, moonHeight, (class_2561)class_2561.method_43470((String)moon.name), btn -> this.onMoonButtonClick(moon), () -> {
                hoveredBody = moon;
            });
            this.moonButtons.add(button);
            this.method_37063((class_364)button);
        }
    }

    private void initializeLaunchButton() {
        int buttonWidth = 74;
        int buttonHeight = 20;
        int buttonX = (this.field_22789 - buttonWidth) / 4 + 100;
        int buttonY = (this.field_22790 - buttonHeight) / 4;
        this.launchButton = new LaunchButton(buttonX, buttonY, buttonWidth, buttonHeight, launch, btn -> this.onLaunchButtonClick());
        this.launchButton.setButtonTexture(LAUNCH_BUTTON_TEXTURE, class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button_hovered.png"));
        this.method_37063((class_364)this.launchButton);
        this.launchButton.field_22764 = false;
    }

    private void onPlanetButtonClick(PlanetInfo planet) {
        if (!this.showLargeMenu) {
            focusedBody = planet;
            this.centerOnBody(planet);
            this.showLargeMenu = true;
        }
    }

    private void onMoonButtonClick(MoonInfo moon) {
        if (!this.showLargeMenu && moon.clickable) {
            focusedBody = moon;
            this.centerOnBody(moon);
            this.showLargeMenu = true;
        }
    }

    private void onLaunchButtonClick() {
        if (focusedBody != null && PlanetSelectionScreen.focusedBody.dimension != null) {
            if (this.canLaunch(PlanetUtil.getPlanet(PlanetSelectionScreen.focusedBody.dimension))) {
                this.tpToFocusedPlanet();
            } else if (PlanetUtil.getPlanet(PlanetSelectionScreen.focusedBody.dimension).name().equals("Earth")) {
                this.tpToFocusedPlanet();
            }
            this.showLargeMenu = false;
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_2389(graphics, partialTicks, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (!this.isPausePressed) {
            this.updatePlanets();
        }
        if (focusedBody != null) {
            this.centerOnBody(focusedBody);
        }
        if (!this.showLargeMenu) {
            this.launchButton.field_22764 = false;
        }
        this.renderHelp(graphics);
        this.drawOrbits(graphics);
        this.renderBodiesAndPlanets(graphics);
        this.renderHighlighter(graphics, mouseX, mouseY);
        if (hoveredBody != null) {
            this.updateHighlighterPosition(graphics, hoveredBody);
        }
        if (focusedBody != null) {
            this.updateHighlighterPosition(graphics, focusedBody);
        }
        this.renderLargeMenu(graphics);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25290(class_1921::method_62277, BACKGROUND_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
    }

    public void renderBodiesAndPlanets(class_332 graphics) {
        this.renderStars(graphics);
        this.renderPlanets(graphics);
        this.renderMoons(graphics);
        this.initializePlanetButtons();
        this.initializeMoonButtons();
    }

    private void renderHelp(class_332 graphics) {
        if (this.showHelpMenu) {
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"text.stellaris.planetscreen.press_space"), this.field_22789 / 2, this.field_22790 - 20, 0xFFFFFC);
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"text.stellaris.planetscreen.arrows"), this.field_22789 / 2, this.field_22790 - 10, 0xFFFFFC);
        }
    }

    private void renderStars(class_332 graphics) {
        class_327 font = class_310.method_1551().field_1772;
        for (CelestialBody star : STARS) {
            float bodyX = (float)(((double)star.x + this.offsetX) * this.zoomLevel - (double)(star.width / 2.0f) * this.zoomLevel);
            float bodyY = (float)(((double)star.y + this.offsetY) * this.zoomLevel - (double)(star.height / 2.0f) * this.zoomLevel);
            int bodyWidth = (int)((double)star.width * this.zoomLevel);
            int bodyHeight = (int)((double)star.height * this.zoomLevel);
            graphics.method_25290(class_1921::method_62277, star.texture, (int)bodyX, (int)bodyY, 0.0f, 0.0f, bodyWidth, bodyHeight, bodyWidth, bodyHeight);
            int nameWidth = font.method_27525((class_5348)star.getTranslatable());
            graphics.method_27535(font, star.getTranslatable(), (int)(bodyX + (float)bodyWidth / 2.0f - (float)nameWidth / 2.0f), (int)(bodyY + (float)bodyHeight), 0xFFFFFF);
        }
    }

    private void renderPlanets(class_332 graphics) {
        class_327 font = class_310.method_1551().field_1772;
        for (PlanetInfo planet : PLANETS) {
            CelestialBody orbitCenter = planet.orbitCenter;
            float orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            float orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            float planetX = (float)((double)orbitCenterX + planet.orbitRadius * this.zoomLevel * Math.cos(planet.currentAngle) - (double)(planet.width / 2.0f) * this.zoomLevel);
            float planetY = (float)((double)orbitCenterY + planet.orbitRadius * this.zoomLevel * Math.sin(planet.currentAngle) - (double)(planet.height / 2.0f) * this.zoomLevel);
            int planetWidth = (int)((double)planet.width * this.zoomLevel);
            int planetHeight = (int)((double)planet.height * this.zoomLevel);
            ScreenHelper.drawTexturewithRotation(graphics, planet.texture, (int)planetX, (int)planetY, 0, 0, planetWidth, planetHeight, planetWidth, planetHeight, (float)planet.currentAngle);
            int nameWidth = font.method_27525((class_5348)planet.getTranslatable());
            graphics.method_27535(font, planet.getTranslatable(), (int)(planetX + (float)planetWidth / 2.0f - (float)nameWidth / 2.0f), (int)(planetY + (float)planetHeight), 0xFFFFFF);
        }
    }

    private void renderMoons(class_332 graphics) {
        for (MoonInfo moon : MOONS) {
            float moonX = (float)(((double)moon.x + this.offsetX) * this.zoomLevel - (double)(moon.width / 2.0f) * this.zoomLevel);
            float moonY = (float)(((double)moon.y + this.offsetY) * this.zoomLevel - (double)(moon.height / 2.0f) * this.zoomLevel);
            int moonWidth = (int)((double)moon.width * this.zoomLevel);
            int moonHeight = (int)((double)moon.height * this.zoomLevel);
            ScreenHelper.drawTexturewithRotation(graphics, moon.texture, (int)moonX, (int)moonY, 0, 0, moonWidth, moonHeight, moonWidth, moonHeight, (float)moon.currentAngle);
        }
    }

    private void renderHighlighter(class_332 graphics, int mouseX, int mouseY) {
        if (!(this.showLargeMenu || hoveredBody == null && focusedBody == null)) {
            CelestialBody bodyToHighlight = hoveredBody != null ? hoveredBody : focusedBody;
            this.renderBodyDescription(graphics, bodyToHighlight, mouseX, mouseY);
            this.renderHighlightFrame(graphics, bodyToHighlight);
        }
    }

    private void renderBodyDescription(class_332 graphics, CelestialBody bodyToHighlight, int mouseX, int mouseY) {
        ArrayList<class_2561> bodyDescription = new ArrayList<class_2561>();
        bodyDescription.add(Utils.getMessageComponent("\u00a7f" + bodyToHighlight.getTranslatable().getString()));
        if (!this.isShiftPressed) {
            bodyDescription.add(Utils.getMessageComponent("\u00a78" + TranslatableRegistry.HOLD_SHIFT.getString()));
        } else {
            this.addDetailedDescription(bodyDescription, bodyToHighlight);
        }
        if (this.isPausePressed) {
            graphics.method_51434(this.field_22793, bodyDescription, mouseX, mouseY);
        }
    }

    private void addDetailedDescription(List<class_2561> bodyDescription, CelestialBody bodyToHighlight) {
        bodyDescription.add(Utils.getMessageComponent("\u00a7f\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3"));
        Planet planet = PlanetUtil.getPlanet(bodyToHighlight.dimension);
        if (planet == null) {
            bodyDescription.add(Utils.getMessageComponent(error_message.getString(), "Red"));
        } else {
            bodyDescription.add(Utils.getMessageComponent(temperature.getString() + " : " + planet.temperature() + "\u00b0C"));
            bodyDescription.add(Utils.getMessageComponent(gravity.getString() + " : " + planet.gravity() + "m/s\u00b2"));
            bodyDescription.add(Utils.getMessageComponent(oxygen.getString() + " : " + planet.oxygen()));
            bodyDescription.add(Utils.getMessageComponent(system.getString() + " : " + class_2561.method_43471((String)planet.system()).getString()));
            if (bodyToHighlight instanceof PlanetInfo && this.getMoonsCount((PlanetInfo)bodyToHighlight) > 0) {
                bodyDescription.add(Utils.getMessageComponent(""));
                bodyDescription.add(Utils.getMessageComponent(TranslatableRegistry.MOONS.getString() + " : " + this.getMoonsCount((PlanetInfo)bodyToHighlight)));
            }
            if (this.getPlayer().method_5682() != null) {
                bodyDescription.add(Utils.getMessageComponent(""));
                bodyDescription.add(Utils.getMessageComponent(TranslatableRegistry.PLAYERS.getString() + " : " + Utils.getPlayerCountInDimension(this.getPlayer().method_5682(), bodyToHighlight.dimension)));
            }
        }
    }

    private void renderHighlightFrame(class_332 graphics, CelestialBody bodyToHighlight) {
        int highlightWidth = (int)((double)bodyToHighlight.width * this.zoomLevel);
        int highlightHeight = (int)((double)bodyToHighlight.height * this.zoomLevel);
        float highlightX = (float)(((double)bodyToHighlight.x + this.offsetX) * this.zoomLevel - (double)highlightWidth / 2.0);
        float highlightY = (float)(((double)bodyToHighlight.y + this.offsetY) * this.zoomLevel - (double)highlightHeight / 2.0);
        this.currentHighlighterFrame = (this.currentHighlighterFrame + 1) % 30;
        int frameY = this.currentHighlighterFrame * highlightHeight;
        float currentAngle = bodyToHighlight instanceof PlanetInfo ? (float)((PlanetInfo)bodyToHighlight).currentAngle : (float)((MoonInfo)bodyToHighlight).currentAngle;
        ScreenHelper.drawTexturewithRotation(graphics, HIGHLIGHTER_TEXTURE, (int)highlightX, (int)highlightY, 0, frameY, highlightWidth, highlightHeight, highlightWidth, 30 * highlightHeight, currentAngle);
    }

    private void renderLargeMenu(class_332 graphics) {
        if (this.showLargeMenu) {
            class_5250 systemV;
            this.getMenu().freeze_gui = false;
            class_2960 CELESTIAL_BODY_TEXTURE = PlanetSelectionScreen.focusedBody.texture;
            class_2561 CELESTIAL_BODY_NAME = focusedBody.getTranslatable();
            Planet planet = PlanetUtil.getPlanet(PlanetSelectionScreen.focusedBody.dimension);
            if (planet == null) {
                return;
            }
            float CELESTIAL_BODY_TEMPERATURE = planet.temperature();
            float CELESTIAL_BODY_GRAVITY = planet.gravity();
            boolean CELESTIAL_BODY_OXYGEN = planet.oxygen();
            String CELESTIAL_BODY_SYSTEM = planet.system();
            if (CELESTIAL_BODY_SYSTEM == null) {
                systemV = class_2561.method_43470((String)(String.valueOf(system) + " : null"));
            } else {
                class_5250 systemTranslatable = class_2561.method_43471((String)CELESTIAL_BODY_SYSTEM);
                systemV = class_2561.method_43470((String)(system.getString() + " : " + systemTranslatable.getString()));
            }
            class_5250 temperatureV = class_2561.method_43470((String)(temperature.getString() + " : " + planet.temperature() + "\u00b0C"));
            class_5250 oxygenV = class_2561.method_43470((String)(oxygen.getString() + " : " + CELESTIAL_BODY_OXYGEN));
            class_5250 gravityV = class_2561.method_43470((String)(gravity.getString() + " : " + CELESTIAL_BODY_GRAVITY + "m/s"));
            int oxygenColor = CELESTIAL_BODY_OXYGEN ? Utils.getColorHexCode("Lime") : Utils.getColorHexCode("Red");
            int temperatureColor = CELESTIAL_BODY_TEMPERATURE >= 100.0f ? Utils.getColorHexCode("DarkRed") : (CELESTIAL_BODY_TEMPERATURE >= 0.0f ? Utils.getColorHexCode("Lime") : (CELESTIAL_BODY_TEMPERATURE >= -100.0f ? Utils.getColorHexCode("Cyan") : Utils.getColorHexCode("Blue")));
            int menuWidth = 215;
            int menuHeight = 177;
            int buttonWidth = 74;
            int buttonHeight = 20;
            int centerX = (this.field_22789 - menuWidth) / 2;
            int centerY = (this.field_22790 - menuHeight) / 2;
            int buttonX = centerX + buttonWidth / 2 - buttonWidth / 3 - buttonWidth / 15;
            int buttonY = centerY + buttonHeight / 2 + 1;
            int textX = buttonX + buttonWidth / 4 - 20;
            this.launchButton.field_22764 = true;
            this.launchButton.method_48229(buttonX, buttonY);
            float alpha = 0.5f;
            graphics.method_51439(this.field_22793, CELESTIAL_BODY_NAME, textX, buttonY + buttonHeight / 4 + 37, 0xFFFFFF, true);
            graphics.method_51433(this.field_22793, "\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3\uffe3", textX, buttonY + buttonHeight / 4 + 50, 0xFFFFFF, true);
            graphics.method_51439(this.field_22793, (class_2561)temperatureV, textX, buttonY + buttonHeight / 4 + 60, temperatureColor, true);
            graphics.method_51439(this.field_22793, (class_2561)oxygenV, textX, buttonY + buttonHeight / 4 + 90, oxygenColor, true);
            graphics.method_51439(this.field_22793, (class_2561)systemV, textX, buttonY + buttonHeight / 4 + 105, 0xFFFFFF, true);
            if (focusedBody instanceof PlanetInfo && this.getMoonsCount((PlanetInfo)focusedBody) > 0) {
                graphics.method_51433(this.field_22793, TranslatableRegistry.MOONS.getString() + " : " + this.getMoonsCount((PlanetInfo)focusedBody), textX, buttonY + buttonHeight / 4 + 120, 0xD3D3D3, true);
            }
            if (this.getPlayer().method_5682() != null) {
                graphics.method_51433(this.field_22793, TranslatableRegistry.PLAYERS.getString() + " : " + Utils.getPlayerCountInDimension(this.getPlayer().method_5682(), PlanetSelectionScreen.focusedBody.dimension), textX, buttonY + buttonHeight / 4 + 135, 0xFFFFFF, false);
            }
            if (this.canLaunch(planet)) {
                graphics.method_51439(this.field_22793, (class_2561)gravityV, textX, buttonY + buttonHeight / 4 + 75, Utils.getColorHexCode("White"), true);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                graphics.method_25290(class_1921::method_62277, LARGE_MENU_TEXTURE, centerX, centerY, 0.0f, 0.0f, menuWidth, menuHeight, menuWidth, menuHeight);
                this.launchButton.setButtonTexture(class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button.png"), class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button_hovered.png"));
            } else if (Objects.equals(PlanetSelectionScreen.focusedBody.name, "Earth")) {
                graphics.method_51439(this.field_22793, (class_2561)gravityV, textX, buttonY + buttonHeight / 4 + 75, Utils.getColorHexCode("White"), true);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                this.launchButton.setButtonTexture(class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button.png"), class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button_hovered.png"));
                graphics.method_25290(class_1921::method_62277, LARGE_MENU_TEXTURE, centerX, centerY, 0.0f, 0.0f, menuWidth, menuHeight, menuWidth, menuHeight);
            } else {
                graphics.method_51439(this.field_22793, (class_2561)gravityV, textX, buttonY + buttonHeight / 4 + 75, Utils.getColorHexCode("Orange"), true);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                graphics.method_25290(class_1921::method_62277, LARGE_MENU_TEXTURE_RED, centerX, centerY, 0.0f, 0.0f, menuWidth, menuHeight, menuWidth, menuHeight);
                this.launchButton.setButtonTexture(class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/no_launch_button.png"), class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/no_launch_button_hovered.png"));
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25290(class_1921::method_62277, BLACK_TEXTURE, centerX + menuWidth - 64, centerY + menuHeight / 2 - 32, 0.0f, 0.0f, 48, 48, 48, 48);
            if (PlanetSelectionScreen.focusedBody.width != PlanetSelectionScreen.focusedBody.height) {
                if ((float)Math.min((int)PlanetSelectionScreen.focusedBody.width, (int)PlanetSelectionScreen.focusedBody.height) == PlanetSelectionScreen.focusedBody.width) {
                    float rate = PlanetSelectionScreen.focusedBody.height / PlanetSelectionScreen.focusedBody.width;
                    graphics.method_25290(class_1921::method_62277, CELESTIAL_BODY_TEXTURE, centerX + menuWidth - 46, centerY + menuHeight / 2 - 14, 0.0f, 0.0f, 12, (int)(12.0f * rate), 12, (int)(12.0f * rate));
                } else {
                    float rate = PlanetSelectionScreen.focusedBody.width / PlanetSelectionScreen.focusedBody.height;
                    graphics.method_25290(class_1921::method_62277, CELESTIAL_BODY_TEXTURE, centerX + menuWidth - 46, centerY + menuHeight / 2 - 14, 0.0f, 0.0f, (int)(12.0f * rate), 12, (int)(12.0f * rate), 12);
                }
            } else {
                graphics.method_25290(class_1921::method_62277, CELESTIAL_BODY_TEXTURE, centerX + menuWidth - 46, centerY + menuHeight / 2 - 14, 0.0f, 0.0f, 12, 12, 12, 12);
            }
        } else {
            this.launchButton.field_22764 = false;
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 90) {
            if (focusedBody != null && this.canLaunch(PlanetUtil.getPlanet(PlanetSelectionScreen.focusedBody.dimension))) {
                this.tpToFocusedPlanet();
            }
        } else if (keyCode == 72) {
            this.showHelpMenu = !this.showHelpMenu;
        } else if (keyCode == 32) {
            this.isPausePressed = !this.isPausePressed;
        } else if (keyCode == 340 || keyCode == 344) {
            this.isShiftPressed = true;
        } else if (keyCode == 262) {
            if (focusedBody instanceof CelestialBody) {
                focusedBody = this.getNextBodyByDistance(focusedBody);
                this.centerOnBody(focusedBody);
            }
        } else if (keyCode == 263) {
            if (focusedBody instanceof CelestialBody) {
                focusedBody = this.getPreviousBodyByDistance(focusedBody);
                this.centerOnBody(focusedBody);
            }
        } else if (keyCode == 264) {
            if (focusedBody instanceof PlanetInfo) {
                CelestialBody moonToBeFocused = this.getMoonsByDistance((PlanetInfo)focusedBody);
                if (moonToBeFocused.clickable) {
                    focusedBody = moonToBeFocused;
                    this.centerOnBody(focusedBody);
                }
            }
        } else if (keyCode == 265 && focusedBody instanceof MoonInfo) {
            focusedBody = ((MoonInfo)PlanetSelectionScreen.focusedBody).orbitCenter;
            this.centerOnBody(focusedBody);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private CelestialBody getNextBodyByDistance(CelestialBody currentBody) {
        CelestialBody celestialBody = currentBody;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlanetInfo.class, MoonInfo.class}, (Object)celestialBody, n)) {
            case -1: {
                return null;
            }
            case 0: {
                PlanetInfo planetInfo = (PlanetInfo)celestialBody;
                ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = 0; i < bodies.size(); ++i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i + 1; j < bodies.size(); ++j) {
                        if (((PlanetInfo)bodies.get((int)j)).orbitCenter != ((PlanetInfo)currentBody).orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break;
            }
            case 1: {
                MoonInfo moonInfo = (MoonInfo)celestialBody;
                ArrayList<MoonInfo> bodies = new ArrayList<MoonInfo>(MOONS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = 0; i < bodies.size(); ++i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i + 1; j < bodies.size(); ++j) {
                        if (((MoonInfo)bodies.get((int)j)).orbitCenter != ((MoonInfo)currentBody).orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break;
            }
        }
        return currentBody;
    }

    private CelestialBody getPreviousBodyByDistance(CelestialBody currentBody) {
        CelestialBody celestialBody = currentBody;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlanetInfo.class, MoonInfo.class}, (Object)celestialBody, n)) {
            case -1: {
                return null;
            }
            case 0: {
                PlanetInfo planetInfo = (PlanetInfo)celestialBody;
                ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = bodies.size() - 1; i >= 0; --i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i - 1; j >= 0; --j) {
                        if (((PlanetInfo)bodies.get((int)j)).orbitCenter != ((PlanetInfo)currentBody).orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break;
            }
            case 1: {
                MoonInfo moonInfo = (MoonInfo)celestialBody;
                ArrayList<MoonInfo> bodies = new ArrayList<MoonInfo>(MOONS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = bodies.size() - 1; i >= 0; --i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i - 1; j >= 0; --j) {
                        if (((MoonInfo)bodies.get((int)j)).orbitCenter != ((MoonInfo)currentBody).orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break;
            }
        }
        return currentBody;
    }

    private CelestialBody getMoonsByDistance(PlanetInfo currentBody) {
        CelestialBody smallestOrbitMoon = null;
        for (MoonInfo moon : MOONS) {
            if (!moon.orbitCenter.equals(currentBody) || smallestOrbitMoon != null && !(moon.orbitRadius < ((MoonInfo)smallestOrbitMoon).orbitRadius)) continue;
            smallestOrbitMoon = moon;
        }
        return smallestOrbitMoon != null ? smallestOrbitMoon : currentBody;
    }

    private int getMoonsCount(PlanetInfo currentBody) {
        int i = 0;
        for (MoonInfo moon : MOONS) {
            if (!moon.orbitCenter.equals(currentBody)) continue;
            ++i;
        }
        return i;
    }

    public void tpToFocusedPlanet() {
        if (focusedBody != null) {
            NetworkManager.sendToServer((class_8710)new TeleportEntityToPlanetPacket(PlanetSelectionScreen.focusedBody.dimension));
            long windowHandle = class_310.method_1551().method_22683().method_4490();
            this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((class_312)class_310.method_1551().field_1729).method_1598(arg_0, arg_1, arg_2));
        } else {
            Stellaris.LOG.error("Focused body is null");
        }
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344) {
            this.isShiftPressed = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    private void updatePlanets() {
        long time = class_156.method_658();
        if (!this.getMenu().freeze_gui || !this.isPausePressed) {
            for (PlanetInfo planet : PLANETS) {
                planet.updateAngle(time);
                planet.updatePosition();
                this.angle = planet.updateAngle(time);
            }
            for (MoonInfo moon : MOONS) {
                moon.updateAngle(time);
                moon.updatePosition();
                this.angle = moon.updateAngle(time);
            }
        }
    }

    public void drawOrbits(class_332 graphics) {
        float orbitCenterY;
        float orbitCenterX;
        CelestialBody orbitCenter;
        for (PlanetInfo planet : PLANETS) {
            orbitCenter = planet.orbitCenter;
            orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            PlanetSelectionScreen.renderOrbits(graphics, orbitCenterX, orbitCenterY, planet.orbitRadius * this.zoomLevel, 50, 1.0, orbitCenter.orbitColor);
        }
        for (MoonInfo moon : MOONS) {
            orbitCenter = moon.orbitCenter;
            orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            PlanetSelectionScreen.renderOrbits(graphics, orbitCenterX, orbitCenterY, moon.orbitRadius * this.zoomLevel, 75, 1.5, -7829368);
        }
    }

    public static void renderOrbits(class_332 graphics, double centerX, double centerY, double radius, int sides, double width, int color) {
        double angleIncrement = Math.PI * 2 / (double)sides;
        double prevX = centerX + radius;
        double prevY = centerY;
        for (int i = 1; i <= sides; ++i) {
            double angle = (double)i * angleIncrement;
            double x = centerX + radius * Math.cos(angle);
            double y = centerY + radius * Math.sin(angle);
            ScreenHelper.drawLine(graphics, (float)prevX, (float)prevY, (float)x, (float)y, (float)width, color);
            prevX = x;
            prevY = y;
        }
    }

    private void centerSun() {
        float centerX = (float)this.field_22789 / 2.0f;
        float centerY = (float)this.field_22790 / 2.0f;
        CelestialBody sun = PlanetSelectionScreen.findByNameStar("stellaris:sun");
        if (sun != null) {
            sun.setPosition(centerX, centerY);
        } else {
            Stellaris.LOG.error("stellaris:sun is null");
        }
        this.offsetX = 0.0;
        this.offsetY = 0.0;
    }

    public static CelestialBody findByNameStar(String id) {
        for (CelestialBody body : STARS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        Stellaris.LOG.warn("Star not found : {}", (Object)id);
        return null;
    }

    public static PlanetInfo findByNamePlanet(String id) {
        for (PlanetInfo body : PLANETS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        return null;
    }

    public static MoonInfo findByNameMoon(String id) {
        for (MoonInfo body : MOONS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        return null;
    }

    private void centerOnBody(CelestialBody body) {
        this.zoomLevel = this.isLaunching ? 1.6 : 1.0;
        this.offsetX = ((double)body.x - (double)this.field_22789 / 2.0) * -1.0;
        this.offsetY = ((double)body.y - (double)this.field_22790 / 2.0) * -1.0;
    }

    private void onMouseScroll(long window, double scrollX, double scrollY) {
        double[] mouseX = new double[1];
        double[] mouseY = new double[1];
        GLFW.glfwGetCursorPos((long)window, (double[])mouseX, (double[])mouseY);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_481 creativeScreen;
            class_437 class_4372;
            if (this.field_22787.field_1755 != null) {
                this.handleHotbarScroll(scrollY);
            }
            if ((class_4372 = this.field_22787.field_1755) instanceof class_481 && (creativeScreen = (class_481)class_4372).method_25401(mouseX[0], mouseY[0], scrollX, scrollY)) {
                return;
            }
            if (this.field_22787.field_1755 instanceof PlanetSelectionScreen && scrollY != 0.0) {
                for (int i = 0; i < 5; ++i) {
                    this.zoomLevel += scrollY * 0.004;
                }
                this.zoomLevel = Math.max(0.02, Math.min(this.zoomLevel, 2.0));
            }
        }
    }

    private boolean handleHotbarScroll(double scrollY) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            int currentSlot = this.field_22787.field_1724.method_31548().method_67532();
            int newSlot = currentSlot - (int)scrollY;
            if ((newSlot = (newSlot + 9) % 9) != currentSlot) {
                this.field_22787.field_1724.method_31548().method_61496(newSlot);
                return true;
            }
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 2) {
            this.isWheelButtonDown = true;
        }
        if (button == 0 || button == 1) {
            this.dragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            if (this.showLargeMenu) {
                if (this.launchButton.method_25402(mouseX, mouseY, button)) {
                    return true;
                }
                this.showLargeMenu = false;
                return true;
            }
            focusedBody = null;
            hoveredBody = null;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.dragging = false;
        }
        if (button == 2) {
            this.isWheelButtonDown = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            if (this.isWheelButtonDown) {
                double rotationSpeed = 0.005;
                double deltaAngle = deltaX * rotationSpeed;
                for (PlanetInfo planet : PLANETS) {
                    planet.currentAngle += deltaAngle;
                    planet.updatePosition();
                }
                for (MoonInfo moon : MOONS) {
                    moon.currentAngle += deltaAngle;
                    moon.updatePosition();
                }
            } else {
                this.offsetX += Utils.changeLastDigitToEven((mouseX - this.lastMouseX) / this.zoomLevel);
                this.offsetY += Utils.changeLastDigitToEven((mouseY - this.lastMouseY) / this.zoomLevel);
                this.updatePlanetsButton((int)this.offsetX, (int)this.offsetY);
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void updateHighlighterPosition(class_332 graphics, CelestialBody body) {
        int highlightWidth = (int)((double)body.width * this.zoomLevel);
        int highlightHeight = (int)((double)body.height * this.zoomLevel);
        float highlightX = (float)(((double)body.x + this.offsetX) * this.zoomLevel - (double)highlightWidth / 2.0);
        float highlightY = (float)(((double)body.y + this.offsetY) * this.zoomLevel - (double)highlightHeight / 2.0);
        this.currentHighlighterFrame = (this.currentHighlighterFrame + 1) % 30;
        int frameY = this.currentHighlighterFrame * highlightHeight;
        float currentAngle = body instanceof PlanetInfo ? (float)((PlanetInfo)body).currentAngle : (float)((MoonInfo)body).currentAngle;
        ScreenHelper.drawTexturewithRotation(graphics, HIGHLIGHTER_TEXTURE, (int)highlightX, (int)highlightY, 0, frameY, highlightWidth, highlightHeight, highlightWidth, 30 * highlightHeight, currentAngle);
    }

    public PlanetSelectionMenu getMenu() {
        return (PlanetSelectionMenu)this.field_2797;
    }

    public void method_25419() {
        if (this.getPlayer().stellaris$isPlanetMenuOpen()) {
            return;
        }
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((class_312)class_310.method_1551().field_1729).method_1598(arg_0, arg_1, arg_2));
        super.method_25419();
    }

    public class_1657 getPlayer() {
        return ((PlanetSelectionMenu)this.field_2797).getPlayer();
    }

    public ModifiedButton addButton(int x, int y, int row, int width, int height, boolean rocketCondition, ModifiedButton.ButtonTypes type, List<String> list, class_2960 buttonTexture, TexturedButton.ColorTypes colorType, class_2561 title, class_4185.class_4241 onPress) {
        return (ModifiedButton)this.method_37063((class_364)new ModifiedButton(x, y, row, width, height, 0, 0, 0, rocketCondition, type, list, buttonTexture, colorType, width, height, onPress, title));
    }
}

