/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_490;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class TabletButton
extends class_4185 {
    public static final class_2960 TEXTURE = Stellaris.guiTexture("util/buttons/button");
    public static final class_2960 HOVER_TEXTURE = Stellaris.guiTexture("util/buttons/button");
    private class_2960 buttonTexture;
    private class_2960 hoverButtonTexture;
    private int xTexStart;
    private int yTexStart;
    private int yDiffText;
    private int textureWidth;
    private int textureHeight;
    private TabletEntry.Info info;

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, class_4185.class_4241 onPressIn, TabletEntry.Info info) {
        this(xIn, yIn, widthIn, heightIn, (class_2561)class_2561.method_43473(), onPressIn, field_40754, info);
    }

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, class_2561 title, class_4185.class_4241 onPressIn, TabletEntry.Info info) {
        this(xIn, yIn, widthIn, heightIn, title, onPressIn, field_40754, info);
    }

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, class_2561 title, class_4185.class_4241 onPressIn, class_4185.class_7841 onTooltipIn, TabletEntry.Info info) {
        super(xIn, yIn, widthIn, heightIn, title, onPressIn, onTooltipIn);
        this.textureWidth = widthIn;
        this.textureHeight = heightIn;
        this.yDiffText = 0;
        this.xTexStart = 0;
        this.yTexStart = 0;
        this.buttonTexture = TEXTURE;
        this.hoverButtonTexture = HOVER_TEXTURE;
        this.info = info;
        this.setTooltip();
    }

    public void setTooltip() {
        switch (this.info.type()) {
            case "item": {
                this.info.item().ifPresent(item -> this.tooltip(class_7919.method_47407((class_2561)item.stack().method_7954())));
                break;
            }
            case "entity": {
                this.info.entity().ifPresent(entity -> {
                    class_1309 entity1 = ScreenHelper.createEntity((class_1937)class_310.method_1551().field_1687, entity.entity());
                    this.tooltip(class_7919.method_47407((class_2561)entity1.method_5476()));
                });
            }
        }
    }

    public <T extends TabletButton> T tooltip(@Nullable class_7919 tooltip) {
        this.method_47400(tooltip);
        return this.cast();
    }

    private <T extends TabletButton> T cast() {
        return (T)((Object)this);
    }

    public <T extends TabletButton> T tex(class_2960 buttonTexture, class_2960 hovorTexture) {
        this.buttonTexture = buttonTexture;
        this.hoverButtonTexture = hovorTexture;
        return this.cast();
    }

    public <T extends TabletButton> T size(int texWidth, int texHeight) {
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
        return this.cast();
    }

    public <T extends TabletButton> T setUVs(int xTexStart, int yTexStart) {
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        return this.cast();
    }

    public void setYShift(int y) {
        this.yDiffText = y;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.yTexStart;
        if (this.method_25367()) {
            i += this.yDiffText;
        }
        class_2960 texture = this.getTypeTexture(this.field_22762, this.buttonTexture, this.hoverButtonTexture);
        graphics.method_25291(class_1921::method_62277, texture, this.method_46426(), this.method_46427(), (float)this.xTexStart, (float)i, this.field_22758, this.field_22759, this.textureWidth, this.textureHeight, ScreenHelper.getColorFromRGB(this.getTypeColor()));
        switch (this.info.type()) {
            case "item": {
                this.info.item().ifPresent(item -> graphics.method_51428(item.stack(), this.method_46426(), this.method_46427(), this.field_22758));
                break;
            }
            case "entity": {
                this.info.entity().ifPresent(entity -> {
                    class_1309 entity1 = ScreenHelper.createEntity((class_1937)class_310.method_1551().field_1687, entity.entity());
                    class_490.method_48472((class_332)graphics, (float)this.method_46426(), (float)this.method_46427(), (float)7.0f, (Vector3f)new Vector3f(1.5f, 2.5f, 0.0f), (Quaternionf)new Quaternionf(-1.0f, 0.0f, 0.0f, 0.0f), null, (class_1309)entity1);
                });
            }
        }
    }

    private class_2960 getTypeTexture(boolean hover, class_2960 buttonTexture, class_2960 hoverButtonTexture) {
        if (hover) {
            return hoverButtonTexture;
        }
        return buttonTexture;
    }

    protected class_243 getTypeColor() {
        return TexturedButton.ColorTypes.DEFAULT.getColor();
    }
}

