/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.info;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.info.PlanetInfo;
import net.minecraft.class_2960;

public class MoonInfo
extends CelestialBody {
    public final PlanetInfo orbitCenter;
    public final long orbitalPeriod;
    public final double orbitRadius;
    public double currentAngle;
    public static final Codec<MoonInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("texture").forGetter(b -> b.texture), (App)Codec.STRING.fieldOf("name").forGetter(b -> b.name), (App)Codec.DOUBLE.fieldOf("orbitRadius").forGetter(b -> b.orbitRadius), (App)Codec.LONG.fieldOf("orbitalPeriod").forGetter(b -> (long)b.y), (App)Codec.INT.fieldOf("width").forGetter(b -> (int)b.width), (App)Codec.INT.fieldOf("height").forGetter(b -> (int)b.height), (App)PlanetInfo.CODEC.fieldOf("orbitCenter").forGetter(b -> b.orbitCenter), (App)class_2960.field_25139.fieldOf("dimension").forGetter(b -> b.dimension), (App)Codec.STRING.fieldOf("translatable").forGetter(b -> b.translatable), (App)Codec.STRING.fieldOf("id").forGetter(b -> b.id)).apply((Applicative)instance, MoonInfo::new));

    public MoonInfo(class_2960 texture, String name, double orbitRadius, long orbitalPeriod, int width, int height, PlanetInfo orbitCenter, class_2960 dimension, String translatable, String id) {
        super(texture, name, 0.0f, 0.0f, width, height, 0xFFFFFF, dimension, translatable, id);
        this.orbitRadius = orbitRadius;
        this.orbitalPeriod = orbitalPeriod;
        this.orbitCenter = orbitCenter;
        this.currentAngle = 0.0;
        this.translatable = translatable;
        this.id = id;
    }

    public MoonInfo setClickable(boolean clickable) {
        this.clickable = clickable;
        return this;
    }

    public double updateAngle(long currentTime) {
        this.currentAngle = (double)(currentTime % this.orbitalPeriod) * (Math.PI * 2 / (double)this.orbitalPeriod);
        return this.currentAngle;
    }

    public void updatePosition() {
        this.x = (float)((double)this.orbitCenter.x + this.orbitRadius * Math.cos(this.currentAngle));
        this.y = (float)((double)this.orbitCenter.y + this.orbitRadius * Math.sin(this.currentAngle));
    }
}

