/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.tablet;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.components.TabletButton;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntryWidget;
import com.st0x0ef.stellaris.client.screens.tablet.TabletMainScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class TabletEntryScreen
extends class_437 {
    private int leftPos;
    private int topPos;
    private int imageHeight;
    private int imageWidth;
    public static final class_2960 MENU_BACKGROUND_LIGHT = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/tablet_background_light.png");
    public static final class_2960 SMALL_BACK_ARROW = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/small_back_arrow.png");
    public static final class_2960 SMALL_NEXT_ARROW = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/small_next_arrow.png");
    public static final class_2960 SMALL_HOME_BUTTON = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/small_home_button.png");
    public static final class_2960 HOME_BUTTON = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/main_page.png");
    public static final class_2960 HOME_BUTTON_HOVER = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/main_page_hover.png");
    public static final class_2960 BACK_ARROW = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/back_page.png");
    public static final class_2960 BACK_ARROW_HOVER = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/back_page_hovered.png");
    public static final class_2960 NEXT_ARROW = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/next_page.png");
    public static final class_2960 NEXT_ARROW_HOVER = class_2960.method_60655((String)"stellaris", (String)"textures/gui/tablet/next_page_hovered.png");
    private final TabletMainScreen screen;
    public TabletEntry entry;
    private ArrayList<TabletButton> PAGES_BUTTONS = new ArrayList();
    public String currentPage = "main";
    public TexturedButton nextButton;
    public TexturedButton backButton;
    public TabletEntryWidget widget;
    public TexturedButton homeButton;
    public ArrayList<ArrayList<TabletButton>> ENTRY_BUTTONS = new ArrayList();
    public int currentEntryPage = 0;

    protected TabletEntryScreen(class_2561 title, TabletMainScreen screen, int leftPos, int topPos, TabletEntry entry) {
        super(title);
        this.screen = screen;
        this.leftPos = leftPos;
        this.topPos = topPos;
        this.entry = entry;
        this.imageHeight = 162;
        this.imageWidth = 250;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.currentPage.equals("main")) {
            guiGraphics.method_25300(this.field_22793, this.field_22785.getString().toUpperCase(), this.field_22789 / 2, this.topPos + 20, 0xFFFFFF);
            this.showEntryButton();
            this.removeNonShowButtons();
            this.widget.field_22764 = false;
            this.changeButtonVisibility(true);
            if (this.nextButton != null && this.backButton != null) {
                this.backButton.method_48229(this.leftPos + 40, this.field_22790 / 2 - 4);
                this.nextButton.method_48229(this.leftPos + 190, this.field_22790 / 2 - 4);
                this.nextButton.method_55445(16, 16);
                this.backButton.method_55445(16, 16);
                this.homeButton.tex(HOME_BUTTON, HOME_BUTTON_HOVER);
                this.backButton.tex(BACK_ARROW, BACK_ARROW_HOVER);
                this.nextButton.tex(NEXT_ARROW, NEXT_ARROW_HOVER);
                this.homeButton.method_55445(16, 16);
                this.homeButton.tex(HOME_BUTTON, HOME_BUTTON_HOVER);
                this.homeButton.method_48229(this.leftPos + 18, this.topPos + 22);
            }
        } else {
            this.removeAllButtons();
            this.widget.field_22764 = true;
            this.changeButtonVisibility(false);
            if (this.nextButton != null && this.backButton != null) {
                this.backButton.method_48229(this.field_22789 / 2 - 19, this.field_22790 / 2 + 63);
                this.nextButton.method_48229(this.field_22789 / 2 + 11, this.field_22790 / 2 + 63);
                this.nextButton.method_55445(10, 10);
                this.backButton.method_55445(10, 10);
                this.backButton.tex(SMALL_BACK_ARROW, SMALL_BACK_ARROW);
                this.nextButton.tex(SMALL_NEXT_ARROW, SMALL_NEXT_ARROW);
                this.homeButton.tex(SMALL_HOME_BUTTON, SMALL_HOME_BUTTON);
                this.homeButton.method_55445(10, 10);
                this.homeButton.method_48229(this.field_22789 / 2 - 4, this.field_22790 / 2 + 63);
            }
        }
    }

    protected void method_25426() {
        this.homeButton = new TexturedButton(this.leftPos + 18, this.topPos + 22, 16, 16, button1 -> {
            if (Objects.equals(this.currentPage, "main")) {
                this.field_22787.method_1507((class_437)this.screen);
            } else {
                this.currentPage = "main";
                this.widget.field_22764 = false;
            }
        }).tex(HOME_BUTTON, HOME_BUTTON_HOVER);
        this.method_37063((class_364)this.homeButton);
        AtomicInteger row = new AtomicInteger(0);
        AtomicInteger column = new AtomicInteger(0);
        this.entry.infos().forEach(infos -> {
            Object tabletButton = new TabletButton(this.leftPos + 68 + column.get() * 30, this.topPos + 60 + row.get() * 30, 20, 20, (class_2561)class_2561.method_43471((String)infos.id()), button -> this.changeInfo((TabletEntry.Info)infos), (TabletEntry.Info)infos).tex(class_2960.method_60654((String)"stellaris:textures/gui/tablet/button.png"), class_2960.method_60654((String)"stellaris:textures/gui/tablet/button_click.png"));
            if (column.get() == 3) {
                column.set(0);
                row.getAndIncrement();
            } else {
                column.getAndIncrement();
            }
            this.PAGES_BUTTONS.add((TabletButton)((Object)((Object)tabletButton)));
            if (this.PAGES_BUTTONS.size() % 8 == 0) {
                column.set(0);
                row.set(0);
            }
            this.addButtonToList((TabletButton)((Object)((Object)tabletButton)));
            ((TabletButton)((Object)((Object)tabletButton))).field_22764 = false;
            this.method_37063((class_364)tabletButton);
        });
        this.widget = new TabletEntryWidget(this.leftPos + 15, this.topPos + 40, 215, 100, (class_2561)class_2561.method_43470((String)""), null, this);
        this.widget.field_22764 = false;
        this.method_37063((class_364)this.widget);
        if (this.ENTRY_BUTTONS.size() > 1) {
            this.backButton = new TexturedButton(this.leftPos + 40, this.field_22790 / 2 - 4, 16, 16, button1 -> this.changePage(false)).tex(BACK_ARROW, BACK_ARROW_HOVER);
            this.nextButton = new TexturedButton(this.leftPos + 190, this.field_22790 / 2 - 4, 16, 16, button1 -> this.changePage(true)).tex(NEXT_ARROW, NEXT_ARROW_HOVER);
            this.method_37063((class_364)this.backButton);
            this.method_37063((class_364)this.nextButton);
        }
        TabletMainScreen.BUTTONS.forEach(texButton -> {
            this.method_37066((class_364)texButton);
            this.method_37063((class_364)texButton);
        });
    }

    public void changeButtonVisibility(boolean visible) {
        TabletMainScreen.BUTTONS.forEach(texButton -> {
            texButton.field_22764 = visible;
        });
    }

    public void changeInfo(TabletEntry.Info info) {
        class_2960 location = class_2960.method_60655((String)this.entry.id(), (String)info.id());
        if (this.widget.setInfo(location)) {
            this.currentPage = location.toString();
        }
    }

    public void changePage(boolean next) {
        if (!Objects.equals(this.currentPage, "main")) {
            TabletEntry.Info info = this.getNextInfo(next);
            this.changeInfo(info);
            return;
        }
        this.currentEntryPage = next ? (this.currentEntryPage == this.ENTRY_BUTTONS.size() - 1 ? 0 : ++this.currentEntryPage) : (this.currentEntryPage == 0 ? this.ENTRY_BUTTONS.size() - 1 : --this.currentEntryPage);
        this.removeNonShowButtons();
        this.showEntryButton();
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        TabletEntry.Info info;
        this.screen.method_25410(minecraft, width, height);
        this.leftPos = this.screen.getLeftPos();
        this.topPos = this.screen.getTopPos();
        super.method_25410(minecraft, width, height);
        String currentPage = this.currentPage;
        TabletEntryScreen newScreen = new TabletEntryScreen((class_2561)class_2561.method_43471((String)this.entry.id()), this.screen, this.leftPos, this.topPos, this.entry);
        this.field_22787.method_1507((class_437)newScreen);
        if (!currentPage.equals("main") && (info = TabletMainScreen.INFOS.get(class_2960.method_60654((String)currentPage))) != null) {
            newScreen.changeInfo(info);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Objects.equals(this.currentPage, "main")) {
            guiGraphics.method_25290(class_1921::method_62277, TabletMainScreen.BACKGROUND, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        } else {
            guiGraphics.method_25290(class_1921::method_62277, MENU_BACKGROUND_LIGHT, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (Objects.equals(this.currentPage, "main")) {
                this.screen.directEntry = null;
                this.field_22787.method_1507((class_437)this.screen);
            } else {
                this.currentPage = "main";
                this.widget.field_22764 = false;
            }
            return true;
        }
        if (keyCode == 262) {
            this.changePage(true);
            return true;
        }
        if (keyCode == 263) {
            this.changePage(false);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void showEntryButton() {
        this.ENTRY_BUTTONS.get(this.currentEntryPage).forEach(button -> {
            button.field_22764 = true;
        });
    }

    public void removeNonShowButtons() {
        for (int i = 0; i < this.ENTRY_BUTTONS.size(); ++i) {
            if (i == this.currentEntryPage) continue;
            this.ENTRY_BUTTONS.get(i).forEach(button -> {
                button.field_22764 = false;
            });
        }
    }

    public void removeAllButtons() {
        for (ArrayList<TabletButton> entryButton : this.ENTRY_BUTTONS) {
            entryButton.forEach(button -> {
                button.field_22764 = false;
            });
        }
    }

    public void addButtonToList(TabletButton button) {
        if (this.ENTRY_BUTTONS.isEmpty()) {
            ArrayList<TabletButton> list = new ArrayList<TabletButton>();
            list.add(button);
            this.ENTRY_BUTTONS.add(list);
            return;
        }
        for (ArrayList<TabletButton> buttons : this.ENTRY_BUTTONS) {
            if (buttons.size() < 8) {
                buttons.add(button);
                break;
            }
            if (buttons.size() != 8 || this.ENTRY_BUTTONS.indexOf(buttons) + 1 < this.ENTRY_BUTTONS.size()) continue;
            ArrayList<TabletButton> list = new ArrayList<TabletButton>();
            list.add(button);
            this.ENTRY_BUTTONS.add(list);
            break;
        }
    }

    public TabletEntry.Info getNextInfo(boolean forward) {
        List<TabletEntry.Info> infos = this.entry.infos();
        int currentIndex = -1;
        for (int i = 0; i < infos.size(); ++i) {
            if (!infos.get(i).id().equals(this.getCurrentPage(this.currentPage))) continue;
            currentIndex = i;
            break;
        }
        if (currentIndex == -1) {
            if (!infos.isEmpty()) {
                return forward ? infos.getFirst() : infos.getLast();
            }
            return null;
        }
        int nextIndex = forward ? (currentIndex + 1) % infos.size() : (currentIndex - 1 + infos.size()) % infos.size();
        return infos.get(nextIndex);
    }

    public String getCurrentPage(String page) {
        return class_2960.method_60654((String)page).method_12832();
    }
}

