/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.tablet;

import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntryScreen;
import com.st0x0ef.stellaris.client.screens.tablet.TabletMainScreen;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_10415;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_6382;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TabletEntryWidget
extends class_10415 {
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60655((String)"stellaris", (String)"icon/scroller");
    private final AtomicInteger finalHeight = new AtomicInteger(0);
    private TabletEntry.Info info;
    private int baseScreenWidth;
    private final TabletEntryScreen screen;
    private final ArrayList<ClickBox> clickBoxes = new ArrayList();

    public TabletEntryWidget(int x, int y, int width, int height, class_2561 message, TabletEntry.Info info, TabletEntryScreen screen) {
        super(x, y, width, height, message);
        this.info = info;
        this.baseScreenWidth = screen.field_22789;
        this.screen = screen;
    }

    protected int method_44391() {
        return this.finalHeight.get() + this.finalHeight.get() / 2;
    }

    protected double method_44393() {
        return 9.0;
    }

    protected void method_44389(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.info == null) {
            return;
        }
        this.finalHeight.set(0);
        guiGraphics.method_25300(this.getFont(), this.info.title(), this.baseScreenWidth / 2, this.method_46427() + this.finalHeight.get() + 20, Utils.getColorHexCode("white"));
        int descriptionHeight = this.renderDescriptionWithEveryWords(this.info.description(), this.method_46426() + 5, this.method_46427() + this.finalHeight.get() + 20 + 20, this.method_25368() - 20, guiGraphics);
        this.finalHeight.addAndGet(descriptionHeight);
        this.info.item().ifPresent(item -> {
            if (item.onlyIcon().isEmpty()) {
                guiGraphics.method_51428(item.stack(), this.baseScreenWidth / 2 - item.size() / 2, this.method_46427() + this.finalHeight.get() + 35 + 20, item.size());
                this.finalHeight.addAndGet(35 + item.size() / 4);
            }
        });
        this.info.image().ifPresent(image -> {
            int height = this.method_46427() + 40 + this.finalHeight.get() + 20;
            guiGraphics.method_52706(class_1921::method_62277, image.location(), this.baseScreenWidth / 2 - image.width() / 2, height, image.width(), image.height());
            this.finalHeight.addAndGet(image.height() + 40);
        });
        this.info.entity().ifPresent(entity -> {
            int height = this.method_46427() + 40 + this.finalHeight.get() + entity.scale();
            class_1309 entity1 = ScreenHelper.createEntity((class_1937)class_310.method_1551().field_1687, entity.entity());
            class_490.method_48472((class_332)guiGraphics, (float)((float)this.baseScreenWidth / 2.0f), (float)(height + 45), (float)entity.scale(), (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf(-1.0f, 0.0f, 0.0f, 0.0f), null, (class_1309)entity1);
            this.finalHeight.addAndGet(80);
        });
    }

    protected void method_44386(class_332 guiGraphics) {
    }

    public void resize(TabletEntryScreen screen) {
        this.baseScreenWidth = screen.field_22789;
        this.setInfo(class_2960.method_60654((String)screen.currentPage));
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    protected void method_44396(class_332 guiGraphics) {
        if (this.method_44390() == 0) {
            return;
        }
        int i = this.method_44394();
        int j = this.method_46426() + this.field_22758;
        int k = Math.max(this.method_46427(), (int)this.method_44387() * (this.field_22759 - i) / this.method_44390() + this.method_46427());
        guiGraphics.method_52706(class_1921::method_62277, SCROLLER_SPRITE, j, k, 8, i);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (ClickBox clickBox : this.clickBoxes) {
            if (!clickBox.isHovered((int)mouseX, (int)mouseY, (int)this.method_44387())) continue;
            clickBox.changePage(this.screen);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void addClickBox(double x, double y, double width, double height, String brutText) {
        Pattern pattern = Pattern.compile("\\[ref=.*?\\]");
        Matcher matcher = pattern.matcher(brutText);
        while (matcher.find()) {
            String ref = matcher.group().replace("[ref=", "").replace("]", "");
            ClickBox clickBox = new ClickBox((int)x, (int)y, (int)width, (int)height, ref);
            if (this.clickBoxes.contains(clickBox)) continue;
            this.clickBoxes.add(clickBox);
        }
    }

    public String removeRef(String text) {
        String regex = "\\[ref=.*?\\]";
        return text.replaceAll(regex, "");
    }

    public int renderDescriptionWithEveryWords(String description, int x, int y, int maxWidth, class_332 guiGraphics) {
        List<ArrayList<String>> lines = this.createLines(description, maxWidth);
        for (int i = 0; i < lines.size(); ++i) {
            ArrayList<String> words = lines.get(i);
            AtomicInteger width = new AtomicInteger(0);
            for (String word : words) {
                String color = "white";
                if (word.contains("[color=")) {
                    color = word.substring(7, word.indexOf("]"));
                    word = word.replace("[color=" + color + "]", "");
                } else if (word.contains("[ref=")) {
                    double d = x + width.get();
                    Objects.requireNonNull(this.getFont());
                    double d2 = y + i * 9;
                    double d3 = this.getFont().method_1727(this.removeRef(word));
                    Objects.requireNonNull(this.getFont());
                    this.addClickBox(d, d2, d3, 9.0, word);
                    word = this.removeRef(word);
                    color = "blue";
                }
                class_327 class_3272 = this.getFont();
                int n = x + width.get();
                Objects.requireNonNull(this.getFont());
                guiGraphics.method_25303(class_3272, word, n, y + i * 9, Utils.getColorHexCode(color));
                width.addAndGet(class_310.method_1551().field_1772.method_1727(word + " "));
            }
            width.set(0);
        }
        int n = lines.size();
        Objects.requireNonNull(this.getFont());
        return n * 9;
    }

    public List<ArrayList<String>> createLines(String message, int maxWidth) {
        String[] words = message.split("\\s+");
        ArrayList<ArrayList<String>> lines = new ArrayList<ArrayList<String>>();
        ArrayList<String> wordsInLine = new ArrayList<String>();
        AtomicInteger remainingWords = new AtomicInteger(words.length);
        AtomicInteger width = new AtomicInteger(words.length);
        for (String word : words) {
            remainingWords.getAndDecrement();
            int wordWidth = class_310.method_1551().field_1772.method_1727(word + " ");
            if (word.contains("[br]")) {
                lines.add(wordsInLine);
                wordsInLine = new ArrayList();
                width.set(0);
                continue;
            }
            if (word.contains("[color=")) {
                String wordWithoutColor = word.replace("[color=" + word.substring(7, word.indexOf("]")) + "]", "");
                wordWidth = class_310.method_1551().field_1772.method_1727(wordWithoutColor + " ");
            } else if (word.contains("[ref=")) {
                wordWidth = class_310.method_1551().field_1772.method_1727(this.removeRef(word) + " ");
            }
            if (wordWidth + width.get() < maxWidth) {
                if (remainingWords.get() == 0) {
                    wordsInLine.add(word);
                    lines.add(wordsInLine);
                    break;
                }
                wordsInLine.add(word);
                width.addAndGet(wordWidth);
                continue;
            }
            width.set(0);
            lines.add(wordsInLine);
            wordsInLine = new ArrayList();
            wordsInLine.add(word);
        }
        return lines;
    }

    public class_327 getFont() {
        return class_310.method_1551().field_1772;
    }

    public boolean setInfo(class_2960 location) {
        try {
            this.info = TabletMainScreen.INFOS.get(location);
            this.method_44382(0.0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private record ClickBox(int x, int y, int width, int height, String action) {
        public boolean isHovered(int mouseX, int mouseY, int finalHeight) {
            return mouseX >= this.x && mouseX <= this.x + this.width && (mouseY += finalHeight) >= this.y && mouseY <= this.y + this.height;
        }

        public void changePage(TabletEntryScreen entryScreen) {
            class_2960 location = class_2960.method_60654((String)this.action);
            entryScreen.widget.setInfo(location);
        }
    }
}

