/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data_components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.RocketModel;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import com.st0x0ef.stellaris.common.vehicle_upgrade.ModelUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.SkinUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.TankUpgrade;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record RocketComponent(String skin, RocketModel model, String fuelType, int fuel, class_2960 fuelTexture, int tankCapacity) implements Serializable
{
    public static final Codec<RocketComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("skin").forGetter(RocketComponent::skin), (App)RocketModel.CODEC.fieldOf("model").forGetter(RocketComponent::model), (App)Codec.STRING.fieldOf("fuel_type").forGetter(RocketComponent::fuelType), (App)Codec.INT.fieldOf("fuel").forGetter(RocketComponent::fuel), (App)class_2960.field_25139.fieldOf("fuel_texture").forGetter(RocketComponent::fuelTexture), (App)Codec.INT.fieldOf("fuel_capacity").forGetter(RocketComponent::tankCapacity)).apply((Applicative)instance, RocketComponent::new));
    public static final class_9139<ByteBuf, RocketComponent> STREAM_CODEC = class_9139.method_58025((class_9139)class_9135.field_48554, RocketComponent::skin, (class_9139)class_9135.method_56368(RocketModel.CODEC), RocketComponent::model, (class_9139)class_9135.field_48554, RocketComponent::fuelType, (class_9139)class_9135.field_49675, RocketComponent::fuel, (class_9139)class_2960.field_48267, RocketComponent::fuelTexture, (class_9139)class_9135.field_49675, RocketComponent::tankCapacity, RocketComponent::new);

    public int getFuel() {
        return this.fuel;
    }

    @Deprecated
    public class_2960 getFuelTexture() {
        return this.getFuelType().getFuelTexture();
    }

    public class_2960 getSkin() {
        return class_2960.method_60654((String)this.skin);
    }

    public SkinUpgrade getSkinUpgrade() {
        return new SkinUpgrade(this.getSkin());
    }

    public RocketModel getModel() {
        return this.model;
    }

    public ModelUpgrade getModelUpgrade() {
        return new ModelUpgrade(this.model);
    }

    public MotorUpgrade getMotorUpgrade() {
        return new MotorUpgrade(this.getFuelType().getMotorType());
    }

    public FuelType.Type getFuelType() {
        FuelType.Type type = FuelType.Type.fromString(this.fuelType);
        if (type != null) {
            return type;
        }
        class_1792 item = FuelType.getItemBasedOnLoacation(class_2960.method_60654((String)this.fuelType));
        type = FuelType.Type.getTypeBasedOnItem(item);
        if (type != null) {
            return type;
        }
        return FuelType.Type.FUEL;
    }

    public TankUpgrade getTankUpgrade() {
        return new TankUpgrade(this.tankCapacity);
    }

    public int getTankCapacity() {
        return this.tankCapacity;
    }

    public static RocketComponent fromNetwork(class_9129 buffer) {
        return new RocketComponent(buffer.method_19772(), RocketModel.fromString(buffer.method_19772()), buffer.method_19772(), buffer.readInt(), buffer.method_10810(), buffer.readInt());
    }

    public class_9129 toNetwork(class_9129 buffer) {
        buffer.method_10814(this.skin);
        buffer.method_10814(this.model().method_15434());
        buffer.method_10814(this.fuelType);
        buffer.method_53002(this.fuel);
        buffer.method_10812(this.fuelTexture);
        buffer.method_53002(this.tankCapacity);
        return buffer;
    }
}

