/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data_components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import com.st0x0ef.stellaris.common.vehicle_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.SpeedUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.TankUpgrade;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record RoverComponent(String fuelType, int fuel, class_2960 fuelTexture, int tankCapacity, float speedModifier) implements Serializable
{
    public static final Codec<RoverComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("fuel_type").forGetter(RoverComponent::fuelType), (App)Codec.INT.fieldOf("fuel").forGetter(RoverComponent::fuel), (App)class_2960.field_25139.fieldOf("fuel_texture").forGetter(RoverComponent::fuelTexture), (App)Codec.INT.fieldOf("fuel_capacity").forGetter(RoverComponent::tankCapacity), (App)Codec.FLOAT.fieldOf("speed_modifier").forGetter(RoverComponent::speedModifier)).apply((Applicative)instance, RoverComponent::new));
    public static final class_9139<ByteBuf, RoverComponent> STREAM_CODEC = class_9139.method_56906((class_9139)class_9135.field_48554, RoverComponent::fuelType, (class_9139)class_9135.field_49675, RoverComponent::fuel, (class_9139)class_2960.field_48267, RoverComponent::fuelTexture, (class_9139)class_9135.field_49675, RoverComponent::tankCapacity, (class_9139)class_9135.field_48552, RoverComponent::speedModifier, RoverComponent::new);

    public int getFuel() {
        return this.fuel;
    }

    @Deprecated
    public class_2960 getFuelTexture() {
        return this.getFuelType().getFuelTexture();
    }

    public MotorUpgrade getMotorUpgrade() {
        return new MotorUpgrade(this.getFuelType().getMotorType());
    }

    public FuelType.Type getFuelType() {
        FuelType.Type type = FuelType.Type.fromString(this.fuelType);
        if (type != null) {
            return type;
        }
        class_1792 item = FuelType.getItemBasedOnLoacation(class_2960.method_60654((String)this.fuelType));
        type = FuelType.Type.getTypeBasedOnItem(item);
        if (type != null) {
            return type;
        }
        return FuelType.Type.FUEL;
    }

    public TankUpgrade getTankUpgrade() {
        return new TankUpgrade(this.tankCapacity);
    }

    public static RoverComponent fromNetwork(class_9129 buffer) {
        return new RoverComponent(buffer.method_19772(), buffer.readInt(), buffer.method_10810(), buffer.readInt(), buffer.readFloat());
    }

    public class_9129 toNetwork(class_9129 buffer) {
        buffer.method_10814(this.fuelType);
        buffer.method_53002(this.fuel);
        buffer.method_10812(this.fuelTexture);
        buffer.method_53002(this.tankCapacity);
        buffer.method_52941(this.speedModifier);
        return buffer;
    }

    public int getTankCapacity() {
        return this.tankCapacity;
    }

    public SpeedUpgrade getSpeedUpgrade() {
        return new SpeedUpgrade(this.speedModifier);
    }
}

