/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.mobs.cheese_boss;

import com.mojang.serialization.Dynamic;
import com.st0x0ef.stellaris.client.renderers.entities.cheeseboss.CheeseBossRenderState;
import com.st0x0ef.stellaris.common.entities.mobs.cheese_boss.CheeseBossAi;
import com.st0x0ef.stellaris.common.entities.mobs.cheese_boss.attack_entities.CheeseSpit;
import com.st0x0ef.stellaris.common.entities.mobs.cheese_boss.goals.CheeseMeleeAttackGoal;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import dev.architectury.networking.NetworkManager;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_4095;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CheeseBoss
extends class_1588
implements class_1569,
class_1603 {
    private boolean spitting = false;
    private static final class_2561 CHEESE_BOSS_NAME_COMPONENT = class_2561.method_43471((String)"event.stellaris.cheeseboss");
    private final class_3213 bossEvent = (class_3213)new class_3213(CHEESE_BOSS_NAME_COMPONENT, class_1259.class_1260.field_5782, class_1259.class_1261.field_5795).method_5406(true);
    private CheeseBossRenderState renderStateInstance;

    public CheeseBoss(class_1299<? extends CheeseBoss> type, class_1937 level) {
        super(type, level);
    }

    public static class_5132.class_5133 setCustomAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23716, 500.0).method_26868(class_5134.field_23718, 0.8).method_26868(class_5134.field_23722, 1.2).method_26868(class_5134.field_23721, 6.0);
    }

    private void setupAnimationStates(CheeseBossRenderState state) {
        if (state.idleAnimationTimeout <= 0) {
            state.idleAnimationTimeout = 20;
            state.idleAnimationState.method_41322(this.field_6012);
        } else {
            --state.idleAnimationTimeout;
        }
        if (state.punchingAnimationTimeout <= 0 && this.isPunching()) {
            state.punchingAnimationTimeout = 20;
            this.setPunching(false);
            state.punchAnimationState.method_41322(this.field_6012);
        } else {
            --state.punchingAnimationTimeout;
        }
        if (state.spittingAnimationTimeout <= 0 && this.isSpitting()) {
            state.spittingAnimationTimeout = 30;
            this.setSpitting(false);
            state.spitAnimationState.method_41322(this.field_6012);
        } else {
            --state.spittingAnimationTimeout;
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates(this.getRenderStateInstance());
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, class_1657.class, 35.0f));
        this.field_6201.method_6277(2, (class_1352)new CheeseMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(2, (class_1352)new class_1381((class_1603)this, 1.25, 100, 30.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(6, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
    }

    protected void method_5958(class_3218 serverLevel) {
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14089(serverPlayer);
    }

    public void setPunching(boolean punching) {
        this.getRenderStateInstance().punching = punching;
    }

    public boolean isPunching() {
        return this.getRenderStateInstance().punching;
    }

    public void method_7105(class_1309 target, float velocity) {
    }

    public void setSpitting(boolean spitting) {
        this.spitting = spitting;
    }

    public boolean isSpitting() {
        return this.spitting;
    }

    private void spit(class_1309 target) {
        CheeseSpit cheeseSpit = CheeseSpit.fromLevelAndEntity(this.method_37908(), this);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333) - cheeseSpit.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = Math.sqrt(d * d + f * f) * (double)0.2f;
        cheeseSpit.method_7485(d, e + g, f, 1.5f, 10.0f);
        if (!this.method_5701()) {
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14789, this.method_5634(), 1.0f, 1.0f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f);
        }
        this.method_37908().method_8649((class_1297)cheeseSpit);
    }

    public class_2596<class_2602> method_18002(class_3231 entity) {
        return NetworkManager.createAddEntityPacket((class_1297)this, (class_3231)entity);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return CheeseBossAi.makeBrain(this, dynamic);
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return false;
        }
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_37908() != entity.method_37908()) {
            return false;
        }
        if (!class_1301.field_6156.test(entity)) {
            return false;
        }
        if (this.method_5722(entity)) {
            return false;
        }
        if (livingEntity.method_5864() == class_1299.field_6131) {
            return false;
        }
        if (livingEntity.method_5864() == EntityRegistry.CHEESE_BOSS.get()) {
            return false;
        }
        if (livingEntity.method_5655()) {
            return false;
        }
        if (livingEntity.method_29504()) {
            return false;
        }
        return this.method_37908().method_8621().method_11966(livingEntity.method_5829());
    }

    public CheeseBossRenderState getRenderStateInstance() {
        if (!this.method_37908().method_8608()) {
            return null;
        }
        if (this.renderStateInstance == null) {
            this.renderStateInstance = new CheeseBossRenderState();
        }
        return this.renderStateInstance;
    }
}

