/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.st0x0ef.stellaris.common.oxygen.OxygenRoom;
import com.st0x0ef.stellaris.common.oxygen.OxygenSavedData;
import com.st0x0ef.stellaris.common.registry.TagRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class DimensionOxygenManager {
    private final Set<OxygenRoom> oxygenRooms = new HashSet<OxygenRoom>();
    private final Map<class_2338, OxygenRoom> roomToCheckIfOpen = new HashMap<class_2338, OxygenRoom>();
    private final boolean planetHasOxygen;
    private final class_3218 level;
    private int tickCount;

    public DimensionOxygenManager(class_3218 level) {
        this.level = level;
        this.planetHasOxygen = PlanetUtil.hasOxygen((class_1937)level);
    }

    public void addOxygenRoom(class_2338 pos) {
        this.oxygenRooms.add(new OxygenRoom(this.level, pos));
        this.setChanged();
    }

    public void removeOxygenRoom(class_2338 pos) {
        this.oxygenRooms.removeIf(room -> room.getDistributorPosition().equals((Object)pos));
        this.setChanged();
    }

    public void addRoomToCheckIfOpen(class_2338 pos, OxygenRoom room) {
        if (this.roomToCheckIfOpen.remove(pos) == null) {
            this.roomToCheckIfOpen.put(pos, room);
        }
    }

    public void removeRoomToCheckIfOpen(class_2338 pos) {
        this.roomToCheckIfOpen.remove(pos);
    }

    private void setChanged() {
        OxygenSavedData data = OxygenSavedData.getData(this.level);
        data.method_80();
    }

    public void updateOxygenTick() {
        if (this.planetHasOxygen || this.tickCount < 20) {
            ++this.tickCount;
            return;
        }
        this.oxygenRooms.forEach(OxygenRoom::tick);
        this.roomToCheckIfOpen.values().forEach(OxygenRoom::removeOxygenInRoom);
        this.roomToCheckIfOpen.clear();
        this.tickCount = 0;
        this.setChanged();
    }

    public boolean breath(class_1309 entity) {
        UniversalFluidStorage storage;
        class_1657 player;
        if (this.planetHasOxygen || entity.method_5864().method_20210(TagRegistry.ENTITY_NO_OXYGEN_NEEDED_TAG)) {
            return true;
        }
        if (entity instanceof class_1657 && ((player = (class_1657)entity).method_68878() || player.method_7325())) {
            return true;
        }
        if (this.breathOxygenAt(entity.method_23312().method_10084())) {
            return true;
        }
        if ((Utils.isLivingInJetSuit(entity) || Utils.isLivingInSpaceSuit(entity)) && (storage = (UniversalFluidStorage)Capabilities.Fluid.ITEM.getCapability(entity.method_6118(class_1304.field_6174))) != null && !storage.getFluidInTank(0).isEmpty()) {
            storage.drain(storage.getFluidInTank(0).copyWithAmount(1L), false);
            return true;
        }
        return false;
    }

    public boolean breathOxygenAt(class_2338 pos) {
        return this.oxygenRooms.stream().anyMatch(room -> room.breathOxygenAt(pos));
    }

    public boolean hasOxygenAt(class_2338 pos) {
        return this.oxygenRooms.stream().anyMatch(room -> room.hasOxygenAt(pos));
    }

    public Set<OxygenRoom> getOxygenRooms() {
        return this.oxygenRooms;
    }

    public OxygenRoom getOxygenRoom(class_2338 distributorPos) {
        return this.oxygenRooms.stream().filter(room -> room.getDistributorPosition().equals((Object)distributorPos)).findFirst().orElse(null);
    }

    public void setOxygenRooms(Set<OxygenRoom> rooms) {
        this.oxygenRooms.clear();
        this.oxygenRooms.addAll(rooms);
    }

    public class_3218 getLevel() {
        return this.level;
    }
}

