/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.oxygen;

import com.st0x0ef.stellaris.common.blocks.entities.machines.OxygenDistributorBlockEntity;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class OxygenRoom {
    private final class_2338 distributorPos;
    public final Set<class_2338> oxygenatedPositions;
    private final class_3218 level;
    private boolean isClosed;
    private static final int HALF_ROOM_SIZE = 16;

    public OxygenRoom(class_3218 level, class_2338 distributorPos) {
        this.distributorPos = distributorPos;
        this.oxygenatedPositions = new HashSet<class_2338>();
        this.level = level;
        this.isClosed = false;
    }

    public OxygenRoom(class_3218 level, class_2338 distributorPos, Set<class_2338> oxygenatedPositions) {
        this.distributorPos = distributorPos;
        this.oxygenatedPositions = oxygenatedPositions;
        this.level = level;
        this.isClosed = false;
    }

    public class_2338 getDistributorPosition() {
        return this.distributorPos;
    }

    public OxygenDistributorBlockEntity getDistributorBlockEntity() {
        OxygenDistributorBlockEntity distributor;
        class_2586 class_25862 = this.level.method_8321(this.distributorPos);
        return class_25862 instanceof OxygenDistributorBlockEntity ? (distributor = (OxygenDistributorBlockEntity)class_25862) : null;
    }

    public void tick() {
        OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
        if (distributor == null) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 rel = this.distributorPos.method_10093(direction);
            if (this.oxygenatedPositions.contains(rel) || !this.level.method_8320(rel).method_26215() || !distributor.useOxygenAndEnergy()) continue;
            this.oxygenatedPositions.add(rel);
            GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).removeRoomToCheckIfOpen(rel);
        }
        ArrayList<class_2338> oxygenatedPositionsCopy = new ArrayList<class_2338>(this.oxygenatedPositions);
        for (class_2338 pos : oxygenatedPositionsCopy) {
            for (class_2350 direction : class_2350.values()) {
                class_2338 rel = pos.method_10093(direction);
                if (Math.abs(rel.method_10263() - this.distributorPos.method_10263()) > 16 || Math.abs(rel.method_10264() - this.distributorPos.method_10264()) > 16 || Math.abs(rel.method_10260() - this.distributorPos.method_10260()) > 16) {
                    GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).addRoomToCheckIfOpen(rel, this);
                    continue;
                }
                if (this.oxygenatedPositions.contains(rel) || !this.level.method_8320(rel).method_26215() || !distributor.useOxygenAndEnergy()) continue;
                this.oxygenatedPositions.add(rel);
                GlobalOxygenManager.getInstance().getOrCreateDimensionManager(this.level).removeRoomToCheckIfOpen(rel);
            }
        }
        this.isClosed = this.oxygenatedPositions.size() == oxygenatedPositionsCopy.size();
    }

    public void removeOxygenInRoom() {
        if (!this.isClosed) {
            this.oxygenatedPositions.clear();
        }
    }

    public boolean hasOxygenAt(class_2338 pos) {
        return this.oxygenatedPositions.contains(pos);
    }

    public boolean breathOxygenAt(class_2338 pos) {
        if (this.hasOxygenAt(pos) && this.isClosed) {
            OxygenDistributorBlockEntity distributor = this.getDistributorBlockEntity();
            if (this.getDistributorBlockEntity() == null || !distributor.useOxygenAndEnergy()) {
                this.oxygenatedPositions.remove(pos);
            }
            return true;
        }
        return false;
    }
}

