/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.menus.MilkyWayMenu;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.menus.TabletMenu;
import com.st0x0ef.stellaris.common.menus.WaitMenu;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PlanetUtil {
    public static final class_2960 TEXTURE = Stellaris.texture("planet_bar/earth_planet_bar");

    public static Planet getPlanet(class_2960 level) {
        Planet[] result = new Planet[]{null};
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.dimension().equals((Object)level)) {
                result[0] = planet;
            }
        });
        return result[0];
    }

    public static boolean isPlanet(class_2960 level) {
        boolean[] isPlanet = new boolean[]{false};
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.dimension().equals((Object)level)) {
                isPlanet[0] = true;
            }
        });
        return isPlanet[0];
    }

    public static void ifPlanet(class_2960 level, Consumer<Planet> planetRunnable) {
        if (PlanetUtil.isPlanet(level)) {
            planetRunnable.accept(PlanetUtil.getPlanet(level));
        }
    }

    public static boolean hasOxygen(class_1937 level) {
        return !PlanetUtil.isPlanet(level.method_27983().method_29177()) || PlanetUtil.getPlanet(level.method_27983().method_29177()).oxygen();
    }

    public static boolean hasOxygenAt(class_3218 level, @NotNull class_2338 pos) {
        if (!PlanetUtil.hasOxygen((class_1937)level)) {
            return GlobalOxygenManager.getInstance().getOrCreateDimensionManager(level).hasOxygenAt(pos);
        }
        return true;
    }

    public static class_2960 getPlanetBar(class_2960 level) {
        if (PlanetUtil.isPlanet(level)) {
            return PlanetUtil.getPlanet(level).textures().planet_bar();
        }
        return TEXTURE;
    }

    public static int openPlanetSelectionMenu(class_1657 player, final boolean forceCanGoTo) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buffer) {
                buffer.method_52964(forceCanGoTo);
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Planets");
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                return PlanetSelectionMenu.create(syncId, inv, buffer.method_52964(forceCanGoTo));
            }
        };
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openWaitMenu(class_1657 player, final String playerChoosing) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buffer) {
                buffer.method_10814(playerChoosing);
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Waiting");
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                return WaitMenu.create(syncId, inv, buffer.method_10814(playerChoosing));
            }
        };
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openTabletMenu(class_1657 player, final class_2960 entry) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buffer) {
                buffer.method_10812(entry);
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Tablet");
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                buffer.method_10812(entry);
                return TabletMenu.create(syncId, inv, buffer);
            }
        };
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openMilkyWayMenu(class_1657 player) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(class_2540 buf) {
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"MilkyWay");
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_2540 buffer = new class_2540(Unpooled.buffer());
                return MilkyWayMenu.create(syncId, inv, buffer);
            }
        };
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }
}

