/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data_components.SpaceSuitModules;
import com.st0x0ef.stellaris.common.entities.vehicles.LanderEntity;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.StatsRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.TeleportUtil;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import dev.architectury.utils.GameInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static void transfertInventory(RocketEntity rocket, LanderEntity lander) {
        class_1263 rocketContainer = rocket.getInventory();
        class_1263 landerContainer = lander.getInventory();
        for (int i = 2; i < lander.getInventory().method_5439() - 1; ++i) {
            landerContainer.method_5447(i, rocketContainer.method_5438(i));
        }
        class_1799 rocketStack = new class_1799((class_1935)ItemsRegistry.ROCKET.get());
        rocketStack.method_57379((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get(), (Object)rocket.getRocketComponent());
        landerContainer.method_5447(14, rocketStack);
    }

    public static LanderEntity createLanderFromRocket(class_1297 player, RocketEntity rocket, int yPos, class_1937 destination) {
        LanderEntity lander = new LanderEntity(destination);
        lander.method_5814(player.method_23317(), yPos, player.method_23321());
        Utils.transfertInventory(rocket, lander);
        rocket.method_31472();
        return lander;
    }

    public static void teleportEntity(class_1297 entity, Planet destination) {
        if (entity.method_37908().method_8608()) {
            return;
        }
        entity.method_5875(false);
        TeleportUtil.teleportToPlanet(entity, Utils.getPlanetLevel(destination), 600);
    }

    public static void changeDimension(class_1657 player, Planet destination) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_1297 class_12972 = serverPlayer.method_5854();
            if (class_12972 instanceof RocketEntity) {
                RocketEntity rocket = (RocketEntity)class_12972;
                serverPlayer.method_5848();
                serverPlayer.method_7346();
                if (!serverPlayer.method_68878() && !serverPlayer.method_7325()) {
                    int fuelConsumption = Math.round(FuelType.getFuelNeededToGoOnPlanet(PlanetUtil.getPlanet(serverPlayer.method_37908().method_27983().method_29177()), destination, rocket.FUEL_TYPE));
                    rocket.FUEL -= fuelConsumption;
                    rocket.syncRocketData(serverPlayer);
                }
                LanderEntity lander = Utils.createLanderFromRocket((class_1297)serverPlayer, rocket, 600, (class_1937)Utils.getPlanetLevel(destination));
                Utils.teleportEntity((class_1297)serverPlayer, destination);
                player.method_7339((class_2960)StatsRegistry.SPACE_TRAVEL.get(), Utils.distanceToPlanet(PlanetUtil.getPlanet(player.method_37908().method_27983().method_29177()), destination));
                serverPlayer.method_37908().method_8649((class_1297)lander);
                while (!serverPlayer.method_5873((class_1297)lander, true)) {
                }
                serverPlayer.method_64398((class_2561)class_2561.method_43471((String)"message.stellaris.lander"));
            } else {
                serverPlayer.method_7346();
                Utils.teleportEntity((class_1297)serverPlayer, destination);
            }
        }
    }

    public static void changeDimensionForPlayers(List<class_1297> entities, Planet destination) {
        RocketEntity rocket = (RocketEntity)entities.getFirst().method_5854();
        for (class_1297 entity : entities) {
            if (entity.method_37908().method_8608()) {
                return;
            }
            class_1297 vehicle = entity.method_5854();
            if (!(vehicle instanceof RocketEntity)) continue;
            RocketEntity playerRocket = (RocketEntity)vehicle;
            entity.method_5848();
            rocket = playerRocket;
            Utils.teleportEntity(entity, destination);
            if (!(entity instanceof class_1657)) continue;
            class_1657 player = (class_1657)entity;
            player.method_7339((class_2960)StatsRegistry.SPACE_TRAVEL.get(), Utils.distanceToPlanet(PlanetUtil.getPlanet(player.method_37908().method_27983().method_29177()), destination));
            player.method_7346();
            player.stellaris$setPlanetMenuOpen(false, player, true);
        }
        LanderEntity lander = Utils.createLanderFromRocket(entities.getFirst(), rocket, 600, (class_1937)Utils.getPlanetLevel(destination));
        entities.getFirst().method_37908().method_8649((class_1297)lander);
        for (class_1297 entity : entities) {
            entity.method_5873((class_1297)lander, true);
            if (!(entity instanceof class_1657)) continue;
            class_1657 player = (class_1657)entity;
            player.method_7353((class_2561)class_2561.method_43471((String)"message.stellaris.lander"), true);
        }
    }

    public static int distanceToPlanet(Planet actual, Planet destination) {
        return class_3532.method_15382((int)(actual.distanceFromEarth() - destination.distanceFromEarth()));
    }

    public static double changeLastDigitToEven(double number) {
        Object numberStr = Double.toString(number);
        int decimalIndex = ((String)numberStr).indexOf(46);
        if (decimalIndex != -1) {
            String beforeDecimal = ((String)numberStr).substring(0, decimalIndex + 1);
            Object afterDecimal = ((String)numberStr).substring(decimalIndex + 1);
            char lastChar = ((String)afterDecimal).charAt(((String)afterDecimal).length() - 1);
            if ((lastChar - 48) % 2 != 0) {
                afterDecimal = ((String)afterDecimal).substring(0, ((String)afterDecimal).length() - 1) + "2";
            }
            numberStr = beforeDecimal + (String)afterDecimal;
        }
        return Double.parseDouble((String)numberStr);
    }

    public static int getColorHexCode(String colorName) {
        if (colorName.startsWith("#")) {
            try {
                return Integer.parseInt(colorName.substring(1), 16);
            }
            catch (NumberFormatException e) {
                return 0xFFFFFF;
            }
        }
        return switch (colorName.toLowerCase()) {
            case "black" -> -16777216;
            case "red" -> -65536;
            case "green" -> -16744448;
            case "blue" -> -16776961;
            case "yellow" -> -256;
            case "cyan" -> -16711681;
            case "magenta" -> -65281;
            case "gray" -> -8355712;
            case "maroon" -> -8388608;
            case "olive" -> -8355840;
            case "purple" -> -8388480;
            case "teal" -> -16744320;
            case "navy" -> -16777088;
            case "orange" -> -23296;
            case "brown" -> -5952982;
            case "lime" -> -16711936;
            case "pink" -> -16181;
            case "coral" -> -32944;
            case "gold" -> -10496;
            case "silver" -> -4144960;
            case "beige" -> -657956;
            case "lavender" -> -1644806;
            case "turquoise" -> -12525360;
            case "salmon" -> -360334;
            case "khaki" -> -989556;
            case "darkred" -> -7667712;
            case "dark_red" -> -7667712;
            case "rainbow" -> Utils.generateRandomHexColor();
            default -> -1;
        };
    }

    public static int generateRandomHexColor() {
        Random random = new Random();
        return random.nextInt(0x1000000);
    }

    public static String betterIntToString(int i) {
        if (i == 0) {
            return "0";
        }
        return i % 1000 + "K";
    }

    public static class_2561 getMessageComponent(String text, String color) {
        return class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)Utils.getColorHexCode(color))));
    }

    public static class_2561 getMessageComponent(String text, int color) {
        return class_2561.method_43470((String)text).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)color)));
    }

    public static class_2561 getMessageComponent(String text) {
        return class_2561.method_43470((String)text).method_10862(class_2583.field_24360);
    }

    public static int getPlayerCountInDimension(MinecraftServer server, class_2960 dimensionKey) {
        class_3218 dimension = server.method_3847(Utils.getPlanetLevel(dimensionKey));
        if (dimension == null) {
            return 0;
        }
        return dimension.method_18456().size();
    }

    public static <T extends Enum<T>> Codec<T> EnumCodec(Class<T> e) {
        Function<String, Enum> stringToEnum = s -> Enum.valueOf(e, s.toUpperCase(Locale.ROOT));
        Function<Enum, String> enumToString = Enum::name;
        return Codec.STRING.xmap(stringToEnum, enumToString);
    }

    public static float MCGToMPS2(float MCG) {
        return 122.58312f * MCG;
    }

    public static double MPS2ToMCG(float MPS2) {
        if (MPS2 > 0.0f) {
            return Math.floor(0.00816 * (double)MPS2 * 100000.0) / 100000.0;
        }
        if (MPS2 < 0.0f) {
            return Math.ceil(0.00816 * (double)MPS2 * 100000.0) / 100000.0;
        }
        return 0.0;
    }

    public static void disableFlyAntiCheat(class_1657 player, boolean condition) {
        if (player instanceof class_3222 && condition) {
            ((class_3222)player).field_13987.field_14138 = 0;
        }
    }

    public static boolean isLivingInJetSuit(class_1309 entity) {
        return Utils.isLivingInArmor(entity, class_1304.field_6166, (class_1792)ItemsRegistry.JETSUIT_BOOTS.get()) && Utils.isLivingInArmor(entity, class_1304.field_6169, (class_1792)ItemsRegistry.JETSUIT_HELMET.get()) && Utils.isLivingInArmor(entity, class_1304.field_6174, (class_1792)ItemsRegistry.JETSUIT_SUIT.get()) && Utils.isLivingInArmor(entity, class_1304.field_6172, (class_1792)ItemsRegistry.JETSUIT_LEGGINGS.get());
    }

    public static boolean isJetSuitPart(class_1799 stack) {
        return stack.method_31574((class_1792)ItemsRegistry.JETSUIT_BOOTS.get()) || stack.method_31574((class_1792)ItemsRegistry.JETSUIT_HELMET.get()) || stack.method_31574((class_1792)ItemsRegistry.JETSUIT_SUIT.get()) || stack.method_31574((class_1792)ItemsRegistry.JETSUIT_LEGGINGS.get());
    }

    public static boolean isLivingInSpaceSuit(class_1309 entity) {
        return Utils.isLivingInArmor(entity, class_1304.field_6166, (class_1792)ItemsRegistry.SPACESUIT_BOOTS.get()) && Utils.isLivingInArmor(entity, class_1304.field_6172, (class_1792)ItemsRegistry.SPACESUIT_LEGGINGS.get()) && Utils.isLivingInArmor(entity, class_1304.field_6174, (class_1792)ItemsRegistry.SPACESUIT_SUIT.get()) && Utils.isLivingInArmor(entity, class_1304.field_6169, (class_1792)ItemsRegistry.SPACESUIT_HELMET.get());
    }

    public static boolean isSpaceSuitPart(class_1799 stack) {
        return stack.method_31574((class_1792)ItemsRegistry.SPACESUIT_BOOTS.get()) || stack.method_31574((class_1792)ItemsRegistry.SPACESUIT_HELMET.get()) || stack.method_31574((class_1792)ItemsRegistry.SPACESUIT_SUIT.get()) || stack.method_31574((class_1792)ItemsRegistry.SPACESUIT_LEGGINGS.get());
    }

    public static boolean isLivingInArmor(class_1309 entity, class_1304 slot, class_1792 item) {
        return entity.method_6118(slot).method_7909() == item;
    }

    public static class_5321<class_1937> getPlanetLevel(class_2960 planet) {
        return class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)planet), (class_2960)planet);
    }

    public static class_3218 getPlanetLevel(Planet planet) {
        for (class_3218 level : GameInstance.getServer().method_3738()) {
            if (!level.method_27983().method_29177().equals((Object)planet.dimension())) continue;
            return level;
        }
        return null;
    }

    public static boolean entityHasBlockAbove(class_1309 entity, @Nullable class_2338 pos, @Nullable Integer recusion) {
        return entity.method_37908().method_8311(entity.method_24515());
    }

    public <T> void addButtonToList(ArrayList<ArrayList<T>> finalList, T button, int size) {
        if (finalList.isEmpty()) {
            ArrayList<T> list = new ArrayList<T>();
            list.add(button);
            finalList.add(list);
            return;
        }
        for (ArrayList<T> buttons : finalList) {
            if (buttons.size() < size) {
                buttons.add(button);
                break;
            }
            if (buttons.size() != size || finalList.indexOf(buttons) + 1 < finalList.size()) continue;
            ArrayList<T> list = new ArrayList<T>();
            list.add(button);
            finalList.add(list);
            break;
        }
    }

    public static void handleGravityChange(@NotNull class_1309 entity) {
        if (!SpaceSuitModules.containsInModules(entity.method_6118(class_1304.field_6174), ((class_1792)ItemsRegistry.MODULE_GRAVITY_NORMALIZER.get()).method_7854())) {
            class_2960 dimension = entity.method_37908().method_27983().method_29177();
            if (!PlanetUtil.isPlanet(dimension) || dimension.equals((Object)class_1937.field_25179.method_29177())) {
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49078, ((class_1320)class_5134.field_49078.comp_349()).method_6169());
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49079, ((class_1320)class_5134.field_49079.comp_349()).method_6169());
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49077, ((class_1320)class_5134.field_49077.comp_349()).method_6169());
            } else if (PlanetUtil.isPlanet(dimension)) {
                float stellaris$regularGravity = PlanetUtil.getPlanet(dimension).gravity();
                double stellaris$gravity = Utils.MPS2ToMCG(stellaris$regularGravity);
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49078, ((class_1320)class_5134.field_49078.comp_349()).method_6165(stellaris$gravity));
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49079, ((class_1320)class_5134.field_49079.comp_349()).method_6165(3.0 / ((double)stellaris$regularGravity / 9.80665)));
                Utils.trySetAttribute(entity, (class_6880<class_1320>)class_5134.field_49077, ((class_1320)class_5134.field_49077.comp_349()).method_6165((double)stellaris$regularGravity / 9.80665));
            }
        }
    }

    public static void trySetAttribute(class_1309 entity, class_6880<class_1320> attribute, double value) {
        class_1324 attributeInstance = entity.method_5996(attribute);
        if (attributeInstance != null) {
            attributeInstance.method_6192(value);
        }
    }
}

