/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.fluid.FluidStack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2371;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class FluidAmountMapDataComponent
implements Serializable {
    public static final Codec<FluidAmountMapDataComponent> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)class_7923.field_41173.method_40294().listOf().fieldOf("fluids").forGetter(component -> component.fluids.stream().map(arg_0 -> ((class_7922)class_7923.field_41173).method_47983(arg_0)).toList()), (App)Codec.LONG.listOf().fieldOf("amounts").forGetter(component -> component.amounts)).apply((Applicative)instance, FluidAmountMapDataComponent::create));
    public static final class_9139<class_9129, FluidAmountMapDataComponent> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56383((class_5321)class_7924.field_41270).method_56433(class_9135.method_56363()), component -> component.fluids.stream().map(arg_0 -> ((class_7922)class_7923.field_41173).method_47983(arg_0)).toList(), (class_9139)class_9135.field_48551.method_56433(class_9135.method_56363()), component -> component.amounts, FluidAmountMapDataComponent::create);
    protected final List<class_3611> fluids;
    protected final List<Long> amounts;

    public FluidAmountMapDataComponent(Map<class_3611, Long> fluidAmounts) {
        if (fluidAmounts.isEmpty()) {
            throw new IllegalArgumentException("Map<Fluid, Long> Cannot be empty");
        }
        this.fluids = new ArrayList<class_3611>(fluidAmounts.keySet());
        this.amounts = new ArrayList<Long>(fluidAmounts.values());
    }

    public FluidAmountMapDataComponent(List<class_3611> fluids, List<Long> amounts) {
        if (fluids.isEmpty()) {
            throw new IllegalArgumentException("List<Fluid> Cannot be empty");
        }
        if (amounts.isEmpty()) {
            throw new IllegalArgumentException("List<Long> Cannot be empty");
        }
        if (fluids.size() != amounts.size()) {
            throw new IllegalArgumentException("List<Fluid> must be the same length as List<Long>");
        }
        this.fluids = Arrays.asList(fluids.toArray(new class_3611[0]));
        this.amounts = Arrays.asList(amounts.toArray(new Long[0]));
    }

    public static FluidAmountMapDataComponent create(List<class_6880<class_3611>> holders, List<Long> amounts) {
        if (holders.isEmpty()) {
            throw new IllegalArgumentException("List<Holder<Fluid>> Cannot be empty");
        }
        if (amounts.isEmpty()) {
            throw new IllegalArgumentException("List<Long> Cannot be empty");
        }
        if (holders.size() != amounts.size()) {
            throw new IllegalArgumentException("List<Holder<Fluid>> must be the same length as List<Long>");
        }
        return new FluidAmountMapDataComponent(holders.stream().map(class_6880::comp_349).toList(), amounts);
    }

    public static FluidAmountMapDataComponent create(List<FluidStack> fluidStacks) {
        if (fluidStacks.isEmpty()) {
            throw new IllegalArgumentException("List<FluidStack> Cannot be empty");
        }
        return new FluidAmountMapDataComponent(fluidStacks.stream().collect(Collectors.toMap(FluidStack::getFluid, FluidStack::getAmount)));
    }

    public static FluidAmountMapDataComponent emptyWithSize(int size) {
        class_2371 fluids = class_2371.method_10213((int)size, (Object)class_3612.field_15906);
        class_2371 amounts = class_2371.method_10213((int)size, (Object)0L);
        return new FluidAmountMapDataComponent((List<class_3611>)fluids, (List<Long>)amounts);
    }

    public List<FluidStack> asFluidStackList() {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>(this.fluids.size());
        for (int i = 0; i < this.fluids.size(); ++i) {
            stacks.add(this.getAsFluidStack(i));
        }
        stacks.trimToSize();
        return Collections.unmodifiableList(stacks);
    }

    public class_3611 getFluid(int i) {
        return this.fluids.get(i);
    }

    public long getAmount(int i) {
        return this.amounts.get(i);
    }

    public FluidStack getAsFluidStack(int i) {
        return FluidStack.create((class_3611)this.getFluid(i), (long)this.getAmount(i));
    }

    public void setFluid(int i, class_3611 fluid) {
        this.fluids.set(i, fluid);
    }

    public void setAmount(int i, Long amount) {
        this.amounts.set(i, amount);
    }

    public void setFluidStack(int i, FluidStack stack) {
        this.setFluid(i, stack.getFluid());
        this.setAmount(i, stack.getAmount());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FluidAmountMapDataComponent) {
            FluidAmountMapDataComponent component = (FluidAmountMapDataComponent)obj;
            return component.fluids.equals(this.fluids) && component.amounts.equals(this.amounts);
        }
        return super.equals(obj);
    }

    private static <T> List<T> getListFromStream(Stream<T> s) {
        ArrayList list = new ArrayList(0);
        s.forEach(list::add);
        list.trimToSize();
        return list;
    }

    public FluidAmountMapDataComponent copy() {
        return new FluidAmountMapDataComponent(new ArrayList<class_3611>(this.fluids), new ArrayList<Long>(this.amounts));
    }
}

