/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.energy;

import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public class ItemEnergyStorage
implements UniversalEnergyStorage {
    protected final class_1799 stack;
    protected final int capacity;
    protected final int maxReceive;
    protected final int maxExtract;
    protected final class_9331<Integer> component;

    public ItemEnergyStorage(class_1799 stack, class_9331<Integer> component, int capacity, int maxReceive, int maxExtract) {
        this.stack = stack;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.component = component;
        if (!this.stack.method_57826(component)) {
            stack.method_57379(component, (Object)0);
        }
    }

    public ItemEnergyStorage(class_1799 stack, class_9331<Integer> component, int capacity) {
        this(stack, component, capacity, capacity, capacity);
    }

    @Override
    public int getEnergy() {
        return (Integer)this.stack.method_58695(this.component, (Object)0);
    }

    @Override
    public int getMaxEnergy() {
        return this.capacity;
    }

    public void setEnergyStored(int amount) {
        this.stack.method_57379(this.component, (Object)Math.clamp((long)amount, 0, this.getMaxEnergy()));
    }

    @Override
    public boolean canInsertEnergy() {
        return this.maxReceive > 0;
    }

    @Override
    public boolean canExtractEnergy() {
        return this.maxExtract > 0;
    }

    @Override
    public int insert(int amount, boolean simulate) {
        if (!this.canInsertEnergy()) {
            return 0;
        }
        int toReceive = Math.clamp((long)(this.capacity - this.getEnergy()), 0, Math.min(this.maxReceive, amount));
        if (!simulate) {
            this.setEnergyStored(this.getEnergy() + toReceive);
            this.setChanged();
        }
        return toReceive;
    }

    @Override
    public int extract(int amount, boolean simulate) {
        if (!this.canExtractEnergy()) {
            return 0;
        }
        int toExtract = Math.min(this.getEnergy(), Math.min(this.maxExtract, amount));
        if (!simulate) {
            this.setEnergyStored(this.getEnergy() - toExtract);
            this.setChanged();
        }
        return toExtract;
    }

    public void setChanged() {
        this.stack.method_57368(this.component, (Object)0, i -> this.getEnergy());
    }
}

