/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils.capabilities.energy;

import com.fej1fun.potentials.capabilities.Capabilities;
import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EnergyUtil {
    public static int moveEnergyToItem(UniversalEnergyStorage from, ItemStack stackTo, int amount) {
        if (stackTo.isEmpty()) {
            return 0;
        }
        UniversalEnergyStorage to = (UniversalEnergyStorage)Capabilities.Energy.ITEM.getCapability(stackTo);
        if (to == null) {
            return 0;
        }
        return EnergyUtil.moveEnergy(from, to, amount);
    }

    public static int moveEnergyFromItem(UniversalEnergyStorage to, ItemStack stackFrom, int amount) {
        if (stackFrom.isEmpty()) {
            return 0;
        }
        UniversalEnergyStorage from = (UniversalEnergyStorage)Capabilities.Energy.ITEM.getCapability(stackFrom);
        if (from == null) {
            return 0;
        }
        return EnergyUtil.moveEnergy(from, to, amount);
    }

    public static void distributeEnergyNearby(Level level, BlockPos pos, int amount) {
        EnergyUtil.distributeEnergyNearby(level, pos, amount, null);
    }

    public static void distributeEnergyNearby(Level level, BlockPos pos, int amount, List<Direction> outputDirections) {
        if (outputDirections == null || outputDirections.isEmpty()) {
            EnergyUtil.distributeInAllDirections(level, pos, amount);
        } else {
            EnergyUtil.distributeInDirections(level, pos, amount, outputDirections);
        }
    }

    private static int distributeInDirections(Level level, BlockPos pos, int amount, List<Direction> outputDirections) {
        HashMap<UniversalEnergyStorage, UniversalEnergyStorage> pairs = new HashMap<UniversalEnergyStorage, UniversalEnergyStorage>();
        for (Direction direction : outputDirections) {
            UniversalEnergyStorage to;
            UniversalEnergyStorage from = (UniversalEnergyStorage)Capabilities.Energy.BLOCK.getCapability(level, pos, (Object)direction);
            if (from == null || !from.canExtractEnergy() || from.extract(amount, true) == 0 || (to = (UniversalEnergyStorage)Capabilities.Energy.BLOCK.getCapability(level, pos, (Object)direction)) == null || !to.canInsertEnergy() || to.insert(amount, true) == 0) continue;
            pairs.put(from, to);
        }
        AtomicInteger toDistribute = new AtomicInteger(amount);
        AtomicInteger receivers = new AtomicInteger(pairs.size());
        pairs.forEach((energyFrom, energyTo) -> {
            toDistribute.addAndGet(-EnergyUtil.moveEnergy(energyFrom, energyTo, toDistribute.get() / receivers.get()));
            receivers.getAndDecrement();
        });
        return amount - toDistribute.get();
    }

    private static void distributeInAllDirections(Level level, BlockPos pos, int amount) {
        UniversalEnergyStorage from = (UniversalEnergyStorage)Capabilities.Energy.BLOCK.getCapability(level, pos, null);
        if (from == null || !from.canExtractEnergy()) {
            return;
        }
        int finalAmount = from.extract(amount, true);
        if (finalAmount == 0) {
            return;
        }
        List<UniversalEnergyStorage> toSend = Direction.stream().map(direction -> (UniversalEnergyStorage)Capabilities.Energy.BLOCK.getCapability(level, pos.relative(direction), (Object)direction.getOpposite())).filter(Objects::nonNull).filter(UniversalEnergyStorage::canInsertEnergy).sorted(Comparator.comparing(energyStorage -> energyStorage.insert(finalAmount, true))).toList();
        if (toSend.isEmpty()) {
            return;
        }
        int receivers = toSend.size();
        int toDistribute = finalAmount;
        for (UniversalEnergyStorage to : toSend) {
            toDistribute -= EnergyUtil.moveEnergy(from, to, finalAmount / receivers);
        }
    }

    public static int moveEnergy(UniversalEnergyStorage from, UniversalEnergyStorage to, int amount) {
        int inserted = to.insert(from.extract(amount, true), true);
        if (inserted > 0) {
            from.extract(inserted, false);
            to.insert(inserted, false);
            return inserted;
        }
        return 0;
    }
}

