/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.BaseWindowScreen;
import com.st0x0ef.stellaris.client.screens.GalaxyScreen;
import com.st0x0ef.stellaris.client.screens.components.InvisibleButton;
import com.st0x0ef.stellaris.client.screens.etc.Trail;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.info.MoonInfo;
import com.st0x0ef.stellaris.client.screens.info.PSystemInfo;
import com.st0x0ef.stellaris.client.screens.info.PlanetInfo;
import com.st0x0ef.stellaris.client.screens.windows.LaunchWindow;
import com.st0x0ef.stellaris.client.screens.windows.MoveableWindow;
import com.st0x0ef.stellaris.client.screens.windows.SpaceStationWindow;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipesManager;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.network.packets.OpenMilkyWayMenuPacket;
import com.st0x0ef.stellaris.common.network.packets.PlaceStationPacket;
import com.st0x0ef.stellaris.common.network.packets.TeleportEntityToPlanetPacket;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_481;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_8710;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWScrollCallback;

@Environment(value=EnvType.CLIENT)
public class PlanetSelectionScreen
extends BaseWindowScreen<PlanetSelectionMenu> {
    public static final class_2960 HIGHLIGHTER_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/planet_highlighter.png");
    public static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"stellaris", (String)"textures/gui/planet_selection.png");
    public static final List<CelestialBody> STARS = new ArrayList<CelestialBody>();
    public static final List<PlanetInfo> PLANETS = new ArrayList<PlanetInfo>();
    public static final List<MoonInfo> MOONS = new ArrayList<MoonInfo>();
    public static final List<PSystemInfo> PSYSTEMS = new ArrayList<PSystemInfo>();
    public static LaunchPad.LaunchPadContainer LAUNCH_PADS = new LaunchPad.LaunchPadContainer(new ArrayList<LaunchPad>());
    private boolean showHelpMenu = true;
    private boolean showSpaceStationMenu = false;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double lastMouseX;
    private double lastMouseY;
    public boolean dragging = false;
    public boolean isPausePressed = false;
    private boolean isWheelButtonDown = false;
    public boolean isPlanetScreenOpened;
    @Nullable
    public CelestialBody focusedBody = null;
    @Nullable
    public CelestialBody hoveredBody = null;
    private double zoomLevel = 1.0;
    private double targetZoomLevel = 1.0;
    public boolean canZoom;
    private double targetOffsetX = 0.0;
    private double targetOffsetY = 0.0;
    private GLFWScrollCallback prevScrollCallback;
    private final List<InvisibleButton> planetButtons = new ArrayList<InvisibleButton>();
    private final List<InvisibleButton> moonButtons = new ArrayList<InvisibleButton>();
    public ArrayList<MoveableWindow> moveableWindows = new ArrayList();
    private LaunchWindow launchWindow;
    private SpaceStationWindow spaceStationWindow;
    public int windowIndex = -1;
    private int currentHighlighterFrame = 0;
    private final int totalHighlighterFrames = 30;
    private int leftArrowX;
    private int rightArrowX;
    private int arrowY;
    private int arrowWidth = 25;
    private int arrowHeight = 25;
    private final int verticalArrowWidth = 20;
    private final int verticalArrowHeight = 20;
    int galaxyWidth = 21;
    int galaxyHeight = 12;
    int galaxyX = 4;
    int galaxyY = 4;
    private int centerArrowX;

    public PlanetSelectionScreen(PlanetSelectionMenu abstractContainerMenu, class_1661 inventory, class_2561 component) {
        super(abstractContainerMenu, inventory, component);
        this.field_2792 = 1200;
        this.field_2779 = 1600;
        this.field_25270 = this.field_2779 - 110;
        this.canZoom = true;
    }

    protected void method_25426() {
        super.method_25426();
        this.getMenu().freeze_gui = false;
        this.initWindows();
        this.centerSun();
        this.isPlanetScreenOpened = true;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)class_310.method_1551().method_22683().method_4490(), this::onMouseScroll);
        this.initializeAllButtons();
        this.zoomLevel = 1.0;
        this.targetZoomLevel = 1.0;
    }

    public void initWindows() {
        this.launchWindow = new LaunchWindow(300, 200, (class_2561)class_2561.method_43470((String)"Launch"), this);
        this.launchWindow.field_22764 = false;
        this.method_37063(this.launchWindow);
        this.launchWindow.changeVisibility(false);
        this.moveableWindows.add(this.launchWindow);
        this.spaceStationWindow = new SpaceStationWindow(300, 200, (class_2561)class_2561.method_43470((String)"Space Station"), this);
        this.spaceStationWindow.field_22764 = false;
        this.method_37063(this.spaceStationWindow);
        this.spaceStationWindow.changeVisibility(false);
        this.moveableWindows.add(this.spaceStationWindow);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_2389(graphics, partialTicks, mouseX, mouseY);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (!this.isPausePressed) {
            this.updatePlanets();
        }
        this.updateZoomAndOffsetAnimation();
        if (this.focusedBody != null) {
            this.centerOnBody(this.focusedBody);
        }
        this.drawOrbits();
        this.drawTrails();
        this.renderBodiesAndPlanets(graphics);
        this.hoveredBody = null;
        for (MoonInfo moon : MOONS) {
            int moonWidth = (int)((double)moon.width * this.zoomLevel);
            int moonHeight = (int)((double)moon.height * this.zoomLevel);
            float moonX = (float)(((double)moon.x + this.offsetX) * this.zoomLevel - (double)moonWidth / 2.0);
            float moonY = (float)(((double)moon.y + this.offsetY) * this.zoomLevel - (double)moonHeight / 2.0);
            if (!((float)mouseX >= moonX) || !((float)mouseX <= moonX + (float)moonWidth) || !((float)mouseY >= moonY) || !((float)mouseY <= moonY + (float)moonHeight)) continue;
            this.hoveredBody = moon;
            break;
        }
        if (this.hoveredBody == null) {
            for (PlanetInfo planet : PLANETS) {
                int planetWidth = (int)((double)planet.width * this.zoomLevel);
                int planetHeight = (int)((double)planet.height * this.zoomLevel);
                float planetX = (float)(((double)planet.orbitCenter.x + this.offsetX + planet.orbitRadius * Math.cos(planet.currentAngle) - (double)planetWidth / 2.0) * this.zoomLevel);
                float planetY = (float)(((double)planet.orbitCenter.y + this.offsetY + planet.orbitRadius * Math.sin(planet.currentAngle) - (double)planetHeight / 2.0) * this.zoomLevel);
                if (!((float)mouseX >= planetX) || !((float)mouseX <= planetX + (float)planetWidth) || !((float)mouseY >= planetY) || !((float)mouseY <= planetY + (float)planetHeight)) continue;
                this.hoveredBody = planet;
                break;
            }
        }
        if (this.hoveredBody != null) {
            this.updateHighlighterPosition(graphics, this.hoveredBody);
        }
        if (this.focusedBody != null) {
            this.updateHighlighterPosition(graphics, this.focusedBody);
        }
        this.initTop(graphics, mouseX, mouseY);
        this.renderLaunchPads(graphics, mouseX, mouseY, partialTicks);
        this.method_2380(graphics, mouseX, mouseY);
    }

    public boolean canLaunch(Planet planet) {
        if (this.getMenu().getForceCanGoTo()) {
            return true;
        }
        class_1657 player = this.getPlayer();
        if (player == null) {
            return false;
        }
        class_1297 vehicle = player.method_5854();
        if (vehicle instanceof RocketEntity) {
            RocketEntity rocket = (RocketEntity)vehicle;
            if (PlanetUtil.isPlanet(player.method_37908().method_27983().method_29177())) {
                return rocket.canGoTo(PlanetUtil.getPlanet(player.method_37908().method_27983().method_29177()), planet);
            }
            return rocket.canGoTo(PlanetUtil.getPlanet(class_1937.field_25179.method_29177()), planet);
        }
        return false;
    }

    private void initializeAllButtons() {
        this.initializePlanetButtons();
        this.initializeMoonButtons();
    }

    private void initializePlanetButtons() {
        this.planetButtons.clear();
    }

    private void initializeMoonButtons() {
        this.moonButtons.clear();
    }

    private void initTop(class_332 graphics, int mouseX, int mouseY) {
        List<class_5250> tooltipLines;
        class_2960 topBarTexture = class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/planet_selection_bar.png");
        int tgWidth = 240;
        int tgHeight = 32;
        int tgX = (this.field_22789 - tgWidth) / 2;
        int tgY = this.field_22790 - 48;
        int infoWidth = 12;
        int infoHeight = 12;
        int infoX = this.field_22789 - 20;
        int infoY = 4;
        this.leftArrowX = tgX + 7;
        this.rightArrowX = tgX + tgWidth - this.arrowWidth - 7;
        this.arrowY = tgY + (tgHeight - this.arrowHeight) / 2;
        boolean infoHovering = Utils.isHoveredOnSprite(infoX, infoY, infoWidth, infoHeight, mouseX, mouseY);
        boolean galaxyHovering = Utils.isHoveredOnSprite(this.galaxyX, this.galaxyY, this.galaxyWidth, this.galaxyHeight, mouseX, mouseY);
        graphics.method_25290(topBarTexture, tgX, tgY, 0.0f, 0.0f, tgWidth, tgHeight, tgWidth, tgHeight);
        graphics.method_25290(class_2960.method_60655((String)"stellaris", (String)("textures/gui/util/" + (infoHovering ? "planet_selection_info_button_hover.png" : "planet_selection_info_button.png"))), infoX, infoY, 0.0f, 0.0f, infoWidth, infoHeight, infoWidth, infoHeight);
        graphics.method_25290(class_2960.method_60655((String)"stellaris", (String)("textures/gui/util/" + (galaxyHovering ? "planet_selection_galaxy_button_hover.png" : "planet_selection_galaxy_button.png"))), this.galaxyX, this.galaxyY, 0.0f, 0.0f, this.galaxyWidth, this.galaxyHeight, this.galaxyWidth, this.galaxyHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean arrowHoveringLeft = Utils.isHoveredOnSprite(this.leftArrowX, this.arrowY, this.arrowWidth, this.arrowHeight, mouseX, mouseY);
        boolean arrowHoveringRight = Utils.isHoveredOnSprite(this.rightArrowX, this.arrowY, this.arrowWidth, this.arrowHeight, mouseX, mouseY);
        graphics.method_25290(class_2960.method_60655((String)"stellaris", (String)("textures/gui/util/" + (arrowHoveringLeft ? "planet_selection_arrow_left_hover.png" : "planet_selection_arrow_left.png"))), this.leftArrowX, this.arrowY, 0.0f, 0.0f, this.arrowWidth, this.arrowHeight, this.arrowWidth, this.arrowHeight);
        graphics.method_25290(class_2960.method_60655((String)"stellaris", (String)("textures/gui/util/" + (arrowHoveringRight ? "planet_selection_arrow_right_hover.png" : "planet_selection_arrow_right.png"))), this.rightArrowX, this.arrowY, 0.0f, 0.0f, this.arrowWidth, this.arrowHeight, this.arrowWidth, this.arrowHeight);
        class_5250 bodyName = this.focusedBody != null ? this.focusedBody.getTranslatable() : class_2561.method_43470((String)"X");
        int nameWidth = this.field_22793.method_27525((class_5348)bodyName);
        int nameX = tgX + tgWidth / 2 - nameWidth / 2;
        int n = tgY + tgHeight / 2;
        Objects.requireNonNull(this.field_22793);
        int nameY = n - 9 / 2;
        graphics.method_51439(this.field_22793, (class_2561)bodyName, nameX, nameY, 0xFFFFFF, true);
        if (infoHovering) {
            tooltipLines = List.of(class_2561.method_43471((String)"text.stellaris.planetscreen.space"), class_2561.method_43471((String)"text.stellaris.planetscreen.arrows"));
            graphics.method_51437(this.field_22793, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
        if (galaxyHovering) {
            tooltipLines = List.of(class_2561.method_43471((String)"text.stellaris.planetscreen.returntogalaxy"));
            graphics.method_51437(this.field_22793, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    private void updateZoomAndOffsetAnimation() {
        double smoothing = 0.05;
        this.zoomLevel += (this.targetZoomLevel - this.zoomLevel) * smoothing;
        this.offsetX += (this.targetOffsetX - this.offsetX) * smoothing;
        this.offsetY += (this.targetOffsetY - this.offsetY) * smoothing;
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BACKGROUND_TEXTURE);
        graphics.method_25290(BACKGROUND_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.field_2792, this.field_2779);
    }

    public void renderBodiesAndPlanets(class_332 graphics) {
        this.renderStars(graphics);
        this.renderPlanets(graphics);
        this.renderMoons(graphics);
        this.initializePlanetButtons();
        this.initializeMoonButtons();
    }

    private void renderStars(class_332 graphics) {
        for (CelestialBody star : STARS) {
            if (!this.isInCurrentGalaxy(star)) continue;
            float bodyX = (float)(((double)star.x + this.offsetX) * this.zoomLevel - (double)(star.width / 2.0f) * this.zoomLevel);
            float bodyY = (float)(((double)star.y + this.offsetY) * this.zoomLevel - (double)(star.height / 2.0f) * this.zoomLevel);
            int bodyWidth = (int)((double)star.width * this.zoomLevel);
            int bodyHeight = (int)((double)star.height * this.zoomLevel);
            graphics.method_25290(star.texture, (int)bodyX, (int)bodyY, 0.0f, 0.0f, bodyWidth, bodyHeight, bodyWidth, bodyHeight);
            int nameWidth = this.field_22793.method_27525((class_5348)star.getTranslatable());
            graphics.method_27535(this.field_22793, star.getTranslatable(), (int)(bodyX + (float)bodyWidth / 2.0f - (float)nameWidth / 2.0f), (int)(bodyY + (float)bodyHeight), 0xFFFFFF);
        }
    }

    private void renderPlanets(class_332 graphics) {
        for (PlanetInfo planet : PLANETS) {
            if (!this.isInCurrentGalaxy(planet)) continue;
            CelestialBody orbitCenter = planet.orbitCenter;
            float orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            float orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            float planetX = (float)((double)orbitCenterX + planet.orbitRadius * this.zoomLevel * Math.cos(planet.currentAngle) - (double)(planet.width / 2.0f) * this.zoomLevel);
            float planetY = (float)((double)orbitCenterY + planet.orbitRadius * this.zoomLevel * Math.sin(planet.currentAngle) - (double)(planet.height / 2.0f) * this.zoomLevel);
            int planetWidth = (int)((double)planet.width * this.zoomLevel);
            int planetHeight = (int)((double)planet.height * this.zoomLevel);
            ScreenHelper.drawTexturewithRotation(graphics, planet.texture, (int)planetX, (int)planetY, 0, 0, planetWidth, planetHeight, planetWidth, planetHeight, (float)planet.currentAngle);
            int nameWidth = this.field_22793.method_1727(planet.name);
            graphics.method_27535(this.field_22793, planet.getTranslatable(), (int)(planetX + (float)planetWidth / 2.0f - (float)nameWidth / 2.0f), (int)(planetY + (float)planetHeight), 0xFFFFFF);
        }
    }

    private void renderMoons(class_332 graphics) {
        for (MoonInfo moon : MOONS) {
            if (!this.isInCurrentGalaxy(moon)) continue;
            float moonX = (float)(((double)moon.x + this.offsetX) * this.zoomLevel - (double)(moon.width / 2.0f) * this.zoomLevel);
            float moonY = (float)(((double)moon.y + this.offsetY) * this.zoomLevel - (double)(moon.height / 2.0f) * this.zoomLevel);
            int moonWidth = (int)((double)moon.width * this.zoomLevel);
            int moonHeight = (int)((double)moon.height * this.zoomLevel);
            ScreenHelper.drawTexturewithRotation(graphics, moon.texture, (int)moonX, (int)moonY, 0, 0, moonWidth, moonHeight, moonWidth, moonHeight, (float)moon.currentAngle);
        }
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 90) {
            if (this.focusedBody != null && this.canLaunch(PlanetUtil.getPlanet(this.focusedBody.dimension))) {
                this.showSpaceStationMenu = !this.showSpaceStationMenu;
            }
        } else if (keyCode == 72) {
            this.showHelpMenu = !this.showHelpMenu;
        } else if (keyCode == 32 || keyCode == 88) {
            this.isPausePressed = !this.isPausePressed;
        } else if (keyCode == 262) {
            if (this.focusedBody == null) {
                this.focusedBody = PlanetSelectionScreen.findByNameStar("stellaris:sun");
            } else if (this.focusedBody instanceof PlanetInfo || this.focusedBody instanceof MoonInfo) {
                this.focusedBody = this.getNextBodyByDistance(this.focusedBody);
            } else if (this.focusedBody instanceof CelestialBody) {
                this.focusedBody = this.getNextStarByDistance(this.focusedBody);
            }
            if (this.focusedBody != null && !this.isInCurrentGalaxy(this.focusedBody)) {
                this.focusedBody = null;
                return true;
            }
            if (this.focusedBody != null) {
                this.centerOnBody(this.focusedBody);
            }
        } else if (keyCode == 263) {
            if (this.focusedBody == null) {
                this.focusedBody = PlanetSelectionScreen.findByNameStar("stellaris:sun");
            } else if (this.focusedBody instanceof PlanetInfo || this.focusedBody instanceof MoonInfo) {
                this.focusedBody = this.getPreviousBodyByDistance(this.focusedBody);
            } else if (this.focusedBody instanceof CelestialBody) {
                this.focusedBody = this.getPreviousStarByDistance(this.focusedBody);
            }
            if (this.focusedBody != null && !this.isInCurrentGalaxy(this.focusedBody)) {
                this.focusedBody = null;
                return true;
            }
            if (this.focusedBody != null) {
                this.centerOnBody(this.focusedBody);
            }
        } else if (keyCode == 265) {
            CelestialBody celestialBody = this.focusedBody;
            if (celestialBody instanceof MoonInfo) {
                MoonInfo moon = (MoonInfo)celestialBody;
                this.focusedBody = moon.orbitCenter;
            } else {
                celestialBody = this.focusedBody;
                if (celestialBody instanceof PlanetInfo) {
                    PlanetInfo planet = (PlanetInfo)celestialBody;
                    this.focusedBody = planet.orbitCenter;
                }
            }
            if (this.focusedBody != null && !this.isInCurrentGalaxy(this.focusedBody)) {
                this.focusedBody = null;
                return true;
            }
            this.centerOnBody(this.focusedBody);
        } else if (keyCode == 264) {
            CelestialBody celestialBody = this.focusedBody;
            if (celestialBody instanceof PlanetInfo) {
                PlanetInfo planet = (PlanetInfo)celestialBody;
                this.focusedBody = this.getMoonsByDistance(planet);
            } else {
                celestialBody = this.focusedBody;
                if (celestialBody instanceof CelestialBody) {
                    CelestialBody star = celestialBody;
                    List<PlanetInfo> planetsInSystem = PLANETS.stream().filter(p -> p.orbitCenter == star).sorted(Comparator.comparingDouble(p -> p.orbitRadius)).toList();
                    if (!planetsInSystem.isEmpty()) {
                        this.focusedBody = planetsInSystem.getFirst();
                    }
                }
            }
            if (this.focusedBody != null && !this.isInCurrentGalaxy(this.focusedBody)) {
                this.focusedBody = null;
                return true;
            }
            this.centerOnBody(this.focusedBody);
        } else if (keyCode == 256 && this.windowIndex != -1) {
            this.showSpaceStationMenu = false;
            this.showPreviousWindow();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void showPreviousWindow() {
        if (this.windowIndex != -1) {
            this.setWindowVisible(--this.windowIndex);
        }
    }

    public void setWindowVisible(int index) {
        for (int i = 0; i < this.moveableWindows.size(); ++i) {
            MoveableWindow window = this.moveableWindows.get(i);
            if (i == index) {
                window.changeVisibility(true);
                window.field_22764 = true;
                this.windowIndex = i;
                continue;
            }
            window.close();
            window.changeVisibility(false);
            window.field_22764 = false;
        }
    }

    private CelestialBody getNextBodyByDistance(CelestialBody currentBody) {
        block7: {
            block8: {
                block6: {
                    if (currentBody == null) {
                        return null;
                    }
                    if (!(currentBody instanceof PlanetInfo)) break block6;
                    PlanetInfo planetInfo = (PlanetInfo)currentBody;
                    ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
                    bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                    for (int i = 0; i < bodies.size(); ++i) {
                        if (bodies.get(i) != currentBody) continue;
                        for (int j = i + 1; j < bodies.size(); ++j) {
                            if (((PlanetInfo)bodies.get((int)j)).orbitCenter != planetInfo.orbitCenter) continue;
                            return (CelestialBody)bodies.get(j);
                        }
                    }
                    break block7;
                }
                if (!(currentBody instanceof MoonInfo)) break block8;
                MoonInfo moonInfo = (MoonInfo)currentBody;
                ArrayList<MoonInfo> bodies = new ArrayList<MoonInfo>(MOONS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = 0; i < bodies.size(); ++i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i + 1; j < bodies.size(); ++j) {
                        if (((MoonInfo)bodies.get((int)j)).orbitCenter != moonInfo.orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break block7;
            }
            if (!STARS.contains(currentBody)) break block7;
            ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
            bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
            for (PlanetInfo planet : bodies) {
                if (planet.orbitCenter != currentBody) continue;
                return planet;
            }
        }
        return currentBody;
    }

    private CelestialBody getPreviousBodyByDistance(CelestialBody currentBody) {
        block7: {
            block8: {
                block6: {
                    if (currentBody == null) {
                        return null;
                    }
                    if (!(currentBody instanceof PlanetInfo)) break block6;
                    PlanetInfo planetInfo = (PlanetInfo)currentBody;
                    ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
                    bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                    for (int i = bodies.size() - 1; i >= 0; --i) {
                        if (bodies.get(i) != currentBody) continue;
                        for (int j = i - 1; j >= 0; --j) {
                            if (((PlanetInfo)bodies.get((int)j)).orbitCenter != planetInfo.orbitCenter) continue;
                            return (CelestialBody)bodies.get(j);
                        }
                    }
                    break block7;
                }
                if (!(currentBody instanceof MoonInfo)) break block8;
                MoonInfo moonInfo = (MoonInfo)currentBody;
                ArrayList<MoonInfo> bodies = new ArrayList<MoonInfo>(MOONS);
                bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
                for (int i = bodies.size() - 1; i >= 0; --i) {
                    if (bodies.get(i) != currentBody) continue;
                    for (int j = i - 1; j >= 0; --j) {
                        if (((MoonInfo)bodies.get((int)j)).orbitCenter != moonInfo.orbitCenter) continue;
                        return (CelestialBody)bodies.get(j);
                    }
                }
                break block7;
            }
            if (!STARS.contains(currentBody)) break block7;
            ArrayList<PlanetInfo> bodies = new ArrayList<PlanetInfo>(PLANETS);
            bodies.sort(Comparator.comparingDouble(b -> b.orbitRadius));
            for (int i = bodies.size() - 1; i >= 0; --i) {
                if (((PlanetInfo)bodies.get((int)i)).orbitCenter != currentBody) continue;
                return (CelestialBody)bodies.get(i);
            }
        }
        return currentBody;
    }

    private CelestialBody getMoonsByDistance(PlanetInfo currentBody) {
        CelestialBody smallestOrbitMoon = null;
        for (MoonInfo moon : MOONS) {
            if (!moon.orbitCenter.equals(currentBody) || smallestOrbitMoon != null && !(moon.orbitRadius < ((MoonInfo)smallestOrbitMoon).orbitRadius)) continue;
            smallestOrbitMoon = moon;
        }
        return smallestOrbitMoon != null ? smallestOrbitMoon : currentBody;
    }

    private CelestialBody getNextStarByDistance(CelestialBody currentBody) {
        ArrayList<CelestialBody> stars = new ArrayList<CelestialBody>(STARS);
        stars.sort(Comparator.comparing(CelestialBody::getId));
        for (int i = 0; i < stars.size(); ++i) {
            if (stars.get(i) != currentBody) continue;
            return (CelestialBody)stars.get((i + 1) % stars.size());
        }
        return currentBody;
    }

    private CelestialBody getPreviousStarByDistance(CelestialBody currentBody) {
        ArrayList<CelestialBody> stars = new ArrayList<CelestialBody>(STARS);
        stars.sort(Comparator.comparing(CelestialBody::getId));
        for (int i = 0; i < stars.size(); ++i) {
            if (stars.get(i) != currentBody) continue;
            return (CelestialBody)stars.get((i - 1 + stars.size()) % stars.size());
        }
        return currentBody;
    }

    private int getMoonsCount(PlanetInfo currentBody) {
        int i = 0;
        for (MoonInfo moon : MOONS) {
            if (!moon.orbitCenter.equals(currentBody)) continue;
            ++i;
        }
        return i;
    }

    public void tpToFocusedPlanet(class_2960 dimension) {
        this.tpToFocusedPlanet(new class_243(this.getPlayer().method_23317(), (double)Stellaris.CONFIG.rocketTpHeight, this.getPlayer().method_23321()), dimension);
    }

    public void tpToFocusedPlanet(class_243 coords, class_2960 focusedBodyDimension) {
        if (focusedBodyDimension != null) {
            NetworkManager.sendToServer((class_8710)new TeleportEntityToPlanetPacket(focusedBodyDimension, coords));
            long windowHandle = class_310.method_1551().method_22683().method_4490();
            if (this.prevScrollCallback != null) {
                GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((class_312)class_310.method_1551().field_1729).method_1598(arg_0, arg_1, arg_2));
            }
        } else {
            Stellaris.LOG.error("Destination dimension for teleportation is null");
        }
    }

    private void updatePlanets() {
        long time = class_156.method_658();
        if (!this.getMenu().freeze_gui || !this.isPausePressed) {
            for (PlanetInfo planet : PLANETS) {
                planet.updateAngle(time);
                planet.updatePosition();
                planet.trail.addPosition(planet.x, planet.y);
            }
            for (MoonInfo moon : MOONS) {
                moon.updateAngle(time);
                moon.updatePosition();
                moon.trail.addPosition(moon.x, moon.y);
            }
            double G = 10000.0;
            double dt = 0.1;
            return;
        }
    }

    public void drawTrails() {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        for (CelestialBody star : STARS) {
            if (!this.isInCurrentGalaxy(star)) continue;
            this.renderTrail(tesselator, star.trail, 0xFFFFFF, 0.5f);
        }
        RenderSystem.disableBlend();
    }

    public void renderTrail(class_289 tesselator, Trail trail, int color, float alpha) {
        List<float[]> positions = trail.getPositions();
        if (positions.size() < 2) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_29345, class_290.field_1576);
        for (float[] pos : positions) {
            float x = (float)(((double)pos[0] + this.offsetX) * this.zoomLevel);
            float y = (float)(((double)pos[1] + this.offsetY) * this.zoomLevel);
            bufferBuilder.method_22912(x, y, 0.0f).method_22915(red, green, blue, alpha);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void updateChildPositions(CelestialBody orbitCenter, long time) {
        for (PlanetInfo planet : PLANETS) {
            if (planet.orbitCenter != orbitCenter) continue;
            planet.updateAngle(time);
            planet.updatePosition();
            this.updateMoonPositions(planet, time);
        }
    }

    private void updateMoonPositions(PlanetInfo planet, long time) {
        for (MoonInfo moon : MOONS) {
            if (moon.orbitCenter != planet) continue;
            moon.updateAngle(time);
            moon.updatePosition();
        }
    }

    public void drawOrbits() {
        float orbitCenterY;
        float orbitCenterX;
        CelestialBody orbitCenter;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        for (PlanetInfo planet : PLANETS) {
            if (!this.isInCurrentGalaxy(planet) || !this.isInCurrentGalaxy(planet.orbitCenter)) continue;
            orbitCenter = planet.orbitCenter;
            orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            PlanetSelectionScreen.renderOrbits(tesselator, orbitCenterX, orbitCenterY, planet.orbitRadius * this.zoomLevel, 75, orbitCenter.orbitColor, 1.0f);
        }
        for (MoonInfo moon : MOONS) {
            if (!this.isInCurrentGalaxy(moon) || !this.isInCurrentGalaxy(moon.orbitCenter)) continue;
            orbitCenter = moon.orbitCenter;
            orbitCenterX = (float)(((double)orbitCenter.x + this.offsetX) * this.zoomLevel);
            orbitCenterY = (float)(((double)orbitCenter.y + this.offsetY) * this.zoomLevel);
            PlanetSelectionScreen.renderOrbits(tesselator, orbitCenterX, orbitCenterY, moon.orbitRadius * this.zoomLevel, 75, 0x888888, 0.5f);
        }
        RenderSystem.disableBlend();
    }

    public static void renderOrbits(class_289 tesselator, double centerX, double centerY, double radius, int sides, int color, float alphaL) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float angleStep = (float)(Math.PI * 2 / (double)sides);
        class_287 bufferBuilder = tesselator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        for (int i = 0; i < sides; ++i) {
            float currentAngle = (float)i * angleStep;
            float nextAngle = currentAngle + angleStep;
            float vertex1X = (float)(centerX + radius * Math.cos(currentAngle));
            float vertex1Y = (float)(centerY + radius * Math.sin(currentAngle));
            float vertex2X = (float)(centerX + radius * Math.cos(nextAngle));
            float vertex2Y = (float)(centerY + radius * Math.sin(nextAngle));
            bufferBuilder.method_22912(vertex1X, vertex1Y, 0.0f).method_22915(red, green, blue, alphaL);
            bufferBuilder.method_22912(vertex2X, vertex2Y, 0.0f).method_22915(red, green, blue, alphaL);
        }
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    private void centerSun() {
        float centerX = (float)this.field_22789 / 2.0f;
        float centerY = (float)this.field_22790 / 2.0f;
        CelestialBody sun = PlanetSelectionScreen.findByNameStar(GalaxyScreen.findByNameGalaxy(this.getMenu().getGalaxyId()).centerStar());
        if (sun != null) {
            sun.setPosition(centerX, centerY);
        } else {
            Stellaris.LOG.error("center sun is null");
        }
        this.offsetX = 0.0;
        this.offsetY = 0.0;
    }

    private boolean isInCurrentGalaxy(CelestialBody body) {
        return body.galaxy.equals(this.getMenu().getGalaxyId()) || body.galaxy.equals("null");
    }

    public static CelestialBody findByNameStar(String id) {
        for (CelestialBody body : STARS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        Stellaris.LOG.warn("Star not found : {}", (Object)id);
        return null;
    }

    public static PlanetInfo findByNamePlanet(String id) {
        for (PlanetInfo body : PLANETS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        return null;
    }

    public static MoonInfo findByNameMoon(String id) {
        for (MoonInfo body : MOONS) {
            if (!body.getId().equals(id)) continue;
            return body;
        }
        return null;
    }

    public void centerOnBody(CelestialBody body) {
        if (body == null) {
            return;
        }
        this.zoomLevel = 1.0;
        this.targetOffsetX = ((double)body.x - (double)this.field_22789 / 2.0) * -1.0;
        this.targetOffsetY = ((double)body.y - (double)this.field_22790 / 2.0) * -1.0;
    }

    public void onMouseScroll(long window, double scrollX, double scrollY) {
        double[] mouseX = new double[1];
        double[] mouseY = new double[1];
        GLFW.glfwGetCursorPos((long)window, (double[])mouseX, (double[])mouseY);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_481 creativeScreen;
            class_437 class_4372;
            if (this.field_22787.field_1755 != null) {
                this.handleHotbarScroll(scrollY);
            }
            if ((class_4372 = this.field_22787.field_1755) instanceof class_481 && (creativeScreen = (class_481)class_4372).method_25401(mouseX[0], mouseY[0], scrollX, scrollY)) {
                return;
            }
            if (this.field_22787.field_1755 instanceof PlanetSelectionScreen) {
                if (this.windowIndex != -1) {
                    this.method_25401(mouseX[0], mouseY[0], scrollX, scrollY);
                    return;
                }
                if (scrollY != 0.0 && this.canZoom) {
                    double screenX = (double)this.field_22789 / 4.0;
                    double screenY = (double)this.field_22790 / 4.0;
                    double beforeZoomWorldX = screenX / this.zoomLevel - this.offsetX;
                    double beforeZoomWorldY = screenY / this.zoomLevel - this.offsetY;
                    this.targetZoomLevel += scrollY * 0.1;
                    this.targetZoomLevel = Math.max(0.2, Math.min(this.targetZoomLevel, 1.2));
                    double afterZoomWorldX = screenX / this.targetZoomLevel - this.offsetX;
                    double afterZoomWorldY = screenY / this.targetZoomLevel - this.offsetY;
                    double offsetAdjustX = beforeZoomWorldX - afterZoomWorldX;
                    double offsetAdjustY = beforeZoomWorldY - afterZoomWorldY;
                    this.targetOffsetX += offsetAdjustX;
                    this.targetOffsetY += offsetAdjustY;
                }
            }
        }
    }

    private boolean handleHotbarScroll(double scrollY) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            int currentSlot = this.field_22787.field_1724.method_31548().field_7545;
            int newSlot = currentSlot - (int)scrollY;
            if ((newSlot = (newSlot + 9) % 9) != currentSlot) {
                this.field_22787.field_1724.method_31548().field_7545 = newSlot;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 2) {
            this.isWheelButtonDown = true;
        }
        if (button == 0 || button == 1) {
            boolean isArrowHovered;
            this.dragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            boolean bl = isArrowHovered = mouseX >= (double)this.leftArrowX && mouseX <= (double)(this.leftArrowX + this.arrowWidth) && mouseY >= (double)this.arrowY && mouseY <= (double)(this.arrowY + this.arrowHeight);
            if (mouseX >= (double)this.leftArrowX && mouseX <= (double)(this.leftArrowX + this.arrowWidth) && mouseY >= (double)this.arrowY && mouseY <= (double)(this.arrowY + this.arrowHeight)) {
                this.focusedBody = this.focusedBody == null ? PlanetSelectionScreen.findByNamePlanet("stellaris:earth") : (this.focusedBody instanceof PlanetInfo || this.focusedBody instanceof MoonInfo ? this.getPreviousBodyByDistance(this.focusedBody) : this.getPreviousStarByDistance(this.focusedBody));
                if (!this.isInCurrentGalaxy(this.focusedBody)) {
                    this.focusedBody = null;
                }
                class_310.method_1551().field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f);
                if (this.focusedBody != null) {
                    this.centerOnBody(this.focusedBody);
                }
                return true;
            }
            if (mouseX >= (double)this.rightArrowX && mouseX <= (double)(this.rightArrowX + this.arrowWidth) && mouseY >= (double)this.arrowY && mouseY <= (double)(this.arrowY + this.arrowHeight)) {
                this.focusedBody = this.focusedBody == null ? PlanetSelectionScreen.findByNamePlanet("stellaris:earth") : (this.focusedBody instanceof PlanetInfo || this.focusedBody instanceof MoonInfo ? this.getNextBodyByDistance(this.focusedBody) : this.getNextStarByDistance(this.focusedBody));
                if (!this.isInCurrentGalaxy(this.focusedBody)) {
                    this.focusedBody = null;
                }
                class_310.method_1551().field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f);
                if (this.focusedBody != null) {
                    this.centerOnBody(this.focusedBody);
                }
                return true;
            }
            if (Utils.isHoveredOnSprite(this.galaxyX, this.galaxyY, this.galaxyWidth, this.galaxyHeight, mouseX, mouseY)) {
                class_310.method_1551().field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f);
                NetworkManager.sendToServer((class_8710)new OpenMilkyWayMenuPacket());
            }
            if (!this.showSpaceStationMenu) {
                this.focusedBody = null;
                this.hoveredBody = null;
                for (MoonInfo moon : MOONS) {
                    if (!this.isInCurrentGalaxy(moon)) continue;
                    double mx = (double)moon.orbitCenter.x + this.offsetX + moon.orbitRadius * Math.cos(moon.currentAngle);
                    double my = (double)moon.orbitCenter.y + this.offsetY + moon.orbitRadius * Math.sin(moon.currentAngle);
                    int moonWidth = (int)((double)moon.width * this.zoomLevel);
                    int moonHeight = (int)((double)moon.height * this.zoomLevel);
                    float moonX = (float)((mx - (double)(moon.width / 2.0f)) * this.zoomLevel);
                    float moonY = (float)((my - (double)(moon.height / 2.0f)) * this.zoomLevel);
                    if (!(mouseX >= (double)moonX) || !(mouseX <= (double)(moonX + (float)moonWidth)) || !(mouseY >= (double)moonY) || !(mouseY <= (double)(moonY + (float)moonHeight)) || !moon.clickable) continue;
                    this.focusedBody = moon;
                    this.launchWindow.setCelestialBody(this.focusedBody);
                    this.spaceStationWindow.setCelestialBody(this.focusedBody);
                    this.showSpaceStationMenu = true;
                    double cx = mx - (double)this.field_22789 / 2.0;
                    double cy = my - (double)this.field_22790 / 2.0;
                    this.targetOffsetX = -cx;
                    this.targetOffsetY = -cy;
                    return true;
                }
                for (PlanetInfo planet : PLANETS) {
                    if (!this.isInCurrentGalaxy(planet)) continue;
                    double px = (double)planet.orbitCenter.x + this.offsetX + planet.orbitRadius * Math.cos(planet.currentAngle);
                    double py = (double)planet.orbitCenter.y + this.offsetY + planet.orbitRadius * Math.sin(planet.currentAngle);
                    int planetWidth = (int)((double)planet.width * this.zoomLevel);
                    int planetHeight = (int)((double)planet.height * this.zoomLevel);
                    float planetX = (float)((px - (double)(planet.width / 2.0f)) * this.zoomLevel);
                    float planetY = (float)((py - (double)(planet.height / 2.0f)) * this.zoomLevel);
                    if (!(mouseX >= (double)planetX) || !(mouseX <= (double)(planetX + (float)planetWidth)) || !(mouseY >= (double)planetY) || !(mouseY <= (double)(planetY + (float)planetHeight))) continue;
                    this.focusedBody = planet;
                    this.launchWindow.setCelestialBody(this.focusedBody);
                    this.spaceStationWindow.setCelestialBody(this.focusedBody);
                    this.showSpaceStationMenu = true;
                    double cx = px - (double)this.field_22789 / 2.0;
                    double cy = py - (double)this.field_22790 / 2.0;
                    this.targetZoomLevel = 1.0;
                    this.targetOffsetX = -cx;
                    this.targetOffsetY = -cy;
                    return true;
                }
            }
            if (!this.showSpaceStationMenu && !isArrowHovered && button == 0) {
                this.focusedBody = null;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.dragging = false;
        }
        if (button == 2) {
            this.isWheelButtonDown = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            this.focusedBody = null;
            if (this.isWheelButtonDown) {
                double rotationSpeed = 0.005;
                double deltaAngle = deltaX * rotationSpeed;
                for (PlanetInfo planet : PLANETS) {
                    planet.currentAngle += deltaAngle;
                    planet.updatePosition();
                }
                for (MoonInfo moon : MOONS) {
                    moon.currentAngle += deltaAngle;
                    moon.updatePosition();
                }
            } else {
                double dx = (mouseX - this.lastMouseX) / this.zoomLevel;
                double dy = (mouseY - this.lastMouseY) / this.zoomLevel;
                this.offsetX += dx;
                this.offsetY += dy;
                this.targetOffsetX = this.offsetX;
                this.targetOffsetY = this.offsetY;
                this.lastMouseX = mouseX;
                this.lastMouseY = mouseY;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void updateHighlighterPosition(class_332 graphics, CelestialBody body) {
        float highlightY;
        float highlightX;
        int highlightWidth = (int)((double)body.width * this.zoomLevel);
        int highlightHeight = (int)((double)body.height * this.zoomLevel);
        if (body instanceof PlanetInfo) {
            PlanetInfo planet = (PlanetInfo)body;
            double px = (double)planet.orbitCenter.x + this.offsetX + planet.orbitRadius * Math.cos(planet.currentAngle);
            double py = (double)planet.orbitCenter.y + this.offsetY + planet.orbitRadius * Math.sin(planet.currentAngle);
            highlightX = (float)((px - (double)(planet.width / 2.0f)) * this.zoomLevel);
            highlightY = (float)((py - (double)(planet.height / 2.0f)) * this.zoomLevel);
        } else if (body instanceof MoonInfo) {
            MoonInfo moon = (MoonInfo)body;
            double mx = (double)moon.orbitCenter.x + this.offsetX + moon.orbitRadius * Math.cos(moon.currentAngle);
            double my = (double)moon.orbitCenter.y + this.offsetY + moon.orbitRadius * Math.sin(moon.currentAngle);
            highlightX = (float)((mx - (double)(moon.width / 2.0f)) * this.zoomLevel);
            highlightY = (float)((my - (double)(moon.height / 2.0f)) * this.zoomLevel);
        } else {
            highlightX = (float)(((double)body.x + this.offsetX) * this.zoomLevel - (double)highlightWidth / 2.0);
            highlightY = (float)(((double)body.y + this.offsetY) * this.zoomLevel - (double)highlightHeight / 2.0);
        }
        this.currentHighlighterFrame = (this.currentHighlighterFrame + 1) % 30;
        int frameY = this.currentHighlighterFrame * highlightHeight;
        float currentAngle = body instanceof PlanetInfo ? (float)((PlanetInfo)body).currentAngle : (body instanceof MoonInfo ? (float)((MoonInfo)body).currentAngle : 0.0f);
        ScreenHelper.drawTexturewithRotation(graphics, HIGHLIGHTER_TEXTURE, (int)highlightX, (int)highlightY, 0, frameY, highlightWidth, highlightHeight, highlightWidth, 30 * highlightHeight, currentAngle);
    }

    public PlanetSelectionMenu getMenu() {
        return (PlanetSelectionMenu)this.field_2797;
    }

    public void method_25419() {
        if (this.getPlayer().stellaris$isPlanetMenuOpen()) {
            return;
        }
        long windowHandle = class_310.method_1551().method_22683().method_4490();
        this.prevScrollCallback = GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((class_312)class_310.method_1551().field_1729).method_1598(arg_0, arg_1, arg_2));
        super.method_25419();
    }

    private void renderLaunchPads(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.windowIndex == -1 && this.showSpaceStationMenu) {
            this.setWindowVisible(0);
        }
        if (this.windowIndex != -1) {
            this.moveableWindows.get(this.windowIndex).method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void onSpaceStationButtonClick(CelestialBody body, SpaceStationRecipesManager.SpaceStationRecipeState stationRecipeState, LaunchPad pad) {
        Planet planet = PlanetUtil.getPlanet(body.dimension);
        this.focusedBody = body;
        this.tpToFocusedPlanet(PlanetUtil.getSpaceStationDimension(planet));
        NetworkManager.sendToServer((class_8710)new PlaceStationPacket(PlanetUtil.getSpaceStationDimension(planet), stationRecipeState.recipe(), pad));
    }

    public class_1657 getPlayer() {
        return ((PlanetSelectionMenu)this.field_2797).getPlayer();
    }
}

