/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6382;
import net.minecraft.class_7764;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FluidGaugeWidget
extends class_339 {
    private static final class_1058 WATER_STILL_SPRITE = FluidStackHooks.getStillTexture((class_3611)class_3612.field_15910);
    private final int tank;
    protected final Supplier<? extends UniversalFluidStorage> fluidStorage;
    private class_3611 currFluid = null;
    private int fluidColor = 1;
    protected class_1058 sprite;
    @Nullable
    protected class_2960 overlaySprite;
    protected final GaugeWidget.Direction4 DIRECTION;
    protected int imageWidth;
    protected int imageHeight;

    public FluidGaugeWidget(int x, int y, int width, int height, class_2561 message, Supplier<? extends UniversalFluidStorage> fluidStorage, int tank, GaugeWidget.Direction4 direction) {
        super(x, y, width, height, message);
        this.fluidStorage = fluidStorage;
        this.tank = tank;
        this.overlaySprite = null;
        this.DIRECTION = direction;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        UniversalFluidStorage fluids = this.fluidStorage.get();
        class_3611 fluid = fluids.getFluidInTank(this.tank).getFluid();
        if (fluid != this.currFluid || this.currFluid == null) {
            this.currFluid = fluid;
            this.updateLiquid(this.currFluid);
        }
        long amount = fluids.getFluidInTank(this.tank).getAmount();
        long capacity = fluids.getTankCapacity(this.tank);
        RenderSystem.setShaderColor((float)((float)(this.fluidColor >> 16 & 0xFF) / 255.0f), (float)((float)(this.fluidColor >> 8 & 0xFF) / 255.0f), (float)((float)(this.fluidColor & 0xFF) / 255.0f), (float)((float)(this.fluidColor >> 24 & 0xFF) / 255.0f));
        switch (this.DIRECTION) {
            case DOWN_UP: {
                int i = class_3532.method_15384((double)(this.getProgress(amount, capacity) * (double)(this.method_25364() - 1)));
                for (int j = 0; j < this.field_22758 / this.imageWidth; ++j) {
                    guiGraphics.method_52711(this.sprite, this.imageWidth, this.method_25364(), 0, this.method_25364() - i, this.method_46426() + this.imageWidth * j, this.method_46427() + this.method_25364() - i, 0, this.imageWidth, i);
                }
                int x = this.field_22758 % this.imageWidth;
                if (x <= 0) break;
                guiGraphics.method_52711(this.sprite, x, this.method_25364(), 0, this.method_25364() - i, this.method_46426() + this.field_22758 - x, this.method_46427() + this.method_25364() - i, 0, x, i);
                break;
            }
            case UP_DOWN: {
                int i = class_3532.method_15384((double)(this.getProgress(amount, capacity) * (double)(this.method_25364() - 1)));
                for (int j = 0; j < this.field_22758 / this.imageWidth; ++j) {
                    guiGraphics.method_52711(this.sprite, this.imageWidth, this.method_25364(), 0, 0, this.method_46426() + this.imageWidth * j, this.method_46427(), 0, this.imageWidth, i);
                }
                int x = this.field_22758 % this.imageWidth;
                if (x <= 0) break;
                guiGraphics.method_52711(this.sprite, x, this.method_25364(), 0, 0, this.method_46426() + this.field_22758 - x, this.method_46427(), 0, x, i);
                break;
            }
            case LEFT_RIGHT: {
                int i = class_3532.method_15384((double)(this.getProgress(amount, capacity) * (double)(this.method_25368() - 1)));
                for (int j = 0; j < this.field_22759 / this.imageHeight; ++j) {
                    guiGraphics.method_52711(this.sprite, this.method_25368(), this.imageHeight, 0, 0, this.method_46426(), this.method_46427() + this.imageHeight * j, 0, i, this.imageHeight);
                }
                int y = this.field_22759 % this.imageHeight;
                if (y <= 0) break;
                guiGraphics.method_52711(this.sprite, this.method_25368(), y, 0, 0, this.method_46426(), this.method_46427() + this.field_22759 - y, 0, i, y);
                break;
            }
            case RIGHT_LEFT: {
                int i = class_3532.method_15384((double)(this.getProgress(amount, capacity) * (double)(this.method_25368() - 1)));
                for (int j = 0; j < this.field_22759 / this.imageHeight; ++j) {
                    guiGraphics.method_52711(this.sprite, this.method_25368(), this.imageHeight, this.method_25368() - i, 0, this.method_46426() + this.method_25368() - i, this.method_46427() + this.imageHeight * j, 0, i, this.imageHeight);
                }
                int y = this.field_22759 % this.imageHeight;
                if (y <= 0) break;
                guiGraphics.method_52711(this.sprite, this.method_25368(), y, this.method_25368() - i, 0, this.method_46426() + this.method_25368() - i, this.method_46427() + this.field_22759 - y, 0, i, y);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.overlaySprite != null) {
            guiGraphics.method_52706(this.overlaySprite, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        }
    }

    public void renderTooltip(class_332 graphics, int mouseX, int mouseY, class_327 font) {
        this.renderTooltips(graphics, mouseX, mouseY, font, list -> {});
    }

    public void renderTooltips(class_332 graphics, int mouseX, int mouseY, class_327 font, Consumer<List<class_2561>> components) {
        UniversalFluidStorage fluids = this.fluidStorage.get();
        long amount = fluids.getFluidInTank(this.tank).getAmount();
        long capacity = fluids.getTankCapacity(this.tank);
        String GaugeComponent = this.method_25369().getString() + " : " + amount + " / " + capacity;
        class_2561 capacityComponent = amount >= capacity ? Utils.getMessageComponent(GaugeComponent, "Lime") : (amount <= 0L ? Utils.getMessageComponent(GaugeComponent, "Red") : Utils.getMessageComponent(GaugeComponent, "Orange"));
        ArrayList<class_2561> components1 = new ArrayList<class_2561>();
        components.accept(components1);
        components1.addFirst(capacityComponent);
        if (mouseX >= this.method_46426() && mouseX <= this.method_46426() + this.field_22758 && mouseY >= this.method_46427() && mouseY <= this.method_46427() + this.field_22759) {
            graphics.method_51434(font, components1, mouseX, mouseY);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return false;
    }

    protected double getProgress(Long amount, Long capacity) {
        return class_3532.method_15350((double)((double)amount.longValue() / (double)capacity.longValue()), (double)0.0, (double)1.0);
    }

    public FluidGaugeWidget setOverlaySprite(@Nullable class_2960 overlaySprite) {
        this.overlaySprite = overlaySprite;
        return this;
    }

    private void updateLiquid(class_3611 fluid) {
        class_1058 sprite = FluidStackHooks.getStillTexture((class_3611)fluid);
        if (sprite == null || fluid == class_3612.field_15910) {
            sprite = WATER_STILL_SPRITE;
        }
        this.fluidColor = FluidStackHooks.getColor((class_3611)fluid);
        assert (sprite != null);
        class_7764 contents = sprite.method_45851();
        this.imageHeight = contents.method_45815();
        this.imageWidth = contents.method_45807();
        this.sprite = sprite;
    }
}

