/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.tablet.TabletEntry;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_757;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class TabletButton
extends class_4185 {
    public static final class_2960 TEXTURE = ResourceLocationUtils.guiTexture("util/buttons/button");
    public static final class_2960 HOVER_TEXTURE = ResourceLocationUtils.guiTexture("util/buttons/button");
    private class_2960 buttonTexture;
    private class_2960 hoverButtonTexture;
    private int xTexStart;
    private int yTexStart;
    private int yDiffText;
    private int textureWidth;
    private int textureHeight;
    private TabletEntry.ItemInfo info;

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, class_4185.class_4241 onPressIn, TabletEntry.ItemInfo info) {
        this(xIn, yIn, widthIn, heightIn, (class_2561)class_2561.method_43473(), onPressIn, field_40754, info);
    }

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, class_2561 title, class_4185.class_4241 onPressIn, TabletEntry.ItemInfo info) {
        this(xIn, yIn, widthIn, heightIn, title, onPressIn, field_40754, info);
    }

    public TabletButton(int xIn, int yIn, int widthIn, int heightIn, class_2561 title, class_4185.class_4241 onPressIn, class_4185.class_7841 onTooltipIn, TabletEntry.ItemInfo info) {
        super(xIn, yIn, widthIn, heightIn, title, onPressIn, onTooltipIn);
        this.textureWidth = widthIn;
        this.textureHeight = heightIn;
        this.yDiffText = 0;
        this.xTexStart = 0;
        this.yTexStart = 0;
        this.buttonTexture = TEXTURE;
        this.hoverButtonTexture = HOVER_TEXTURE;
        this.info = info;
        this.setTooltip();
    }

    public void setTooltip() {
        switch (this.info.iconType()) {
            case "item": {
                this.info.components().stream().filter(c -> c.type().equals("item")).toList().getFirst();
                break;
            }
            case "entity": {
                this.info.components().stream().filter(c -> c.type().equals("entity")).findFirst().ifPresent(entity -> {
                    class_1297 entity1 = ScreenHelper.createEntity((class_1937)class_310.method_1551().field_1687, entity.entity().get().entity());
                    Stellaris.LOG.info("Entity: {}", (Object)entity1.method_5476());
                    this.tooltip(class_7919.method_47407((class_2561)entity1.method_5476()));
                });
            }
        }
    }

    public <T extends TabletButton> T tooltip(@Nullable class_7919 tooltip) {
        this.method_47400(tooltip);
        return this.cast();
    }

    private <T extends TabletButton> T cast() {
        return (T)((Object)this);
    }

    public <T extends TabletButton> T tex(class_2960 buttonTexture, class_2960 hovorTexture) {
        this.buttonTexture = buttonTexture;
        this.hoverButtonTexture = hovorTexture;
        return this.cast();
    }

    public <T extends TabletButton> T size(int texWidth, int texHeight) {
        this.textureWidth = texWidth;
        this.textureHeight = texHeight;
        return this.cast();
    }

    public <T extends TabletButton> T setUVs(int xTexStart, int yTexStart) {
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        return this.cast();
    }

    public void setYShift(int y) {
        this.yDiffText = y;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        int i = this.yTexStart;
        if (this.method_25367()) {
            i += this.yDiffText;
        }
        class_2960 texture = this.getTypeTexture(this.field_22762, this.buttonTexture, this.hoverButtonTexture);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        ScreenHelper.renderTextureWithColor.blit(graphics.method_51448(), this.method_46426(), this.method_46427(), this.xTexStart, i, this.field_22758, this.field_22759, this.textureWidth, this.textureHeight, this.getTypeColor());
        switch (this.info.iconType()) {
            case "item": {
                this.info.components().stream().filter(c -> c.type().equals("item")).findFirst().ifPresent(item -> ScreenHelper.renderItemWithCustomSize(graphics, minecraft, item.item().get().stack(), this.method_46426(), this.method_46427(), this.field_22758));
                break;
            }
            case "entity": {
                this.info.components().stream().filter(c -> c.type().equals("entity")).findFirst().ifPresent(entity -> {
                    class_1297 entity1 = ScreenHelper.createEntity((class_1937)class_310.method_1551().field_1687, entity.entity().get().entity());
                    ScreenHelper.renderEntityInInventory(graphics, this.method_46426(), this.method_46427(), 7.0f, new Vector3f(1.5f, 2.5f, 0.0f), new Quaternionf(-1.0f, 0.0f, 0.0f, 0.0f), null, entity1);
                });
            }
        }
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
    }

    private class_2960 getTypeTexture(boolean hover, class_2960 buttonTexture, class_2960 hoverButtonTexture) {
        if (hover) {
            return hoverButtonTexture;
        }
        return buttonTexture;
    }

    protected class_243 getTypeColor() {
        return TexturedButton.ColorTypes.DEFAULT.getColor();
    }
}

