/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.windows;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.components.CustomCheckBox;
import com.st0x0ef.stellaris.client.screens.components.SpaceStationList;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.info.CelestialBody;
import com.st0x0ef.stellaris.client.screens.windows.MoveableWindow;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipesManager;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadUtils;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class SpaceStationWindow
extends MoveableWindow {
    public final PlanetSelectionScreen parent;
    public SpaceStationRecipesManager.SpaceStationRecipeState spaceStationSelected;
    public CelestialBody celestialBody;
    private SpaceStationList stationList;
    private class_342 nameBox;
    private CustomCheckBox publicCheckBox;
    private TexturedButton launchButton;

    public SpaceStationWindow(int width, int height, class_2561 message, PlanetSelectionScreen parent) {
        super(width, height, message, (class_437)parent);
        this.parent = parent;
    }

    @Override
    public void init() {
        this.stationList = new SpaceStationList(this.getWindowX() + 60, this.getWindowY() + 75, this.method_25368() - 120, this.method_25364() - 130, (class_2561)class_2561.method_43471((String)"gui.stellaris.launchpads"), this);
        this.addWidget(this.stationList);
        this.nameBox = new class_342(class_310.method_1551().field_1772, 150, 20, (class_2561)class_2561.method_43470((String)"name"));
        this.nameBox.method_48229(this.stationList.method_46426(), this.getWindowY() + 50);
        this.nameBox.setSprites(new class_8666(GUISprites.EDIT_BAR, GUISprites.EDIT_BAR));
        this.addWidget(this.nameBox);
        this.publicCheckBox = new CustomCheckBox(this.nameBox.method_46426() + this.stationList.method_25368() - 21, this.getWindowY() + 50, 20, (class_2561)class_2561.method_43471((String)"gui.stellaris.public"), class_310.method_1551().field_1772, false).setTexture(GUISprites.CHECKBOX, GUISprites.CHECKBOX_SELECTED).showText(false);
        this.addWidget(this.publicCheckBox);
        this.launchButton = new TexturedButton((this.getWindowX() + this.method_25368()) / 2 + 25 - 3, this.stationList.method_46427() + this.stationList.method_25364(), 50, 20, button -> this.onStationCreated()).tex(class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button.png"), class_2960.method_60655((String)"stellaris", (String)"textures/gui/util/buttons/launch_button_hovered.png"));
        this.addWidget(this.launchButton);
    }

    @Override
    public void renderWindow(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        guiGraphics.method_25290(class_2960.method_60654((String)"stellaris:textures/gui/util/window/window_large.png"), this.getWindowX(), this.getWindowY(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
        guiGraphics.method_25300(class_310.method_1551().field_1772, "Create a Space Station", this.getWindowX() + this.method_25368() / 2, this.getWindowY() + 23, -1);
        this.parent.dragging = false;
        guiGraphics.method_51452();
    }

    @Override
    public void close() {
        GLFW.glfwSetScrollCallback((long)class_310.method_1551().method_22683().method_4490(), this.parent::onMouseScroll);
    }

    @Override
    public Consumer<MoveableWindow> resize(class_310 minecraft, int width, int height) {
        return window -> {
            if (window instanceof SpaceStationWindow) {
                this.stationList.spaceStationRecipeStates = SpaceStationList.getSpaceStationRecipeStates();
            }
        };
    }

    public void onStationCreated() {
        Stellaris.LOG.info("Creating space station with name: {}", (Object)this.celestialBody);
        if (!this.nameBox.method_1882().isEmpty() && this.spaceStationSelected != null && this.celestialBody != null && PlanetUtil.getPlanet(this.celestialBody.dimension) != null) {
            Planet planet = PlanetUtil.getPlanet(this.celestialBody.dimension);
            LaunchPad pad = new LaunchPad(LaunchPadUtils.getNextLaunchPadId(), new class_243(0.0, 0.0, 0.0), (class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)PlanetUtil.getSpaceStationDimension(planet)), this.nameBox.method_1882(), this.publicCheckBox.selected, this.parent.getPlayer().method_5477().getString(), List.of());
            this.parent.onSpaceStationButtonClick(this.celestialBody, this.spaceStationSelected, pad);
        }
    }

    public void setCelestialBody(@Nullable CelestialBody celestialBody) {
        this.celestialBody = celestialBody;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.close();
            return true;
        }
        if (this.nameBox.method_25370() || this.nameBox.method_49606() || keyCode == 32) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.stationList.method_49606()) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public int getMoveLimit() {
        return 15;
    }
}

