/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5250;
import net.minecraft.class_9129;

public class SpaceStationRecipesManager
extends class_4309 {
    public static final List<SpaceStationRecipe> SPACE_STATION_RECIPES = new ArrayList<SpaceStationRecipe>();

    public SpaceStationRecipesManager() {
        super(Stellaris.GSON, "space_stations");
    }

    protected void apply(Map<class_2960, JsonElement> resourceLocationJsonElementMap, class_3300 resourceManager, class_3695 profiler) {
        SPACE_STATION_RECIPES.clear();
        resourceLocationJsonElementMap.forEach((key, value) -> {
            JsonObject json = class_3518.method_15295((JsonElement)value, (String)"space_stations");
            SpaceStationRecipe recipe = (SpaceStationRecipe)SpaceStationRecipe.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            Stellaris.LOG.debug("Loaded space station recipe: {}", (Object)recipe.location());
            SPACE_STATION_RECIPES.add(recipe);
        });
    }

    public static List<SpaceStationRecipe> getSpaceStationRecipes() {
        return SPACE_STATION_RECIPES;
    }

    public static class_9129 toBuffer(List<SpaceStationRecipe> recipes, class_9129 buffer) {
        buffer.method_53002(recipes.size());
        recipes.forEach(recipe -> SpaceStationRecipe.toBuffer(recipe, buffer));
        return buffer;
    }

    public static List<SpaceStationRecipe> readFromBuffer(class_9129 buffer) {
        ArrayList<SpaceStationRecipe> recipes = new ArrayList<SpaceStationRecipe>();
        int k = buffer.readInt();
        for (int i = 0; i < k; ++i) {
            recipes.add(SpaceStationRecipe.readFromBuffer(buffer));
        }
        return recipes;
    }

    public static void addRecipes(List<SpaceStationRecipe> recipes) {
        SPACE_STATION_RECIPES.clear();
        SPACE_STATION_RECIPES.addAll(recipes);
    }

    public static class_5250 getTotalTooltip(List<SpaceStationRecipeState> recipes) {
        class_5250 tooltip = class_2561.method_43473();
        for (SpaceStationRecipeState recipe : recipes) {
            tooltip.method_10852((class_2561)recipe.tooltip);
            tooltip.method_27693("\n");
        }
        return tooltip;
    }

    public record SpaceStationRecipeState(SpaceStationRecipe recipe, class_5250 tooltip, boolean isUnlocked) {
    }
}

