/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles;

import com.google.common.collect.Sets;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.RocketModel;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data_components.RocketComponent;
import com.st0x0ef.stellaris.common.entities.vehicles.IVehicleEntity;
import com.st0x0ef.stellaris.common.items.VehicleUpgradeItem;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.menus.RocketMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncRocketComponentPacket;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.SoundRegistry;
import com.st0x0ef.stellaris.common.registry.StatsRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import com.st0x0ef.stellaris.common.vehicle_upgrade.ModelUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.MotorUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.SkinUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.TankUpgrade;
import com.st0x0ef.stellaris.common.vehicle_upgrade.VehicleUpgrade;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.minecraft.class_7225;
import net.minecraft.class_7248;
import net.minecraft.class_8710;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RocketEntity
extends IVehicleEntity
implements class_7248 {
    public int START_TIMER;
    public boolean needsModelChange = false;
    public SkinUpgrade SKIN_UPGRADE;
    public ModelUpgrade MODEL_UPGRADE;
    public MotorUpgrade MOTOR_UPGRADE;
    public TankUpgrade TANK_UPGRADE;
    protected class_1277 inventory;
    private RocketComponent rocketComponent;
    private class_1657 lastPlayer;
    private static final class_2940<String> DATA_SKIN = class_2945.method_12791(RocketEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Boolean> ROCKET_START;
    private static final class_2940<String> DATA_MODEL;

    public RocketEntity(class_1299<? extends RocketEntity> entityType, class_1937 level) {
        this(entityType, level, SkinUpgrade.getBasic());
    }

    protected RocketEntity(class_1299<? extends RocketEntity> entityType, class_1937 level, SkinUpgrade skinUpgrade) {
        super(entityType, level);
        this.SKIN_UPGRADE = skinUpgrade;
        this.MODEL_UPGRADE = ModelUpgrade.getBasic();
        this.MOTOR_UPGRADE = MotorUpgrade.getBasic(true);
        this.TANK_UPGRADE = TankUpgrade.getBasic();
        this.START_TIMER = 0;
        this.FUEL = 0;
        this.FUEL_TYPE = FuelType.Type.FUEL;
        this.rocketComponent = new RocketComponent(this.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(this.MODEL_UPGRADE.getModel().toString()), this.FUEL_TYPE.method_15434(), this.FUEL, this.FUEL_TYPE.getFuelTexture(), this.TANK_UPGRADE.getTankCapacity());
        this.inventory = new class_1277(14);
    }

    public void setRocketComponent(RocketComponent rocketComponent) {
        this.rocketComponent = rocketComponent;
        this.MODEL_UPGRADE = rocketComponent.getModelUpgrade();
        this.SKIN_UPGRADE = rocketComponent.getSkinUpgrade();
        this.MOTOR_UPGRADE = rocketComponent.getMotorUpgrade();
        this.TANK_UPGRADE = rocketComponent.getTankUpgrade();
        this.FUEL = rocketComponent.getFuel();
        this.FUEL_TYPE = rocketComponent.getFuelType();
    }

    @Override
    public boolean setPassengersRiding() {
        return false;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_23318() > (double)Stellaris.CONFIG.rocketTpHeight) {
            this.openPlanetMenu(this.getFirstPlayerPassenger());
            this.method_5685().forEach(entity -> {
                class_1657 passenger;
                if (entity instanceof class_1657 && !(passenger = (class_1657)entity).method_5779((class_1297)this.getFirstPlayerPassenger())) {
                    this.openWaitMenu(passenger);
                }
            });
        }
        this.rocketExplosion();
        this.burnEntities();
        this.checkContainer();
        if (KeyVariables.isHoldingJump(this.getFirstPlayerPassenger())) {
            this.startRocket();
        }
        if (((Boolean)this.field_6011.method_12789(ROCKET_START)).booleanValue()) {
            this.spawnParticle();
            this.startTimerAndFlyMovement();
        }
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10566("InventoryCustom", (class_2520)this.inventory.method_7660((class_7225.class_7874)this.method_56673()));
        compound.method_10569("fuel", this.FUEL);
        if (this.FUEL != 0) {
            compound.method_10582("currentFuelItemType", this.FUEL_TYPE.method_15434());
        }
        class_2499 listTag = new class_2499();
        for (int i = 1; i < this.inventory.method_5439(); ++i) {
            class_1799 itemStack = this.inventory.method_5438(i);
            if (itemStack.method_7960()) continue;
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10567("Slot", (byte)(i - 1));
            listTag.add((Object)itemStack.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)compoundTag));
        }
        compound.method_10566("Items", (class_2520)listTag);
    }

    protected void method_5749(class_2487 compound) {
        class_2499 inventoryCustom = compound.method_10554("InventoryCustom", 14);
        this.inventory.method_7659(inventoryCustom, (class_7225.class_7874)this.method_56673());
        this.FUEL = compound.method_10550("fuel");
        if (this.FUEL != 0) {
            this.FUEL_TYPE = FuelType.Type.fromString(compound.method_10558("currentFuelItemType"));
        }
        class_2499 listTag = compound.method_10554("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compoundTag = listTag.method_10602(i);
            int j = compoundTag.method_10571("Slot") & 0xFF;
            if (j >= this.inventory.method_5439() - 1) continue;
            this.inventory.method_5447(j + 1, class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)compoundTag).orElse(class_1799.field_8037));
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_SKIN, (Object)SkinUpgrade.getBasic().getRocketSkinLocation().toString());
        builder.method_56912(DATA_MODEL, (Object)ModelUpgrade.getBasic().getModel().toString());
        builder.method_56912(ROCKET_START, (Object)false);
    }

    public SkinUpgrade getSkinData() {
        return new SkinUpgrade(class_2960.method_60654((String)((String)this.field_6011.method_12789(DATA_SKIN))));
    }

    public void setSkinData() {
        this.field_6011.method_12778(DATA_SKIN, (Object)this.SKIN_UPGRADE.getRocketSkinLocation().toString());
    }

    public ModelUpgrade getModelData() {
        return new ModelUpgrade(RocketModel.fromString((String)this.field_6011.method_12789(DATA_MODEL)));
    }

    public void setModelData() {
        this.field_6011.method_12778(DATA_MODEL, (Object)this.MODEL_UPGRADE.getModel().toString());
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_30948() {
        return false;
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        super.method_5688(player, hand);
        class_1269 result = class_1269.method_29236((boolean)this.method_37908().field_9236);
        if (!this.method_37908().field_9236) {
            if (player.method_18276()) {
                if (!this.tryFillUpRocket(player.method_6047().method_7909())) {
                    this.method_6722(player);
                } else {
                    player.method_5998(hand).method_7934(1);
                    player.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8550));
                }
                return class_1269.field_21466;
            }
            if (this.canPlayerRide()) {
                this.doPlayerRide((class_1297)player);
            }
            return class_1269.field_21466;
        }
        return result;
    }

    public boolean canPlayerRide() {
        int maxPlayer = this.MODEL_UPGRADE.getModel().getMaxPlayerNumber();
        return this.method_5685().size() < maxPlayer;
    }

    public class_243 method_52538(class_1297 entity) {
        return this.method_19538().method_1019(this.method_52533(entity, this.method_18377(this.method_18376()), 1.0f)).method_1023(0.0, this.MODEL_UPGRADE.getModel().getPlayerYPos(), 0.0);
    }

    public void method_6722(class_1657 player) {
        this.lastPlayer = player;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            MenuRegistry.openExtendedMenu((class_3222)serverPlayer, (ExtendedMenuProvider)new ExtendedMenuProvider(){

                public void saveExtraData(class_2540 packetByteBuf) {
                    packetByteBuf.method_10804(RocketEntity.this.method_5628());
                }

                public class_2561 method_5476() {
                    return class_2561.method_43470((String)"Rocket");
                }

                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    class_2540 packetBuffer = new class_2540(Unpooled.buffer());
                    packetBuffer.method_53002(RocketEntity.this.FUEL);
                    packetBuffer.method_10804(RocketEntity.this.method_5628());
                    return new RocketMenu(syncId, inv, (class_1263)RocketEntity.this.inventory, RocketEntity.this.method_5628());
                }
            });
        }
    }

    public void method_5768() {
        this.dropEquipment();
        this.spawnRocketItem();
        if (!this.method_37908().field_9236) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 sourceEntity = source.method_5529();
        if (sourceEntity != null && sourceEntity.method_18276() && !this.method_5782()) {
            this.spawnRocketItem();
            this.dropEquipment();
            if (!this.method_37908().field_9236) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public class_243 method_24829(class_1309 livingEntity) {
        class_243[] avector3d = new class_243[]{RocketEntity.method_24826((double)this.method_17681(), (double)livingEntity.method_17681(), (float)livingEntity.method_36454()), RocketEntity.method_24826((double)this.method_17681(), (double)livingEntity.method_17681(), (float)(livingEntity.method_36454() - 22.5f)), RocketEntity.method_24826((double)this.method_17681(), (double)livingEntity.method_17681(), (float)(livingEntity.method_36454() + 22.5f)), RocketEntity.method_24826((double)this.method_17681(), (double)livingEntity.method_17681(), (float)(livingEntity.method_36454() - 45.0f)), RocketEntity.method_24826((double)this.method_17681(), (double)livingEntity.method_17681(), (float)(livingEntity.method_36454() + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.method_5829().field_1325;
        double d1 = this.method_5829().field_1322 - 0.5;
        class_2338.class_2339 blockpos$mutable = new class_2338.class_2339();
        for (class_243 vector3d : avector3d) {
            blockpos$mutable.method_10102(this.method_23317() + vector3d.field_1352, d0, this.method_23321() + vector3d.field_1350);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.method_10062());
                blockpos$mutable.method_10098(class_2350.field_11033);
            }
        }
        for (class_2338 blockpos : set) {
            double d3;
            if (this.method_37908().method_8316(blockpos).method_15767(class_3486.field_15518) || !class_5275.method_27932((double)(d3 = this.method_37908().method_30347(blockpos)))) continue;
            class_243 vector3d1 = class_243.method_26410((class_2382)blockpos, (double)d3);
            for (class_4050 pose : livingEntity.method_24831()) {
                if (!class_5275.method_27932((double)this.method_37908().method_30347(blockpos))) continue;
                livingEntity.method_18380(pose);
                return vector3d1;
            }
        }
        return new class_243(this.method_23317(), this.method_5829().field_1325, this.method_23321());
    }

    @Nullable
    public class_1799 method_31480() {
        return null;
    }

    public void spawnParticle() {
        block4: {
            class_1937 class_19372 = this.method_37908();
            if (!(class_19372 instanceof class_3218)) break block4;
            class_3218 level = (class_3218)class_19372;
            class_243 vec = this.method_18798();
            if (this.START_TIMER == 200) {
                for (class_3222 player : level.method_8503().method_3760().method_14571()) {
                    level.method_14166(player, (class_2394)class_2398.field_11240, true, this.method_23317() - vec.field_1352, this.method_23318() - vec.field_1351 - 2.2, this.method_23321() - vec.field_1350, 20, 0.1, 0.1, 0.1, 0.001);
                    level.method_14166(player, (class_2394)class_2398.field_11240, true, this.method_23317() - vec.field_1352, this.method_23318() - vec.field_1351 - 3.2, this.method_23321() - vec.field_1350, 10, 0.1, 0.1, 0.1, 0.04);
                }
            } else {
                for (class_3222 player : level.method_8503().method_3760().method_14571()) {
                    level.method_14166(player, (class_2394)class_2398.field_17430, true, this.method_23317() - vec.field_1352, this.method_23318() - vec.field_1351 - 0.1, this.method_23321() - vec.field_1350, 6, 0.1, 0.1, 0.1, 0.023);
                }
            }
        }
    }

    public void startRocket() {
        class_1657 player = this.getFirstPlayerPassenger();
        if (player != null) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.syncRocketData(serverPlayer);
            }
            if (this.FUEL > 0 || player.method_7337()) {
                if (!((Boolean)this.field_6011.method_12789(ROCKET_START)).booleanValue()) {
                    this.field_6011.method_12778(ROCKET_START, (Object)true);
                    player.method_7281((class_2960)StatsRegistry.ROCKET_LAUNCHED.get());
                    this.method_37908().method_43129(player, (class_1297)this, (class_3414)SoundRegistry.ROCKET_SOUND.get(), class_3419.field_15254, 1.0f, 1.0f);
                }
            } else {
                player.method_7353((class_2561)class_2561.method_43469((String)"text.stellaris.rocket.fuel", (Object[])new Object[]{this.MOTOR_UPGRADE.getFuelType().method_15434()}), true);
            }
        }
    }

    public void startTimerAndFlyMovement() {
        if (this.START_TIMER < 200) {
            ++this.START_TIMER;
        }
        if (this.START_TIMER == 200) {
            if (this.method_18798().field_1351 < this.getRocketSpeed() - 0.1) {
                this.method_18800(this.method_18798().field_1352, this.method_18798().field_1351 + 0.1, this.method_18798().field_1350);
            } else {
                this.method_18800(this.method_18798().field_1352, this.getRocketSpeed(), this.method_18798().field_1350);
            }
        }
    }

    private void destroyRocket(boolean explode) {
        if (!this.method_37908().field_9236) {
            if (explode) {
                this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_5829().field_1325, this.method_23321(), 10.0f, true, class_1937.class_7867.field_40891);
            }
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public void rocketExplosion() {
        if (this.START_TIMER == 200 && this.method_18798().field_1351 < -0.07) {
            this.destroyRocket(true);
        }
    }

    public class_1657 getFirstPlayerPassenger() {
        if (!this.method_5685().isEmpty()) {
            for (int i = 0; i < this.method_5685().size(); ++i) {
                Object e = this.method_5685().get(i);
                if (!(e instanceof class_1657)) continue;
                class_1657 player = (class_1657)e;
                return player;
            }
        }
        return null;
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.method_54454().size(); ++i) {
            class_1799 itemstack = this.inventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            this.method_5775(itemstack);
        }
    }

    public class_1799 getRocketItem() {
        class_1799 rocket = new class_1799((class_1935)ItemsRegistry.ROCKET.get(), 1);
        rocket.method_57379((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get(), (Object)this.rocketComponent);
        return rocket;
    }

    protected void doPlayerRide(class_1297 player) {
        if (!this.method_37908().field_9236) {
            class_243 entityPos = player.method_30950(0.0f);
            player.method_23327(entityPos.field_1352, entityPos.field_1351 + 40.0, entityPos.field_1350);
            player.method_5873((class_1297)this, true);
        }
    }

    private void checkContainer() {
        VehicleUpgrade upgrade;
        VehicleUpgrade vehicleUpgrade;
        VehicleUpgradeItem item;
        if (this.method_37908().field_9236) {
            return;
        }
        class_1792 class_17922 = this.getInventory().method_5438(2).method_7909();
        if (class_17922 instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)class_17922;
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof MotorUpgrade) {
                upgrade = (MotorUpgrade)vehicleUpgrade;
                this.MOTOR_UPGRADE = upgrade;
            }
        } else if (this.getInventory().method_5438(2).method_7960()) {
            this.MOTOR_UPGRADE = MotorUpgrade.getBasic(true);
        }
        upgrade = this.getInventory().method_5438(3).method_7909();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof TankUpgrade) {
                upgrade = (TankUpgrade)vehicleUpgrade;
                this.TANK_UPGRADE = upgrade;
            }
        } else if (this.getInventory().method_5438(3).method_7960()) {
            this.TANK_UPGRADE = TankUpgrade.getBasic();
        }
        upgrade = this.getInventory().method_5438(4).method_7909();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof SkinUpgrade) {
                upgrade = (SkinUpgrade)vehicleUpgrade;
                this.SKIN_UPGRADE = upgrade;
                this.setSkinData();
            }
        } else if (this.getInventory().method_5438(4).method_7960()) {
            this.SKIN_UPGRADE = SkinUpgrade.getBasic();
            this.setSkinData();
        }
        upgrade = this.getInventory().method_5438(5).method_7909();
        if (upgrade instanceof VehicleUpgradeItem) {
            item = (VehicleUpgradeItem)((Object)upgrade);
            vehicleUpgrade = item.getUpgrade();
            if (vehicleUpgrade instanceof ModelUpgrade) {
                upgrade = (ModelUpgrade)vehicleUpgrade;
                if (this.MODEL_UPGRADE.getModel() != ((ModelUpgrade)upgrade).getModel()) {
                    this.MODEL_UPGRADE = upgrade;
                    this.setModelData();
                    this.needsModelChange = true;
                    this.changeRocketModel();
                }
            }
        } else if (this.getInventory().method_5438(5).method_7960()) {
            this.MODEL_UPGRADE = ModelUpgrade.getBasic();
            this.setModelData();
            if (this.needsModelChange) {
                this.needsModelChange = false;
                this.changeRocketModel();
            }
        }
        this.tryFillUpRocket(this.getInventory().method_5438(0).method_7909());
    }

    public boolean tryFillUpRocket(class_1792 item) {
        if (this.method_37908().field_9236) {
            return false;
        }
        if (this.FUEL >= this.TANK_UPGRADE.getTankCapacity() || item == null) {
            return false;
        }
        FuelType.Type itemType = FuelType.Type.getTypeBasedOnItem(item);
        if (itemType == null) {
            return false;
        }
        FuelType.Type motorType = this.MOTOR_UPGRADE.getFuelType();
        if (motorType == itemType.getMotorType()) {
            if (this.FUEL == 0) {
                this.FUEL_TYPE = itemType;
            }
            if (itemType == this.FUEL_TYPE) {
                class_1799 fuelItem;
                this.FUEL += 1000;
                if (this.FUEL > this.TANK_UPGRADE.getTankCapacity()) {
                    this.FUEL = this.TANK_UPGRADE.getTankCapacity();
                }
                if ((fuelItem = this.inventory.method_5434(0, 1)).method_31574((class_1792)ItemsRegistry.FUEL_BUCKET.get()) || fuelItem.method_31574((class_1792)ItemsRegistry.HYDROGEN_BUCKET.get())) {
                    this.inventory.method_5447(1, new class_1799((class_1935)class_1802.field_8550, this.inventory.method_5438(1).method_7947() + 1));
                }
                return true;
            }
        }
        return false;
    }

    private void openPlanetMenu(class_1657 player) {
        if (player == null) {
            return;
        }
        if (!player.stellaris$isPlanetMenuOpen()) {
            player.method_5875(true);
            player.method_5854().method_5875(true);
            PlanetUtil.openPlanetSelectionMenu(player, player.method_7337(), "stellaris:milky_way");
            player.stellaris$setPlanetMenuOpen(true, player, true);
        }
    }

    private void openWaitMenu(class_1657 player) {
        if (player == null) {
            return;
        }
        if (!player.stellaris$isPlanetMenuOpen()) {
            player.method_5875(true);
            player.method_5854().method_5875(true);
            PlanetUtil.openWaitMenu(player, this.getFirstPlayerPassenger().method_5476().getString());
            player.stellaris$setPlanetMenuOpen(true, player, true);
        }
    }

    public void burnEntities() {
        if (this.START_TIMER == 200) {
            class_238 aabb = class_238.method_30048((class_243)new class_243(this.method_23317(), this.method_23318() - 2.0, this.method_23321()), (double)2.0, (double)2.0, (double)2.0);
            List entities = this.method_5770().method_18467(class_1309.class, aabb);
            for (class_1309 entity : entities) {
                entity.method_20803(40);
            }
        }
    }

    protected void spawnRocketItem() {
        class_1542 entityToSpawn = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), this.getRocketItem());
        entityToSpawn.method_6982(10);
        entityToSpawn.method_6983().method_57379((class_9331)DataComponentsRegistry.ROCKET_COMPONENT.get(), (Object)this.rocketComponent);
        this.method_37908().method_8649((class_1297)entityToSpawn);
    }

    public int getTankCapacity() {
        return this.TANK_UPGRADE.getTankCapacity();
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    public double getRocketSpeed() {
        return 0.8;
    }

    public class_2960 getFullSkinTexture() {
        String texture = this.getSkinData().getRocketSkinLocation().toString();
        if (this.MODEL_UPGRADE != null) {
            texture = texture.replace("normal", this.getModelData().getModel().toString());
        }
        return class_2960.method_60654((String)texture);
    }

    public boolean canGoTo(Planet actual, Planet destination) {
        return (float)class_3532.method_15382((int)(actual.distanceFromEarth() - destination.distanceFromEarth())) <= FuelType.getMegametersTraveled(this.FUEL, this.FUEL_TYPE);
    }

    public void syncRocketData(class_3222 player) {
        this.rocketComponent = new RocketComponent(this.SKIN_UPGRADE.getRocketSkinLocation().toString(), RocketModel.fromString(this.MODEL_UPGRADE.getModel().toString()), this.FUEL_TYPE.method_15434(), this.FUEL, this.FUEL_TYPE.getFuelTexture(), this.TANK_UPGRADE.getTankCapacity());
        if (!this.method_37908().method_8608()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)new SyncRocketComponentPacket(this.rocketComponent));
        }
    }

    public void changeRocketModel() {
        if (this.lastPlayer != null) {
            this.lastPlayer.method_7346();
        }
        class_2371 itemStacks = this.inventory.method_54454();
        class_243 pos = this.method_19538();
        class_1299<? extends RocketEntity> newRocketType = this.getEntityType(this.MODEL_UPGRADE);
        RocketEntity newRocketEntity = new RocketEntity(newRocketType, this.method_37908());
        newRocketEntity.method_33574(pos);
        newRocketEntity.method_36456(this.method_36454());
        newRocketEntity.setModelData();
        newRocketEntity.setSkinData();
        newRocketEntity.setRocketComponent(this.rocketComponent);
        newRocketEntity.MODEL_UPGRADE = this.MODEL_UPGRADE;
        newRocketEntity.needsModelChange = this.needsModelChange;
        newRocketEntity.setModelData();
        newRocketEntity.setSkinData();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            newRocketEntity.inventory.method_5447(i, (class_1799)itemStacks.get(i));
        }
        List passengers = this.method_5685();
        this.method_5650(class_1297.class_5529.field_26999);
        newRocketEntity.method_37908().method_8649((class_1297)newRocketEntity);
        for (class_1297 passenger : passengers) {
            passenger.method_5804((class_1297)newRocketEntity);
        }
        newRocketEntity.method_6722(this.lastPlayer);
    }

    public class_1299<? extends RocketEntity> getEntityType(ModelUpgrade upgrade) {
        return switch (upgrade.getModel()) {
            default -> throw new MatchException(null, null);
            case RocketModel.TINY -> (class_1299)EntityRegistry.TINY_ROCKET.get();
            case RocketModel.SMALL -> (class_1299)EntityRegistry.SMALL_ROCKET.get();
            case RocketModel.NORMAL -> (class_1299)EntityRegistry.NORMAL_ROCKET.get();
            case RocketModel.BIG -> (class_1299)EntityRegistry.BIG_ROCKET.get();
        };
    }

    public RocketComponent getRocketComponent() {
        return this.rocketComponent;
    }

    static {
        DATA_MODEL = class_2945.method_12791(RocketEntity.class, (class_2941)class_2943.field_13326);
        ROCKET_START = class_2945.method_12791(RocketEntity.class, (class_2941)class_2943.field_13323);
    }
}

